/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.impl.dom;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class TagImpl {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$impl$dom$TagImpl == null ? (class$com$tssap$j2ee$model$impl$dom$TagImpl = TagImpl.class$("com.tssap.j2ee.model.impl.dom.TagImpl")) : class$com$tssap$j2ee$model$impl$dom$TagImpl));
    private static final String DEFAULT_VALUE = "";
    private static final String DEFAULT_ATTRIBUTE_VALUE = "";
    private static final String[] DEFAULT_CHILD_TAGNAMES = new String[0];
    private Element tagElement;
    private TagImpl parentTagImpl;
    private String tagName;
    private String[] childTagNames;
    static /* synthetic */ Class class$com$tssap$j2ee$model$impl$dom$TagImpl;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    protected TagImpl(TagImpl parent, Element element, String tagName, String[] childTagNames) {
        this.parentTagImpl = parent;
        this.tagName = tagName;
        this.childTagNames = childTagNames;
        this.tagElement = element;
        this.createElement();
    }

    protected TagImpl(TagImpl parent, Element element, String tagName) {
        this(parent, element, tagName, DEFAULT_CHILD_TAGNAMES);
    }

    public TagImpl getParentTagImpl() {
        return this.parentTagImpl;
    }

    protected void initElement() {
    }

    public final String getTagName() {
        return this.tagName;
    }

    protected final String[] getChildTagNames() {
        return this.childTagNames;
    }

    protected Element createElement() {
        Element ret = this.getElement();
        if (ret == null) {
            Element parentEl = this.getParentTagImpl().createElement();
            ret = parentEl.getOwnerDocument().createElementNS(parentEl.getNamespaceURI(), this.getTagName());
            this.initElement();
            Element insBeforeElement = this.getParentTagImpl().findNextElement(this.getTagName());
            parentEl.insertBefore(ret, insBeforeElement);
            this.setElement(ret);
        }
        return ret;
    }

    protected Element findNextElement(String childTagName) {
        Hashtable<String, Element> childElementTable = new Hashtable<String, Element>();
        Element[] childElements = this.getAllChildElements();
        int i = 0;
        while (i < childElements.length) {
            if (!childElementTable.containsKey(childElements[i].getTagName())) {
                childElementTable.put(childElements[i].getTagName(), childElements[i]);
            }
            ++i;
        }
        String[] childTagNames = this.getChildTagNames();
        int childIndex = -1;
        int i2 = 0;
        while (i2 < childTagNames.length && childIndex < 0) {
            if (childTagNames[i2].equals(childTagName)) {
                childIndex = i2;
            }
            ++i2;
        }
        Element nextElement = null;
        if (childIndex >= 0) {
            int i3 = childIndex + 1;
            while (i3 < childTagNames.length && nextElement == null) {
                String nextChildTagName = childTagNames[i3];
                nextElement = (Element)childElementTable.get(nextChildTagName);
                ++i3;
            }
        }
        return nextElement;
    }

    public Element getElement() {
        return this.tagElement;
    }

    private void setElement(Element newElement) {
        this.tagElement = newElement;
    }

    public void removeElement() {
        Element elem = this.getElement();
        if (elem != null) {
            Element parentEl = this.getParentTagImpl().getElement();
            parentEl.removeChild(elem);
            this.setElement(null);
        }
    }

    public boolean elementExists() {
        return this.getElement() != null;
    }

    protected Element[] getAllChildElements() {
        return this.getChildElements(null);
    }

    protected Element[] getChildElements(String tagName) {
        return TagImpl.getChildElements(this.getElement(), tagName);
    }

    protected Element getFirstChildElement(String tagName) {
        return TagImpl.getFirstChildElement(this.getElement(), tagName);
    }

    protected String getAttribute(String attribName) {
        String attributeValue = "";
        if (this.elementExists()) {
            attributeValue = this.getElement().getAttribute(attribName);
        }
        return attributeValue;
    }

    protected void setAttribute(String attribName, String attribValue) {
        if (!this.elementExists()) {
            this.createElement();
        }
        this.getElement().setAttribute(attribName, attribValue);
    }

    protected void removeAttribute(String attribName) {
        if (this.elementExists()) {
            this.getElement().removeAttribute(attribName);
        }
    }

    protected String[] getAllAttributeKeys() {
        String[] ret = new String[]{};
        if (this.elementExists()) {
            NamedNodeMap map = this.getElement().getAttributes();
            ret = new String[map.getLength()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = map.item(i).getNodeName();
                ++i;
            }
        }
        return ret;
    }

    public String getTagValue() {
        String ret = "";
        if (this.elementExists()) {
            ret = TagImpl.getTextValue(this.getElement());
        }
        ret = ret.trim();
        return ret;
    }

    protected void setTagValue(String newValue) {
        if (!this.elementExists()) {
            this.createElement();
        }
        TagImpl.setTextValue(this.getElement(), newValue);
    }

    protected ArrayList getChildTagList(String childTagName, Class childTagClass) {
        ArrayList childTagList = new ArrayList();
        try {
            Class[] constructorParameterTypes = new Class[]{class$com$tssap$j2ee$model$impl$dom$TagImpl == null ? (class$com$tssap$j2ee$model$impl$dom$TagImpl = TagImpl.class$("com.tssap.j2ee.model.impl.dom.TagImpl")) : class$com$tssap$j2ee$model$impl$dom$TagImpl, class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = TagImpl.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
            Constructor childTagClassConstructor = childTagClass.getConstructor(constructorParameterTypes);
            Object[] parameter = new Object[2];
            Element[] childElements = this.getChildElements(childTagName);
            int i = 0;
            while (i < childElements.length) {
                parameter[0] = this;
                parameter[1] = childElements[i];
                childTagList.add(childTagClassConstructor.newInstance(parameter));
                ++i;
            }
        }
        catch (NoSuchMethodException ex) {
            System.err.println("constructor not found for class " + childTagClass.toString());
            ex.printStackTrace(System.err);
            tracer.error("", (Throwable)ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            System.err.println("constructor could not be invoked " + childTagClass.toString());
            ex.printStackTrace(System.err);
            tracer.error("", (Throwable)ex);
            return null;
        }
        catch (InstantiationException ex) {
            System.err.println("instance could not be created " + childTagClass.toString());
            ex.printStackTrace(System.err);
            tracer.error("", (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            System.err.println("constructor is not accessible " + childTagClass.toString());
            ex.printStackTrace(System.err);
            tracer.error("", (Throwable)ex);
            return null;
        }
        return childTagList;
    }

    private static Element[] getChildElements(Element element, String tagName) {
        Element[] childElements = new Element[]{};
        if (element != null) {
            ArrayList<Node> elementList = new ArrayList<Node>();
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNodes.item(i).getNodeType() == 1 && (tagName == null || tagName.equals(((Element)childNodes.item(i)).getTagName()))) {
                    elementList.add(childNodes.item(i));
                }
                ++i;
            }
            return elementList.toArray(new Element[elementList.size()]);
        }
        return childElements;
    }

    private static Element getFirstChildElement(Element element, String tagName) {
        Element ret = null;
        if (element != null) {
            Node childNode = element.getFirstChild();
            while (childNode != null && ret == null) {
                Element childElement;
                if (childNode instanceof Element && tagName.equals((childElement = (Element)childNode).getTagName())) {
                    ret = childElement;
                }
                childNode = childNode.getNextSibling();
            }
        }
        return ret;
    }

    private static Text getFirstTextNode(Element element) {
        Text ret = null;
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength() && ret == null) {
            if (nodeList.item(i).getNodeType() == 3) {
                ret = (Text)nodeList.item(i);
            }
            ++i;
        }
        return ret;
    }

    private static String getTextValue(Element element) {
        String ret = "";
        Text textNode = TagImpl.getFirstTextNode(element);
        if (textNode != null) {
            ret = textNode.getNodeValue();
        }
        return ret;
    }

    private static void setTextValue(Element element, String newValue) {
        Text textNode = TagImpl.getFirstTextNode(element);
        if (textNode == null) {
            textNode = element.getOwnerDocument().createTextNode(newValue);
            element.appendChild(textNode);
        } else {
            textNode.setNodeValue(newValue);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

