/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.impl;

import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ModelPlugin;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.util.caching.AbstractCaching;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.DeleteResourceAction;

public abstract class J2EEProject
extends AbstractCaching
implements IJ2eeProject {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$impl$J2EEProject == null ? (class$com$tssap$j2ee$model$impl$J2EEProject = J2EEProject.class$("com.tssap.j2ee.model.impl.J2EEProject")) : class$com$tssap$j2ee$model$impl$J2EEProject));
    private static final int REFERENCING = 0;
    private static final int REFERENCED = 1;
    private MyResourceChangeListener myResourceChangeListener;
    private IProject myProject;
    private int myType;
    static /* synthetic */ Class class$com$tssap$j2ee$model$impl$J2EEProject;

    public J2EEProject(IProject prj, int type) {
        this.myProject = prj;
        this.myType = type;
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.myProject);
    }

    public String getName() {
        return this.myProject.getName();
    }

    public IProject getProject() {
        return this.myProject;
    }

    public int getType() {
        return this.myType;
    }

    public void setType(int type) {
        this.myType = type;
    }

    public Model getModel() {
        UniqueName uin = ModelUinSupport.createModelUin((String)this.getProject().getName());
        Model model = ModelAccess.getModel((UniqueName)uin);
        return model;
    }

    public void setReferencedProject(IJ2eeProject[] prj) {
        int i = 0;
        while (i < prj.length) {
            this.setReferencedProject(prj[i]);
            ++i;
        }
    }

    public void setReferencedProject(IJ2eeProject prj) {
        block14: {
            IProject[] refPrjs = null;
            try {
                refPrjs = this.getProject().getReferencedProjects();
            }
            catch (CoreException e) {
                tracer.warning("Fetching referenced projects failed", (Throwable)e);
                return;
            }
            boolean stillReferenced = false;
            int i = 0;
            while (i < refPrjs.length) {
                if (refPrjs[i].equals((Object)prj.getProject())) {
                    stillReferenced = true;
                }
                ++i;
            }
            if (!stillReferenced) {
                IProjectDescription desc;
                IProject[] newRefPrjs = new IProject[refPrjs.length + 1];
                System.arraycopy(refPrjs, 0, newRefPrjs, 0, refPrjs.length);
                newRefPrjs[newRefPrjs.length - 1] = prj.getProject();
                try {
                    desc = this.getProject().getDescription();
                }
                catch (CoreException e) {
                    tracer.warning("Get project description failed", (Throwable)e);
                    return;
                }
                desc.setReferencedProjects(newRefPrjs);
                try {
                    this.getProject().setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    tracer.warning("Set project description failed", (Throwable)e);
                    return;
                }
            }
            refPrjs = null;
            try {
                if (!this.getProject().hasNature("org.eclipse.jdt.core.javanature")) break block14;
                try {
                    IJavaProject jp = this.getJavaProject();
                    IClasspathEntry[] prevCp = jp.getRawClasspath();
                    IClasspathEntry newCpe = JavaCore.newProjectEntry((IPath)prj.getProject().getFullPath(), (boolean)false);
                    if (!J2EEProject.isInClasspath(prevCp, newCpe)) {
                        IClasspathEntry[] newCp = new IClasspathEntry[prevCp.length + 1];
                        System.arraycopy(prevCp, 0, newCp, 0, prevCp.length);
                        newCp[prevCp.length] = newCpe;
                        jp.setRawClasspath(newCp, null);
                    }
                }
                catch (JavaModelException e) {
                    tracer.log(4, "", (Throwable)e);
                }
            }
            catch (CoreException e) {
                tracer.log(4, "", (Throwable)e);
            }
        }
    }

    public void removeReferencedProject(IJ2eeProject[] prj) {
        int i = 0;
        while (i < prj.length) {
            this.removeReferencedProject(prj[i]);
            ++i;
        }
    }

    public void removeReferencedProject(IJ2eeProject prj) {
        block16: {
            IProject[] refPrjs = null;
            try {
                refPrjs = this.getProject().getReferencedProjects();
            }
            catch (CoreException e) {
                tracer.warning("Fetching referenced projects failed", (Throwable)e);
                return;
            }
            List<IProject> l = Arrays.asList(refPrjs);
            if (l.contains(prj.getProject())) {
                IProjectDescription desc;
                l = new ArrayList<IProject>();
                int i = 0;
                while (i < refPrjs.length) {
                    if (!refPrjs[i].equals((Object)prj.getProject())) {
                        l.add(refPrjs[i]);
                    }
                    ++i;
                }
                IProject[] newRefPrjs = new IProject[l.size()];
                newRefPrjs = l.toArray(newRefPrjs);
                try {
                    desc = this.getProject().getDescription();
                }
                catch (CoreException e) {
                    tracer.warning("Get project description failed", (Throwable)e);
                    return;
                }
                desc.setReferencedProjects(newRefPrjs);
                try {
                    this.getProject().setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    tracer.warning("Set project description failed", (Throwable)e);
                    return;
                }
            }
            refPrjs = null;
            try {
                if (!this.getProject().hasNature("org.eclipse.jdt.core.javanature")) break block16;
                try {
                    IJavaProject jp = this.getJavaProject();
                    IClasspathEntry[] prevCp = jp.getRawClasspath();
                    IClasspathEntry newCpe = JavaCore.newProjectEntry((IPath)prj.getProject().getFullPath(), (boolean)false);
                    if (J2EEProject.isInClasspath(prevCp, newCpe)) {
                        l = new ArrayList<IProject>();
                        int i = 0;
                        while (i < prevCp.length) {
                            if (!prevCp[i].equals(newCpe)) {
                                l.add((IProject)prevCp[i]);
                            }
                            ++i;
                        }
                        IClasspathEntry[] newCp = new IClasspathEntry[l.size()];
                        newCp = l.toArray(newCp);
                        jp.setRawClasspath(newCp, null);
                    }
                }
                catch (JavaModelException e) {
                    tracer.log(4, "", (Throwable)e);
                }
            }
            catch (CoreException e) {
                tracer.log(4, "", (Throwable)e);
            }
        }
    }

    public IJ2eeProject[] getReferencedProjects() {
        return this.getReferenceProjects(1);
    }

    protected IJ2eeProject[] getReferencedProjectsOfType(int type) {
        return this.getReferenceProjectsOfType(type, 1);
    }

    public IJ2eeProject[] getReferencingProjects() {
        return this.getReferenceProjects(0);
    }

    protected IJ2eeProject[] getReferencingProjectsOfType(int type) {
        return this.getReferenceProjectsOfType(type, 0);
    }

    private IJ2eeProject[] getReferenceProjectsOfType(int type, int referenceType) {
        ArrayList<IJ2eeProject> projects = new ArrayList<IJ2eeProject>();
        IJ2eeProject[] allRefProjects = null;
        switch (referenceType) {
            case 1: {
                allRefProjects = this.getReferencedProjects();
                break;
            }
            case 0: {
                allRefProjects = this.getReferencingProjects();
                break;
            }
            default: {
                tracer.log(4, "Wrong reference type");
            }
        }
        int i = 0;
        while (i < allRefProjects.length) {
            if (allRefProjects[i].getType() == type) {
                projects.add(allRefProjects[i]);
            }
            ++i;
        }
        try {
            switch (type) {
                case 1: {
                    return projects.toArray(new IEjbModule[0]);
                }
                case 2: {
                    return projects.toArray(new IEarProject[0]);
                }
                case 4: {
                    return projects.toArray(new IWebModule[0]);
                }
                case 5: {
                    break;
                }
                default: {
                    tracer.log(4, "Wrong projecttype");
                    break;
                }
            }
        }
        catch (Exception e) {
            tracer.error("Error occured while trying to retrieve reference projects", (Throwable)e);
            return null;
        }
        return null;
    }

    private IJ2eeProject[] getReferenceProjects(int referenceType) {
        ArrayList<IJ2eeProject> projectList = new ArrayList<IJ2eeProject>();
        IProject[] allRefPrjs = null;
        try {
            switch (referenceType) {
                case 1: {
                    allRefPrjs = this.getProject().getReferencedProjects();
                    break;
                }
                case 0: {
                    allRefPrjs = this.getProject().getReferencingProjects();
                    break;
                }
                default: {
                    tracer.log(4, "Wrong reference type");
                    break;
                }
            }
        }
        catch (CoreException e) {
            tracer.warning("Fetching referenced or referencing projects failed", (Throwable)e);
            return new IJ2eeProject[0];
        }
        int i = 0;
        while (allRefPrjs != null && i < allRefPrjs.length) {
            IJ2eeProject prj = J2eeProjectManager.getJ2eeProject(allRefPrjs[i].getName());
            if (prj != null) {
                projectList.add(prj);
            }
            ++i;
        }
        IJ2eeProject[] prjs = new IJ2eeProject[projectList.size()];
        projectList.toArray(prjs);
        return prjs;
    }

    public void delete(boolean showConfDialog) throws DeleteFailedException {
        if (!showConfDialog) {
            try {
                this.getProject().delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new DeleteFailedException(e.getLocalizedMessage());
            }
        } else {
            DeleteResourceAction action = new DeleteResourceAction(ModelPlugin.getShell());
            action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getProject()));
            action.run();
        }
    }

    public File[] getRelatedLibs() {
        try {
            if (this.getProject().getDescription().hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject prj = this.getJavaProject();
                return ProjectUtil.getReferencedLibsFromClasspath((IJavaProject)prj);
            }
        }
        catch (CoreException e) {
            tracer.warning("Get project description failed", (Throwable)e);
            return null;
        }
        return null;
    }

    private static boolean isInClasspath(IClasspathEntry[] prevCp, IClasspathEntry newCpe) {
        int i = 0;
        while (i < prevCp.length) {
            if (prevCp[i].equals(newCpe)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IFile getDCDefFile() {
        IFile dcDefFile = this.getProject().getFile("/.dcdef");
        if (dcDefFile != null && dcDefFile.exists()) {
            return dcDefFile;
        }
        return null;
    }

    public IFile getDefAssemblyPublicPart() {
        return null;
    }

    public IFile getDefCompilePublicPart() {
        return null;
    }

    public String getDefAssemblyPublicPartName() {
        return "";
    }

    public String getDefCompilePublicPartName() {
        return "";
    }

    public void startCaching() {
        if (this.isCaching()) {
            return;
        }
        super.startCaching();
        this.myResourceChangeListener = new MyResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.myResourceChangeListener);
    }

    public void stopCaching() {
        if (!this.isCaching()) {
            return;
        }
        super.stopCaching();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.myResourceChangeListener);
        this.myResourceChangeListener = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyResourceChangeListener
    implements IResourceChangeListener {
        private MyResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] affectedChildren;
            IResourceDelta delta = event.getDelta();
            if (delta != null && (affectedChildren = delta.getAffectedChildren()) != null && affectedChildren.length > 0) {
                int i = 0;
                while (i < affectedChildren.length) {
                    IProject affectedProject;
                    if (affectedChildren[i].getResource() instanceof IProject && (affectedProject = (IProject)affectedChildren[i].getResource()).equals((Object)J2EEProject.this.getProject())) {
                        J2EEProject.this.clearCache();
                    }
                    ++i;
                }
            }
        }
    }
}

