/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ejb.impl;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.model.DeleteFailedException;
import com.tssap.j2ee.model.ejb.IEjbRelation;
import com.tssap.j2ee.model.ejb.IEjbRelationRole;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.impl.EjbRelationRole;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;

public class EjbRelation
implements IEjbRelation {
    private Entity myEntity;
    private Entity myAsmEntity;
    private IEntityBean myHost;

    public EjbRelation(IEntityBean host, Entity selenaEntity, Entity selenaAsmEntity) {
        this.myEntity = selenaEntity;
        this.myAsmEntity = selenaAsmEntity;
        this.myHost = host;
    }

    public String getRelationName() {
        if (this.myAsmEntity != null) {
            return this.myAsmEntity.getPropertyValue("ejbRelationName");
        }
        String s = this.getRelationNameDdp();
        if (s != null) {
            return s;
        }
        return "Unspecified";
    }

    private String getRelationNameDdp() {
        Object ndObj = this.myEntity.getObjectPropertyValue("defaultEjbRelation");
        if (!(ndObj instanceof StringArrayList)) {
            return null;
        }
        StringArrayList nd = (StringArrayList)ndObj;
        if (nd.isEmpty()) {
            return null;
        }
        return nd.getString(0);
    }

    public void setRelationName(String relationName) {
        if (this.myAsmEntity != null) {
            this.myAsmEntity.setPropertyValue("ejbRelationName", relationName);
            return;
        }
        this.setRelationNameDdp(relationName);
    }

    private void setRelationNameDdp(String relationName) {
        StringArrayList nd;
        if (relationName == null || relationName.trim().length() == 0) {
            if (!this.myEntity.canSetObjectPropertyValue("defaultEjbRelation", null)) {
                return;
            }
            this.myEntity.setObjectPropertyValue("defaultEjbRelation", null);
            return;
        }
        Object ndObj = this.myEntity.getObjectPropertyValue("defaultEjbRelation");
        if (!(ndObj instanceof StringArrayList)) {
            nd = new StringArrayList();
            nd.add((Object)relationName);
        } else {
            nd = (StringArrayList)ndObj;
            if (nd.isEmpty()) {
                nd.add((Object)relationName);
            } else {
                nd.set(0, (Object)relationName);
            }
        }
        if (!this.myEntity.canSetObjectPropertyValue("defaultEjbRelation", (Object)nd)) {
            return;
        }
        this.myEntity.setObjectPropertyValue("defaultEjbRelation", (Object)nd);
    }

    public String getRelationDescription() {
        if (this.myAsmEntity != null) {
            return this.myAsmEntity.getPropertyValue("description");
        }
        return this.getRelationDescriptionDdp();
    }

    private String getRelationDescriptionDdp() {
        Object ndObj = this.myEntity.getObjectPropertyValue("defaultEjbRelation");
        if (!(ndObj instanceof StringArrayList)) {
            return null;
        }
        StringArrayList nd = (StringArrayList)ndObj;
        if (nd.size() < 2) {
            return null;
        }
        return nd.getString(1);
    }

    public void setRelationDescription(String relationDescription) {
        if (this.myAsmEntity != null) {
            this.myAsmEntity.setPropertyValue("description", relationDescription);
            return;
        }
        this.setRelationDescriptionDdp(relationDescription);
    }

    private void setRelationDescriptionDdp(String relationDescription) {
        Object ndObj = this.myEntity.getObjectPropertyValue("defaultEjbRelation");
        if (!(ndObj instanceof StringArrayList)) {
            return;
        }
        StringArrayList nd = (StringArrayList)ndObj;
        if (nd.isEmpty()) {
            return;
        }
        if (relationDescription == null || relationDescription.trim().length() == 0) {
            if (nd.size() > 1) {
                nd.remove(1);
            }
        } else if (nd.size() > 1) {
            nd.set(1, (Object)relationDescription);
        } else {
            nd.add((Object)relationDescription);
        }
        if (!this.myEntity.canSetObjectPropertyValue("defaultEjbRelation", (Object)nd)) {
            return;
        }
        this.myEntity.setObjectPropertyValue("defaultEjbRelation", (Object)nd);
    }

    public IEjbRelationRole getRole1() {
        return new EjbRelationRole(this.myHost, this, this.myEntity, this.myAsmEntity, true);
    }

    public IEjbRelationRole getRole2() {
        return new EjbRelationRole(this.myHost, this, this.myEntity, this.myAsmEntity, false);
    }

    public void setRole1(final IEjbRelationRole role) {
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                IEjbRelationRole role1 = EjbRelation.this.getRole1();
                role1.setRoleName(role.getRoleName());
                role1.setCardinality(role.getCardinality());
                role1.setCmrField(role.getCmrField());
            }
        });
    }

    public void setRole2(final IEjbRelationRole role) {
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                IEjbRelationRole role2 = EjbRelation.this.getRole2();
                role2.setRoleName(role.getRoleName());
                role2.setCardinality(role.getCardinality());
                role2.setCmrField(role.getCmrField());
                role2.setBean(role.getBean());
            }
        });
    }

    public void setState(int state) {
    }

    public boolean isDeleted() {
        return this.myEntity.isDeleted();
    }

    public boolean isNew() {
        return false;
    }

    public boolean isChanged() {
        return false;
    }

    public boolean isUnchanged() {
        return false;
    }

    public void delete(boolean showConfDialog) throws DeleteFailedException {
        this.myEntity.delete();
    }
}

