/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.ear.impl;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.IModule;
import com.tssap.j2ee.model.ear.dd.impl.Application;
import com.tssap.j2ee.model.ear.dd.impl.Module;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.impl.J2EEArchiveProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class EarProject
extends J2EEArchiveProject
implements IEarProject {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$ear$impl$EarProject == null ? (class$com$tssap$j2ee$model$ear$impl$EarProject = EarProject.class$("com.tssap.j2ee.model.ear.impl.EarProject")) : class$com$tssap$j2ee$model$ear$impl$EarProject));
    static /* synthetic */ Class class$com$tssap$j2ee$model$ear$impl$EarProject;

    public EarProject(IProject prj) {
        super(prj, 2);
    }

    public IApplication createDescriptor() throws J2eeCreateException {
        IApplication existingDescriptor = this.getDescriptor();
        if (existingDescriptor != null) {
            return existingDescriptor;
        }
        Model model = this.getModel();
        if (model != null) {
            Entity template = model.createEntityTemplate();
            template.setPropertyValue("$file", "META-INF/application.xml");
            if (model.canCreateChildEntity("com.tssap.j2ee.core.ear.EnterpriseApp", template)) {
                Entity result = model.createChildEntity("com.tssap.j2ee.core.ear.EnterpriseApp", template);
                if (result != null) {
                    return new Application(model, result.getUniqueName());
                }
                throw new J2eeCreateException("Error on creation of application.xml");
            }
            throw new J2eeCreateException("Can't create application.xml");
        }
        throw new J2eeCreateException("Unable to locate model for application.xml");
    }

    public IApplication getDescriptor() {
        Model model = this.getModel();
        if (model != null) {
            EntityEnumeration entityEnumeration = model.children();
            while (entityEnumeration.hasMoreElements()) {
                Entity ent = entityEnumeration.next();
                if (!"com.tssap.j2ee.core.ear.EnterpriseApp".equals(ent.getPropertyValue("$metaclass"))) continue;
                return new Application(model, ent.getUniqueName());
            }
        }
        return null;
    }

    public boolean hasValidDescriptor() {
        IApplication app = this.getDescriptor();
        if (app == null || !(app instanceof Application)) {
            return false;
        }
        Entity entity = ((Application)app).getEntity();
        return !entity.hasPropertyValue("invalid", "true");
    }

    public IFile getDescriptorLocation() {
        Model model = this.getModel();
        if (model != null) {
            EntityEnumeration entityEnumeration = model.children();
            while (entityEnumeration.hasMoreElements()) {
                Entity ent = entityEnumeration.next();
                if (!ent.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.ear.EnterpriseApp")) continue;
                String relativePath = ent.getPropertyValue("$name");
                return (IFile)this.getProject().findMember(relativePath);
            }
        }
        return this.getProject().getFile("META-INF/application.xml");
    }

    public IEjbModule[] getReferencedEjbModules() {
        IEjbModule[] mods = (IEjbModule[])this.getReferencedProjectsOfType(1);
        return mods;
    }

    public IWebModule[] getReferencedWebModules() {
        IWebModule[] mods = (IWebModule[])this.getReferencedProjectsOfType(4);
        return mods;
    }

    public void removeEjbModules(IEjbModule[] ejbModules) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < ejbModules.length) {
            String string = ejbModules[i].getName();
            names.add(string);
            ++i;
        }
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("removeEjbModules", "getDescriptor == null");
            return;
        }
        Entity application = ((Application)descr).getEntity();
        EntityEnumeration children = application.childEntities();
        while (children.hasMoreElements()) {
            String moduleName;
            Entity child = children.next();
            if (!"com.tssap.j2ee.core.ejbjar.EjbJar".equals(child.getPropertyValue("$metaclass")) || !ProxyMetaInfo.isProxyUniqueName((UniqueName)child.getUniqueName()) || !names.contains(moduleName = ProxyMetaInfo.getSourceModel((UniqueName)child.getUniqueName()).getPropertyValue("$name"))) continue;
            child.delete();
        }
    }

    public void removeWebModules(IWebModule[] webModules) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < webModules.length) {
            String string = webModules[i].getName();
            names.add(string);
            ++i;
        }
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("removeWebModules", "getDescriptor == null");
            return;
        }
        Entity application = ((Application)descr).getEntity();
        EntityEnumeration children = application.childEntities();
        while (children.hasMoreElements()) {
            String moduleName;
            Entity child = children.next();
            if (!"com.tssap.j2ee.core.webapp.WebApp".equals(child.getPropertyValue("$metaclass")) || !ProxyMetaInfo.isProxyUniqueName((UniqueName)child.getUniqueName()) || !names.contains(moduleName = ProxyMetaInfo.getSourceModel((UniqueName)child.getUniqueName()).getPropertyValue("$name"))) continue;
            child.delete();
        }
    }

    public void setEjbModule(IEjbModule ejbMod) throws J2eeCreateException, J2eeDuplicateNameException {
        Entity template = this.getModel().createEntityTemplate();
        String uriValue = ejbMod.getArchiveName();
        template.setPropertyValue("$name", uriValue);
        String xmlFile = ejbMod.getDescriptorLocation().getProjectRelativePath().toString();
        template.setPropertyValue("$file", xmlFile);
        String prjName = ejbMod.getName();
        template.setPropertyValue("sourceProject", prjName);
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("setEjbModule", "getDescriptor == null");
            return;
        }
        Entity application = ((Application)descr).getEntity();
        if (application.canCreateChildEntity("com.tssap.j2ee.core.ejbjar.EjbJar", template)) {
            if (application.createChildEntity("com.tssap.j2ee.core.ejbjar.EjbJar", template) == null) {
                throw new J2eeCreateException("Project " + prjName + " added to EAR, but result entity returned as null\n");
            }
        } else {
            throw new J2eeDuplicateNameException("Duplicated name of module: " + uriValue, ejbMod);
        }
    }

    public void setWebModule(IWebModule webPrj) throws J2eeCreateException, J2eeDuplicateNameException {
        Entity template = this.getModel().createEntityTemplate();
        String uriValue = webPrj.getArchiveName();
        template.setPropertyValue("$name", uriValue);
        String xmlFile = webPrj.getDescriptorLocation().getProjectRelativePath().toString();
        template.setPropertyValue("$file", xmlFile);
        String prjName = webPrj.getName();
        template.setPropertyValue("sourceProject", prjName);
        template.setPropertyValue("contextRoot", "contextRoot");
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("setWebModules", "getDescriptor == null");
            return;
        }
        Entity application = ((Application)descr).getEntity();
        if (application.canCreateChildEntity("com.tssap.j2ee.core.webapp.WebApp", template)) {
            if (application.createChildEntity("com.tssap.j2ee.core.webapp.WebApp", template) == null) {
                throw new J2eeCreateException("Project " + prjName + " added to EAR, but result entity returned as null");
            }
        } else {
            throw new J2eeDuplicateNameException("Duplicated name of module: " + uriValue, webPrj);
        }
    }

    public void setModule(IJ2eeProject project) throws J2eeCreateException, J2eeDuplicateNameException {
        if (project instanceof IEjbModule) {
            this.setEjbModule((IEjbModule)project);
        } else if (project instanceof IWebModule) {
            this.setWebModule((IWebModule)project);
        } else {
            throw new J2eeCreateException("Attempt to add non-ejb/web assembly project, type: " + project.getType() + ", name: " + project.getName());
        }
    }

    public boolean isReferencedModule(IJ2eeProject moduleProject) {
        if (moduleProject instanceof IEjbModule) {
            return this.isReferencedEjbModule((IEjbModule)moduleProject);
        }
        if (moduleProject instanceof IWebModule) {
            return this.isReferencedWebModule((IWebModule)moduleProject);
        }
        return false;
    }

    public boolean isReferencedEjbModule(IEjbModule ejbModule) {
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("isReferencedEjbModule", "getDescriptor == null");
            return false;
        }
        Entity application = ((Application)descr).getEntity();
        EntityEnumeration children = application.childEntities();
        while (children.hasMoreElements()) {
            String moduleName;
            Entity child = children.next();
            if (!"com.tssap.j2ee.core.ejbjar.EjbJar".equals(child.getPropertyValue("$metaclass")) || !ProxyMetaInfo.isProxyUniqueName((UniqueName)child.getUniqueName()) || !(moduleName = ProxyMetaInfo.getSourceModel((UniqueName)child.getUniqueName()).getPropertyValue("$name")).equals(ejbModule.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isReferencedWebModule(IWebModule webProject) {
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("isReferencedWebModule", "getDescriptor == null");
            return false;
        }
        Entity application = ((Application)descr).getEntity();
        EntityEnumeration children = application.childEntities();
        while (children.hasMoreElements()) {
            String moduleName;
            Entity child = children.next();
            if (!"com.tssap.j2ee.core.webapp.WebApp".equals(child.getPropertyValue("$metaclass")) || !ProxyMetaInfo.isProxyUniqueName((UniqueName)child.getUniqueName()) || !(moduleName = ProxyMetaInfo.getSourceModel((UniqueName)child.getUniqueName()).getPropertyValue("$name")).equals(webProject.getName())) continue;
            return true;
        }
        return false;
    }

    public IModule getModule(IJ2eeProject project) {
        String metaclass;
        if (project instanceof IEjbModule) {
            metaclass = "com.tssap.j2ee.core.ejbjar.EjbJar";
        } else if (project instanceof IWebModule) {
            metaclass = "com.tssap.j2ee.core.webapp.WebApp";
        } else {
            tracer.error("getModule", "parameter is neither EJB nor Web Assembly project");
            return null;
        }
        IApplication descr = this.getDescriptor();
        if (descr == null) {
            tracer.error("getModule", "getDescriptor == null");
            return null;
        }
        Entity application = ((Application)descr).getEntity();
        Module result = null;
        EntityEnumeration children = application.childEntities();
        while (children.hasMoreElements()) {
            String moduleName;
            Entity child = children.next();
            if (!metaclass.equals(child.getPropertyValue("$metaclass")) || !ProxyMetaInfo.isProxyUniqueName((UniqueName)child.getUniqueName()) || !(moduleName = ProxyMetaInfo.getSourceModel((UniqueName)child.getUniqueName()).getPropertyValue("$name")).equals(project.getName())) continue;
            result = new Module(child.getModel(), child.getUniqueName());
        }
        return result;
    }

    protected String getArchiveExtension() {
        return "ear";
    }

    public boolean hasReferencedEjbModules() {
        IEjbModule[] ejbMods = this.getReferencedEjbModules();
        return ejbMods != null && ejbMods.length > 0;
    }

    public boolean hasReferencedModules() {
        IJ2eeProject[] prj = this.getReferencedProjects();
        return prj != null && prj.length > 0;
    }

    public boolean hasReferencedWebModules() {
        IWebModule[] webMods = this.getReferencedWebModules();
        return webMods != null && webMods.length > 0;
    }

    public void removeModule(IJ2eeProject project) {
        if (project instanceof IEjbModule) {
            this.removeEjbModules(new IEjbModule[]{(IEjbModule)project});
        } else if (project instanceof IWebModule) {
            this.removeWebModules(new IWebModule[]{(IWebModule)project});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

