/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.j2ee.model.service.IJ2EEServiceProject;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.util.ChildrenProviderAdapter;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFile;

public class ArchiveProvider
extends ChildrenProviderAdapter {
    private static final boolean DUPLICATE_UNIQUE_NAME = true;
    public static final String DOMAIN = "Archive Provider";
    public static final String SUBDOMAIN = "Archive File";

    public boolean isChildrenProviderApplicable(Entity parent) {
        boolean ret = J2eeElementManager.isEjbAssemblyProject((Element)parent) || J2eeElementManager.isEarProject((Element)parent) || J2eeElementManager.isJ2EELibraryProject((Element)parent) || J2eeElementManager.isJ2EEServiceProject((Element)parent) || J2eeElementManager.isWebAssemblyProject((Element)parent);
        return ret;
    }

    public UniqueNameEnumeration children(Entity parent) {
        IJ2eeProject ejbAssemblyProject;
        UniqueName uniqueName;
        IRepresentArchive repArchive;
        IFile archiveFile;
        UniqueNameEnumeration ret = null;
        UniqueName uNameParent = parent.getUniqueName();
        IJ2eeProject j2eeProject = null;
        if (J2eeElementManager.isEjbAssemblyProject((Element)parent)) {
            IEjbAssemblyProject ejbAssemblyProject2;
            j2eeProject = ejbAssemblyProject2 = J2eeElementManager.getEjbAssemblyProject((Element)parent);
        } else if (J2eeElementManager.isEarProject((Element)parent)) {
            IEarProject earProject = J2eeElementManager.getEarProject((Element)parent);
            j2eeProject = earProject;
        } else if (J2eeElementManager.isWebAssemblyProject((Element)parent)) {
            IWebAssemblyProject webAssemblyProject = J2eeElementManager.getWebAssemblyProject((Element)parent);
            j2eeProject = webAssemblyProject;
        } else if (J2eeElementManager.isJ2EELibraryProject((Element)parent)) {
            IJ2EELibraryProject libraryProject = J2eeElementManager.getJ2EELibraryProject((Element)parent);
            j2eeProject = libraryProject;
        } else if (J2eeElementManager.isJ2EEServiceProject((Element)parent)) {
            IJ2EEServiceProject servProject = J2eeElementManager.getJ2EEServiceProject((Element)parent);
            j2eeProject = servProject;
        }
        Vector<UniqueName> vec = new Vector<UniqueName>();
        if (j2eeProject instanceof IRepresentArchive && (archiveFile = (repArchive = (IRepresentArchive)((Object)j2eeProject)).getArchiveLocationFullPath()) != null) {
            uniqueName = this.createUniqueName(archiveFile);
            vec.add(uniqueName);
        }
        if (j2eeProject instanceof IEjbAssemblyProject && (archiveFile = (ejbAssemblyProject = j2eeProject).getClientAPIJar()) != null) {
            uniqueName = this.createUniqueName(archiveFile);
            vec.add(uniqueName);
        }
        Enumeration enumeration = Collections.enumeration(vec);
        ret = EnumerationConverter.toUniqueNameEnumeration(enumeration);
        return ret;
    }

    public UniqueName createUniqueName(IFile archiveFile) {
        UniqueName ret = null;
        if (archiveFile != null) {
            UniqueName uniqueName;
            ret = uniqueName = FileAndFolderManagement.getInstance().getUniqueName((Object)archiveFile);
        }
        return ret;
    }

    public boolean exists(String uniqueName) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return false;
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public boolean exists(UniqueName uniqueName) {
        return false;
    }
}

