/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model;

import com.tssap.dii.component.DCProjectInfo;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.impl.EarProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.impl.EjbModule;
import com.tssap.j2ee.model.ejb.impl.EjbProject;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ejbjar.impl.EjbAssemblyProject;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.j2ee.model.library.impl.J2EELibraryProject;
import com.tssap.j2ee.model.service.IJ2EEServiceProject;
import com.tssap.j2ee.model.service.impl.J2EEServiceProject;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.impl.WebAssemblyProject;
import com.tssap.j2ee.model.web.impl.WebModule;
import com.tssap.j2ee.model.web.impl.WebProject;
import com.tssap.j2ee.model.wsproxy.IWsDeployableProxyProject;
import com.tssap.j2ee.model.wsproxy.IWsProxyProject;
import com.tssap.j2ee.model.wsproxy.impl.WsProxyProjectDeployable;
import com.tssap.j2ee.model.wsproxy.impl.WsProxyProjectStandalone;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.caching.ICaching;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class J2eeProjectManager {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$J2eeProjectManager == null ? (class$com$tssap$j2ee$model$J2eeProjectManager = J2eeProjectManager.class$("com.tssap.j2ee.model.J2eeProjectManager")) : class$com$tssap$j2ee$model$J2eeProjectManager));
    private static boolean caching = true;
    private static ModelAccessListener myModelListener;
    private static HashMap projectsCache;
    static /* synthetic */ Class class$com$tssap$j2ee$model$J2eeProjectManager;

    public static void clearCache() {
        Collection valuesCollection = J2eeProjectManager.getProjectsCache().values();
        Iterator iter = valuesCollection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ICaching)) continue;
            ICaching caching = (ICaching)obj;
            caching.stopCaching();
        }
        J2eeProjectManager.getProjectsCache().clear();
    }

    public static IJ2eeProject[] getModuleProjects() {
        IEjbModule[] ejbAssembly = J2eeProjectManager.getEjbModules();
        IWebModule[] webAssembly = J2eeProjectManager.getWebModules();
        ArrayList<IJ2eeProject> list = new ArrayList<IJ2eeProject>();
        list.addAll(Arrays.asList(ejbAssembly));
        list.addAll(Arrays.asList(webAssembly));
        IJ2eeProject[] ret = new IJ2eeProject[list.size()];
        return list.toArray(ret);
    }

    public static IJ2eeProject[] getModuleProjects(IJ2eeProjectFilter filter) {
        return J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getModuleProjects());
    }

    public static IEarProject getEarProject(String name) {
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.core.ear.earNature", name));
        if (prj != null) {
            return new EarProject(prj);
        }
        return null;
    }

    public static IEarProject[] getEarProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.core.ear.earNature"));
        IEarProject[] result = new IEarProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new EarProject(projects[i]);
            ++i;
        }
        return result;
    }

    public static IEarProject[] getEarProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getEarProjects());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IEarProject[] ret = new IEarProject[list.size()];
            return list.toArray(ret);
        }
        return new IEarProject[0];
    }

    public static IEjbModule getEjbModule(IProject project) {
        IEjbModule ret = (IEjbModule)J2eeProjectManager.getFromProjectsCache(project);
        if (ret == null) {
            ret = J2eeProjectManager.createEjbModule(project);
            J2eeProjectManager.addToProjectsCache(project, ret);
        }
        return ret;
    }

    public static IEjbModule getEjbModule(String name) {
        IEjbModule ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNaturesAndName(new String[]{"com.tssap.j2ee.core.ejb.ejbNature", "com.tssap.j2ee.core.ejbjar.ejbJarNature"}, name));
        if (prj != null) {
            ret = J2eeProjectManager.getEjbModule(prj);
        }
        return ret;
    }

    public static IEjbModule[] getEjbModules() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNatures(new String[]{"com.tssap.j2ee.core.ejb.ejbNature", "com.tssap.j2ee.core.ejbjar.ejbJarNature"}));
        IEjbModule[] result = new IEjbModule[projects.length];
        int i = 0;
        while (i < result.length) {
            IProject prj = projects[i];
            result[i] = J2eeProjectManager.getEjbModule(prj);
            ++i;
        }
        return result;
    }

    public static IEjbModule[] getEjbModules(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getEjbModules());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IEjbModule[] ret = new IEjbModule[list.size()];
            return list.toArray(ret);
        }
        return new IEjbModule[0];
    }

    public static IJ2eeProject getJ2eeProject(String name) {
        IJ2eeProject prj = J2eeProjectManager.getEarProject(name);
        if (prj == null) {
            prj = J2eeProjectManager.getEjbModule(name);
        }
        if (prj == null) {
            prj = J2eeProjectManager.getWebModule(name);
        }
        if (prj == null) {
            prj = J2eeProjectManager.getWsDeployableProxyProject(name);
        }
        if (prj == null) {
            prj = J2eeProjectManager.getWsStandaloneProxyProject(name);
        }
        if (prj == null) {
            prj = J2eeProjectManager.getLibraryProject(name);
        }
        if (prj == null) {
            prj = J2eeProjectManager.getServiceProject(name);
        }
        return prj;
    }

    public static IJ2eeProject[] getJ2eeProjects() {
        ArrayList<IJ2eeProject> array = new ArrayList<IJ2eeProject>();
        array.addAll(Arrays.asList(J2eeProjectManager.getEjbModules()));
        array.addAll(Arrays.asList(J2eeProjectManager.getWebModules()));
        array.addAll(Arrays.asList(J2eeProjectManager.getEarProjects()));
        array.addAll(Arrays.asList(J2eeProjectManager.getLibraryProjects()));
        array.addAll(Arrays.asList(J2eeProjectManager.getServiceProjects()));
        IJ2eeProject[] result = new IJ2eeProject[array.size()];
        if (!array.isEmpty()) {
            array.toArray(result);
        }
        return result;
    }

    public static IJ2eeProject[] getJ2eeProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getJ2eeProjects());
        return filtered;
    }

    public static IJ2EELibraryProject getLibraryProject(String name) {
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.library.libraryNature", name));
        if (prj != null) {
            return new J2EELibraryProject(prj);
        }
        return null;
    }

    public static IJ2EELibraryProject[] getLibraryProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.library.libraryNature"));
        IJ2EELibraryProject[] result = new IJ2EELibraryProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new J2EELibraryProject(projects[i]);
            ++i;
        }
        return result;
    }

    public static IJ2EEServiceProject getServiceProject(String name) {
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.service.serviceNature", name));
        if (prj != null) {
            return new J2EEServiceProject(prj);
        }
        return null;
    }

    public static IJ2EEServiceProject[] getServiceProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.service.serviceNature"));
        IJ2EEServiceProject[] result = new IJ2EEServiceProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new J2EEServiceProject(projects[i]);
            ++i;
        }
        return result;
    }

    public static IWebModule getWebModule(IProject project) {
        IWebModule ret = (WebModule)J2eeProjectManager.getFromProjectsCache(project);
        if (ret == null) {
            ret = J2eeProjectManager.createWebModule(project);
            J2eeProjectManager.addToProjectsCache(project, ret);
        }
        return ret;
    }

    public static IWebModule getWebModule(String name) {
        IWebModule ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNaturesAndName(new String[]{"com.tssap.j2ee.core.web.webNature", "com.tssap.j2ee.core.webapp.webAppNature"}, name));
        if (prj != null) {
            ret = J2eeProjectManager.getWebModule(prj);
        }
        return ret;
    }

    public static IWebModule[] getWebModules() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNatures(new String[]{"com.tssap.j2ee.core.web.webNature", "com.tssap.j2ee.core.webapp.webAppNature"}));
        IWebModule[] result = new IWebModule[projects.length];
        int i = 0;
        while (i < result.length) {
            IProject prj = projects[i];
            result[i] = J2eeProjectManager.getWebModule(prj);
            ++i;
        }
        return result;
    }

    public static IWebModule[] getWebModules(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getWebModules());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IWebModule[] ret = new IWebModule[list.size()];
            return list.toArray(ret);
        }
        return new IWebModule[0];
    }

    public static IWsProxyProject getWsDeployableProxyProject(String name) {
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.sap.ide.wsproxy.wsProxyDeployableNature", name));
        if (prj != null) {
            return WsProxyProjectDeployable.getInstance(prj);
        }
        return null;
    }

    public static IWsDeployableProxyProject[] getWsDeployableProxyProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.sap.ide.wsproxy.wsProxyDeployableNature"));
        IWsDeployableProxyProject[] result = new IWsDeployableProxyProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WsProxyProjectDeployable.getInstance(projects[i]);
            ++i;
        }
        return result;
    }

    public static IWsProxyProject getWsStandaloneProxyProject(String name) {
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.sap.ide.wsproxy.wsProxyStandaloneNature", name));
        if (prj != null) {
            return new WsProxyProjectStandalone(prj);
        }
        return null;
    }

    public static boolean isCaching() {
        return caching;
    }

    public static boolean isComponentProject(IJ2eeProject project) {
        try {
            return DCProjectInfo.isDCProject((IProject)project.getProject());
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean isEjbModuleProject(IProject project) {
        boolean hasEjbNature = false;
        boolean hasEjbJarNature = false;
        try {
            hasEjbJarNature = project.hasNature("com.tssap.j2ee.core.ejbjar.ejbJarNature");
            hasEjbNature = project.hasNature("com.tssap.j2ee.core.ejb.ejbNature");
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
        }
        return hasEjbNature && hasEjbJarNature;
    }

    public static boolean isWebModuleProject(IProject project) {
        boolean hasWebNature = false;
        boolean hasWebAppNature = false;
        try {
            hasWebAppNature = project.hasNature("com.tssap.j2ee.core.web.webNature");
            hasWebNature = project.hasNature("com.tssap.j2ee.core.webapp.webAppNature");
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
        }
        return hasWebNature && hasWebAppNature;
    }

    public static void startCaching() {
        caching = true;
        Collection coll = J2eeProjectManager.getProjectsCache().values();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ICaching)) continue;
            ICaching caching = (ICaching)obj;
            caching.startCaching();
        }
    }

    public static void stopCaching() {
        if (J2eeProjectManager.isCaching()) {
            J2eeProjectManager.clearCache();
            caching = false;
        }
    }

    private static IEjbAssemblyProject createEjbAssemblyProject(IProject project) {
        EjbAssemblyProject ret = null;
        if (project != null) {
            ret = new EjbAssemblyProject(project);
        }
        return ret;
    }

    private static IEjbModule createEjbModule(IProject project) {
        EjbModule ret = null;
        if (project != null) {
            IEjbProject newEjbProject = J2eeProjectManager.createEjbProject(project);
            IEjbAssemblyProject newEjbAssemblyProject = J2eeProjectManager.createEjbAssemblyProject(project);
            ret = new EjbModule(newEjbProject, newEjbAssemblyProject);
        }
        return ret;
    }

    private static IEjbProject createEjbProject(IProject project) {
        EjbProject ret = null;
        if (project != null) {
            ret = new EjbProject(project);
        }
        return ret;
    }

    private static IWebAssemblyProject createWebAssemblyProject(IProject project) {
        WebAssemblyProject ret = null;
        if (project != null) {
            ret = new WebAssemblyProject(project);
        }
        return ret;
    }

    private static IWebModule createWebModule(IProject project) {
        WebModule ret = null;
        if (project != null) {
            IWebProject newWebProject = J2eeProjectManager.createWebProject(project);
            IWebAssemblyProject newWebAssemblyProject = J2eeProjectManager.createWebAssemblyProject(project);
            ret = new WebModule(newWebProject, newWebAssemblyProject);
        }
        return ret;
    }

    private static IWebProject createWebProject(IProject project) {
        WebProject ret = null;
        if (project != null) {
            ret = new WebProject(project);
        }
        return ret;
    }

    private static void removeFromProjectsCache(IProject project) {
        if (J2eeProjectManager.isCaching()) {
            Object j2eeProject = J2eeProjectManager.getProjectsCache().get(project);
            if (j2eeProject != null && j2eeProject instanceof ICaching) {
                ICaching caching = (ICaching)j2eeProject;
                caching.stopCaching();
            }
            J2eeProjectManager.getProjectsCache().remove(project);
        }
    }

    private static IJ2eeProject[] getFilteredProjects(IJ2eeProjectFilter filter, IJ2eeProject[] projects) {
        ArrayList<IJ2eeProject> list = new ArrayList<IJ2eeProject>();
        int i = 0;
        while (i < projects.length) {
            IJ2eeProject prj = projects[i];
            if (filter.accept(prj)) {
                list.add(prj);
            }
            ++i;
        }
        IJ2eeProject[] result = new IJ2eeProject[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    private static IProject getFirstAcceptedProjectByFilter(IFilter filter) {
        IProject[] pList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < pList.length) {
            if (pList[i].isOpen() && filter.accept(pList[i])) {
                return pList[i];
            }
            ++i;
        }
        return null;
    }

    private static IJ2eeProject getFromProjectsCache(IProject project) {
        IJ2eeProject ret = (IJ2eeProject)J2eeProjectManager.getProjectsCache().get(project);
        return ret;
    }

    private static Model getModel(IProject project) {
        UniqueName un = ModelAccess.createModelUniqueName((String)project.getName());
        Model model = ModelAccess.getModel((UniqueName)un);
        return model;
    }

    private static IProject[] getProjectsByFilter(IFilter filter) {
        ArrayList<IProject> pListFiltered = new ArrayList<IProject>();
        IProject[] pList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < pList.length) {
            if (pList[i].isOpen() && filter.accept(pList[i])) {
                pListFiltered.add(pList[i]);
            }
            ++i;
        }
        pList = new IProject[pListFiltered.size()];
        pList = pListFiltered.toArray(pList);
        return pList;
    }

    private static HashMap getProjectsCache() {
        if (projectsCache == null) {
            projectsCache = new HashMap();
            if (myModelListener == null) {
                myModelListener = new MyModelAccessListener();
                ModelAccess.addModelAccessListener((ModelAccessListener)myModelListener);
            }
        }
        return projectsCache;
    }

    private static void addToProjectsCache(IProject project, IJ2eeProject j2eeProject) {
        if (J2eeProjectManager.isCaching()) {
            J2eeProjectManager.getProjectsCache().put(project, j2eeProject);
            if (j2eeProject instanceof ICaching) {
                ICaching caching = (ICaching)j2eeProject;
                caching.startCaching();
            }
        }
    }

    private static IEjbAssemblyProject getEjbAssemblyProject(IProject project) {
        IEjbAssemblyProject ret = null;
        if (project != null) {
            ret = J2eeProjectManager.isEjbModuleProject(project) ? J2eeProjectManager.getEjbModule(project) : J2eeProjectManager.createEjbAssemblyProject(project);
        }
        return ret;
    }

    private static IEjbAssemblyProject getEjbAssemblyProject(String name) {
        IEjbAssemblyProject ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.core.ejbjar.ejbJarNature", name));
        if (prj != null) {
            ret = J2eeProjectManager.getEjbAssemblyProject(prj);
        }
        return ret;
    }

    private static IEjbAssemblyProject[] getEjbAssemblyProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.core.ejbjar.ejbJarNature"));
        IEjbAssemblyProject[] result = new IEjbAssemblyProject[projects.length];
        int i = 0;
        while (i < result.length) {
            IProject prj = projects[i];
            result[i] = J2eeProjectManager.getEjbAssemblyProject(prj);
            ++i;
        }
        return result;
    }

    private static IEjbAssemblyProject[] getEjbAssemblyProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getEjbAssemblyProjects());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IEjbAssemblyProject[] ret = new IEjbAssemblyProject[list.size()];
            return list.toArray(ret);
        }
        return new IEjbAssemblyProject[0];
    }

    private static IEjbProject getEjbProject(IProject project) {
        IEjbProject ret = null;
        if (project != null) {
            ret = J2eeProjectManager.isEjbModuleProject(project) ? J2eeProjectManager.getEjbModule(project) : J2eeProjectManager.createEjbProject(project);
        }
        return ret;
    }

    private static IEjbProject getEjbProject(String name) {
        IEjbProject ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.core.ejb.ejbNature", name));
        if (prj != null) {
            ret = J2eeProjectManager.getEjbProject(prj);
        }
        return ret;
    }

    private static IEjbProject[] getEjbProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.core.ejb.ejbNature"));
        IEjbProject[] result = new IEjbProject[projects.length];
        int i = 0;
        while (i < result.length) {
            IProject prj = projects[i];
            result[i] = J2eeProjectManager.getEjbProject(prj);
            ++i;
        }
        return result;
    }

    private static IEjbProject[] getEjbProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getEjbProjects());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IEjbProject[] ret = new IEjbProject[list.size()];
            return list.toArray(ret);
        }
        return new IEjbProject[0];
    }

    private static IWebAssemblyProject getWebAssemblyProject(IProject project) {
        IWebAssemblyProject ret = null;
        if (project != null) {
            ret = J2eeProjectManager.isWebModuleProject(project) ? J2eeProjectManager.getWebModule(project) : J2eeProjectManager.createWebAssemblyProject(project);
        }
        return ret;
    }

    private static IWebAssemblyProject getWebAssemblyProject(String name) {
        IWebAssemblyProject ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.core.webapp.webAppNature", name));
        if (prj != null) {
            ret = J2eeProjectManager.getWebAssemblyProject(prj);
        }
        return ret;
    }

    private static IWebAssemblyProject[] getWebAssemblyProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.core.webapp.webAppNature"));
        IWebAssemblyProject[] result = new IWebAssemblyProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = J2eeProjectManager.getWebAssemblyProject(projects[i]);
            ++i;
        }
        return result;
    }

    private static IWebAssemblyProject[] getWebAssemblyProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getWebAssemblyProjects());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IWebAssemblyProject[] ret = new IWebAssemblyProject[list.size()];
            return list.toArray(ret);
        }
        return new IWebAssemblyProject[0];
    }

    private static IWebProject getWebProject(IProject project) {
        IWebProject ret = null;
        if (project != null) {
            ret = J2eeProjectManager.isWebModuleProject(project) ? J2eeProjectManager.getWebModule(project) : J2eeProjectManager.createWebProject(project);
        }
        return ret;
    }

    private static IWebProject getWebProject(String name) {
        IWebProject ret = null;
        IProject prj = J2eeProjectManager.getFirstAcceptedProjectByFilter(new FilterOfNatureAndName("com.tssap.j2ee.core.web.webNature", name));
        if (prj != null) {
            ret = J2eeProjectManager.getWebProject(prj);
        }
        return ret;
    }

    private static IWebProject[] getWebProjects() {
        IProject[] projects = J2eeProjectManager.getProjectsByFilter(new FilterOfNature("com.tssap.j2ee.core.web.webNature"));
        IWebProject[] result = new IWebProject[projects.length];
        int i = 0;
        while (i < result.length) {
            result[i] = J2eeProjectManager.getWebProject(projects[i]);
            ++i;
        }
        return result;
    }

    private static IWebProject[] getWebProjects(IJ2eeProjectFilter filter) {
        IJ2eeProject[] filtered = J2eeProjectManager.getFilteredProjects(filter, J2eeProjectManager.getWebProjects());
        if (filtered.length > 0) {
            List<IJ2eeProject> list = Arrays.asList(filtered);
            IWebProject[] ret = new IWebProject[list.size()];
            return list.toArray(ret);
        }
        return new IWebProject[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        projectsCache = null;
    }

    private static class MyModelAccessListener
    implements ModelAccessListener {
        private MyModelAccessListener() {
        }

        public void modelCreated(ModelAccessEvent event) {
        }

        public void modelRemoved(ModelAccessEvent event) {
            String modelName;
            Model model = event.getModel();
            if (model != null && (modelName = model.getUniqueName().getName()) != null) {
                IProject project = null;
                IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject(modelName);
                if (j2eeProject != null) {
                    project = j2eeProject.getProject();
                }
                if (project == null) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(modelName);
                }
                if (project != null) {
                    J2eeProjectManager.removeFromProjectsCache(project);
                }
            }
        }
    }

    private static interface IFilter {
        public boolean accept(Object var1);
    }

    private static class FilterOfNaturesAndName
    extends FilterOfNatures {
        private String myName;

        public FilterOfNaturesAndName(String[] natures, String name) {
            super(natures);
            this.myName = name;
        }

        public boolean accept(Object o) {
            return o instanceof IProject && super.accept(o) && ((IProject)o).getName().equals(this.myName);
        }
    }

    private static class FilterOfNatures
    implements IFilter {
        private String[] myNature;

        public FilterOfNatures(String[] natures) {
            this.myNature = natures;
        }

        public boolean accept(Object o) {
            if (o instanceof IProject) {
                IProject project = (IProject)o;
                if (this.myNature.length > 0) {
                    try {
                        int i = 0;
                        while (i < this.myNature.length) {
                            if (!project.hasNature(this.myNature[i])) {
                                return false;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        tracer.error("", (Throwable)e);
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class FilterOfNatureAndName
    extends FilterOfNature {
        private String myName;

        public FilterOfNatureAndName(String nature, String name) {
            super(nature);
            this.myName = name;
        }

        public boolean accept(Object o) {
            return o instanceof IProject && ((IProject)o).getName().equals(this.myName) && super.accept(o);
        }
    }

    private static class FilterOfNature
    implements IFilter {
        private String myNature;

        public FilterOfNature(String nature) {
            this.myNature = nature;
        }

        public boolean accept(Object o) {
            if (o instanceof IProject) {
                IProject project = (IProject)o;
                try {
                    return project.hasNature(this.myNature);
                }
                catch (CoreException e) {
                    tracer.error("", (Throwable)e);
                    return false;
                }
            }
            return false;
        }
    }
}

