/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model;

import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dii.component.DCUtil;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.providers.ws.WsdModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ejb.IBusinessMethodCapableEjb;
import com.tssap.j2ee.model.ejb.ICreateMethod;
import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.model.ejb.IFinderMethod;
import com.tssap.j2ee.model.ejb.IHomeMethod;
import com.tssap.j2ee.model.ejb.IMessageDrivenBean;
import com.tssap.j2ee.model.ejb.IPersistentField;
import com.tssap.j2ee.model.ejb.ISelectMethod;
import com.tssap.j2ee.model.ejb.impl.EnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.impl.EntityBean;
import com.tssap.j2ee.model.ejb.impl.MessageDrivenBean;
import com.tssap.j2ee.model.ejb.impl.SessionBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ejbjar.dd.impl.Entity;
import com.tssap.j2ee.model.ejbjar.dd.impl.MessageDriven;
import com.tssap.j2ee.model.ejbjar.dd.impl.Session;
import com.tssap.j2ee.model.impl.selena.SelenaElementHolder;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.j2ee.model.service.IJ2EEServiceProject;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.model.web.impl.Filter;
import com.tssap.j2ee.model.web.impl.HtmlFile;
import com.tssap.j2ee.model.web.impl.JavaFile;
import com.tssap.j2ee.model.web.impl.Jsp;
import com.tssap.j2ee.model.web.impl.Listener;
import com.tssap.j2ee.model.web.servlet.impl.Servlet;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class J2eeElementManager
extends SelenaElementUtil {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$model$J2eeElementManager == null ? (class$com$tssap$j2ee$model$J2eeElementManager = J2eeElementManager.class$("com.tssap.j2ee.model.J2eeElementManager")) : class$com$tssap$j2ee$model$J2eeElementManager));
    static /* synthetic */ Class class$com$tssap$j2ee$model$J2eeElementManager;

    public static final Element updateElement(Element element) {
        Element ret = null;
        if (element != null && element.getModel() != null) {
            ret = element.getModel().findElement(element.getUniqueName());
        }
        return ret;
    }

    public static final IEnterpriseJavaBean getEnterpriseJavaBean(Element element) {
        EnterpriseJavaBean bean = null;
        Model model = element.getModel();
        if (!J2eeElementManager.isEnterpriseJavaBean(element)) {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an EJB");
        }
        String propertyValue = element.getPropertyValue("$metaclass");
        UniqueName uniqueName = element.getUniqueName();
        if ("com.tssap.j2ee.core.ejb.EntityBean".equals(propertyValue)) {
            bean = new EntityBean(new Entity(model, uniqueName));
        } else if ("com.tssap.j2ee.core.ejb.SessionBean".equals(propertyValue)) {
            bean = new SessionBean(new Session(model, uniqueName));
        } else if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(propertyValue)) {
            bean = new MessageDrivenBean(new MessageDriven(model, uniqueName));
        }
        return bean;
    }

    public static final SelenaElementHolder getWebServiceDefinition(Element element) {
        SelenaElementHolder wsd = null;
        Model model = element.getModel();
        if (!J2eeElementManager.isWebServiceDefinition(element)) {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not a WSD");
        }
        if (element.hasPropertyValue("$metaclass", WsdModelMetaInfo.getMetaClass())) {
            wsd = new SelenaElementHolder(model, element.getUniqueName());
        }
        return wsd;
    }

    public static final boolean isEnterpriseJavaBean(Element element) {
        String propertyValue;
        boolean ret = false;
        if (element != null && (propertyValue = element.getPropertyValue("$metaclass")) != null && ("com.tssap.j2ee.core.ejb.EntityBean".equals(propertyValue) || "com.tssap.j2ee.core.ejb.SessionBean".equals(propertyValue) || "com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(propertyValue))) {
            ret = true;
        }
        return ret;
    }

    public static final boolean isWebServiceDefinition(Element element) {
        boolean ret = false;
        if (element != null && element.hasPropertyValue("$metaclass", WsdModelMetaInfo.getMetaClass())) {
            ret = true;
        }
        return ret;
    }

    public static final IEjbProject getEjbProject(Element element) {
        String name;
        IEjbModule ret = null;
        if (J2eeElementManager.isEjbProject(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an ejb project");
        }
        ret = J2eeProjectManager.getEjbModule(name);
        return ret;
    }

    public static final boolean isEjbModule(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getEjbModule(name) != null;
        }
        return ret;
    }

    protected static final String getElementName(Element element) {
        UniqueName uniqueName;
        String ret = null;
        if (element != null && (uniqueName = element.getUniqueName()) != null) {
            ret = uniqueName.getName();
        }
        return ret;
    }

    public static final IEjbModule getEjbModule(Element element) {
        IEjbModule ret = null;
        if (!J2eeElementManager.isEjbModule(element)) {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an EJB modul");
        }
        String name = J2eeElementManager.getElementName(element);
        ret = J2eeProjectManager.getEjbModule(name);
        return ret;
    }

    public static final boolean isEjbProject(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getEjbModule(name) != null;
        }
        return ret;
    }

    public static final IEjbAssemblyProject getEjbAssemblyProject(Element element) {
        String name;
        IEjbModule ret = null;
        if (J2eeElementManager.isEjbAssemblyProject(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an ejb assembly project");
        }
        ret = J2eeProjectManager.getEjbModule(name);
        return ret;
    }

    public static final boolean isEjbAssemblyProject(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getEjbModule(name) != null;
        }
        return ret;
    }

    public static final IWebAssemblyProject getWebAssemblyProject(Element element) {
        String name;
        IWebModule ret = null;
        if (J2eeElementManager.isWebAssemblyProject(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not a web assembly project");
        }
        ret = J2eeProjectManager.getWebModule(name);
        return ret;
    }

    public static final boolean isWebAssemblyProject(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getWebModule(name) != null;
        }
        return ret;
    }

    public static final IWebProject getWebProject(Element element) {
        String name;
        IWebModule ret = null;
        if (J2eeElementManager.isWebProject(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not a web project");
        }
        ret = J2eeProjectManager.getWebModule(name);
        return ret;
    }

    public static final boolean isWebProject(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getWebModule(name) != null;
        }
        return ret;
    }

    public static final boolean isWebModule(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getWebModule(name) != null;
        }
        return ret;
    }

    public static final IWebModule getWebModule(Element element) {
        String name;
        IWebModule ret = null;
        if (J2eeElementManager.isWebModule(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not a web module");
        }
        ret = J2eeProjectManager.getWebModule(name);
        return ret;
    }

    public static final IEarProject getEarProject(Element element) {
        String name;
        IEarProject ret = null;
        if (J2eeElementManager.isEarProject(element)) {
            name = J2eeElementManager.getElementName(element);
            if (name == null) {
                throw J2eeElementManager.createIllegalArgumentException(element, "element has no name");
            }
        } else {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an ear project");
        }
        ret = J2eeProjectManager.getEarProject(name);
        return ret;
    }

    public static final boolean isEarProject(Element element) {
        String name;
        boolean ret = false;
        if (element instanceof Model && (name = J2eeElementManager.getElementName(element)) != null) {
            ret = J2eeProjectManager.getEarProject(name) != null;
        }
        return ret;
    }

    public static final IJ2eeProject getJ2eeProject(Element element) {
        if (J2eeElementManager.isEarProject(element)) {
            return J2eeElementManager.getEarProject(element);
        }
        if (J2eeElementManager.isEjbAssemblyProject(element)) {
            return J2eeElementManager.getEjbAssemblyProject(element);
        }
        if (J2eeElementManager.isEjbProject(element)) {
            return J2eeElementManager.getEjbProject(element);
        }
        if (J2eeElementManager.isWebAssemblyProject(element)) {
            return J2eeElementManager.getWebAssemblyProject(element);
        }
        if (J2eeElementManager.isWebProject(element)) {
            return J2eeElementManager.getWebProject(element);
        }
        if (J2eeElementManager.isJ2EELibraryProject(element)) {
            return J2eeElementManager.getJ2EELibraryProject(element);
        }
        if (J2eeElementManager.isJ2EEServiceProject(element)) {
            return J2eeElementManager.getJ2EEServiceProject(element);
        }
        return null;
    }

    public static final ICreateMethod getCreateMethod(Element element) {
        ICreateMethod ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if (J2eeElementManager.isEnterpriseJavaBean((Element)(ejb = element.getParent()))) {
                ret = (ICreateMethod)J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not a create method");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isCreateMethod(Element element) {
        return "com.tssap.j2ee.core.ejb.method.Create".equals(element.getPropertyValue("$metaclass"));
    }

    public static final IFinderMethod getFinderMethod(Element element) {
        IFinderMethod ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals((ejb = element.getParent()).getPropertyValue("$metaclass"))) {
                ret = (IFinderMethod)J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not a finder method");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isFinderMethod(Element element) {
        return "com.tssap.j2ee.core.ejb.method.Find".equals(element.getPropertyValue("$metaclass"));
    }

    public static final IHomeMethod getHomeMethod(Element element) {
        IHomeMethod ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if (J2eeElementManager.isEnterpriseJavaBean((Element)(ejb = element.getParent()))) {
                ret = (IHomeMethod)J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not a Home method");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isHomeMethod(Element element) {
        return "com.tssap.j2ee.core.ejb.method.Home".equals(element.getPropertyValue("$metaclass"));
    }

    public static final ISelectMethod getSelectMethod(Element element) {
        ISelectMethod ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals((ejb = element.getParent()).getPropertyValue("$metaclass"))) {
                ret = (ISelectMethod)J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not a select method");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isSelectMethod(Element element) {
        return "com.tssap.j2ee.core.ejb.method.Select".equals(element.getPropertyValue("$metaclass"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final IBusinessMethod getBusinessMethod(Element element) {
        com.tssap.selena.model.elements.Entity ejb;
        IBusinessMethod ret = null;
        if (element == null) throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
        if (element instanceof Reference) {
            element = ((Reference)element).getEntity();
        }
        if (!J2eeElementManager.isEnterpriseJavaBean((Element)(ejb = element.getParent()))) throw J2eeElementManager.createIllegalArgumentException(element, "not member of an business-method capable ejb");
        IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)ejb);
        if (bean instanceof IBusinessMethodCapableEjb) {
            ret = ((IBusinessMethodCapableEjb)bean).getBusinessMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
            if (ret == null) throw J2eeElementManager.createIllegalArgumentException(element, "is not a business method");
            return ret;
        }
        if (!(bean instanceof IMessageDrivenBean)) return null;
        IEjbMethod method = bean.getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
        if (method == null) throw J2eeElementManager.createIllegalArgumentException(element, "is not a business method");
        if (!(method instanceof IBusinessMethod)) throw J2eeElementManager.createIllegalArgumentException(element, "is not a business method");
        return (IBusinessMethod)method;
    }

    public static final boolean isBusinessMethod(Element element) {
        return "com.tssap.j2ee.core.ejb.method.Business".equals(element.getPropertyValue("$metaclass"));
    }

    public static final IPersistentField getPersistentField(Element element) {
        IPersistentField ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if ("com.tssap.j2ee.core.ejb.EntityBean".equals((ejb = element.getParent()).getPropertyValue("$metaclass"))) {
                ret = ((IEntityBean)J2eeElementManager.getEnterpriseJavaBean((Element)ejb)).getPersistentField(element.getPropertyValue("$name"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not a business method");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isPersistentField(Element element) {
        return "com.tssap.j2ee.core.ejb.field.Persistent".equals(element.getPropertyValue("$metaclass"));
    }

    public static final IEjbMethod getEjbMethod(Element element) {
        IEjbMethod ret = null;
        if (element != null) {
            com.tssap.selena.model.elements.Entity ejb;
            if (element instanceof Reference) {
                element = ((Reference)element).getEntity();
            }
            if (J2eeElementManager.isEnterpriseJavaBean((Element)(ejb = element.getParent()))) {
                ret = J2eeElementManager.getEnterpriseJavaBean((Element)ejb).getEJBMethod(element.getPropertyValue("$name"), (String[])element.getObjectPropertyValue("parameterArray"));
                if (ret != null) {
                    return ret;
                }
                throw J2eeElementManager.createIllegalArgumentException(element, "is not an ejbmethod");
            }
            throw J2eeElementManager.createIllegalArgumentException(element, "not member of an ejb");
        }
        throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
    }

    public static final boolean isEjbMethod(Element element) {
        return J2eeElementManager.isBusinessMethod(element) || J2eeElementManager.isCreateMethod(element) || J2eeElementManager.isFinderMethod(element) || J2eeElementManager.isHomeMethod(element) || J2eeElementManager.isSelectMethod(element);
    }

    public static final boolean isEjbField(Element element) {
        return "com.tssap.j2ee.core.ejb.field.Persistent".equals(element.getPropertyValue("$metaclass"));
    }

    public static final boolean isSecurityRole(Element element) {
        return element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.ejbjar.SecurityRole") || element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.ear.SecurityRole") || element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.webapp.SecurityRole");
    }

    public static final boolean isResourceReference(Element element) {
        return "com.tssap.j2ee.core.ejbjar.ResourceRef".equals(element.getPropertyValue("$metaclass"));
    }

    public static final boolean isEnvironmentEntry(Element element) {
        return "com.tssap.j2ee.core.ejbjar.EnvEntry".equals(element.getPropertyValue("$metaclass"));
    }

    public static final boolean isResourceEnvironmentReference(Element element) {
        return "com.tssap.j2ee.core.ejbjar.ResourceEnvRef".equals(element.getPropertyValue("$metaclass"));
    }

    public static final boolean isEjbJar(Element element) {
        return EjbJarModelMetaInfo.isEjbJar((UniqueName)element.getUniqueName());
    }

    public static final boolean isEjbJarArchive(Element element) {
        boolean ret = false;
        IEjbAssemblyProject project = null;
        try {
            project = J2eeElementManager.getEjbAssemblyProject((Element)element.getModel());
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching Ejbmodules failed", (Throwable)e);
        }
        if (project == null) {
            ret = false;
        } else {
            IFile archiveFile = project.getArchiveLocationFullPath();
            ret = J2eeElementManager.isArchiveWithName(element, archiveFile);
        }
        return ret;
    }

    private static boolean isArchiveWithName(Element element, IFile archiveFile) {
        IResource resource;
        boolean ret = false;
        if (archiveFile != null && (resource = J2eeElementManager.getResourceToElement(element)) instanceof IFile) {
            File resFile = ((IFile)resource).getLocation().toFile();
            ret = archiveFile.getLocation().toFile().equals(resFile);
        }
        return ret;
    }

    public static final boolean isJ2eeLibraryArchive(Element element) {
        boolean ret = false;
        IJ2EELibraryProject project = null;
        try {
            project = J2eeElementManager.getJ2EELibraryProject((Element)element.getModel());
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching J2eeLibraryProjects failed", (Throwable)e);
        }
        if (project == null) {
            ret = false;
        } else {
            IFile archiveFile = project.getArchiveLocationFullPath();
            ret = J2eeElementManager.isArchiveWithName(element, archiveFile);
        }
        return ret;
    }

    public static final boolean isJ2eeServiceArchive(Element element) {
        boolean ret = false;
        IJ2EEServiceProject project = null;
        try {
            project = J2eeElementManager.getJ2EEServiceProject((Element)element.getModel());
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching J2eeServiceProjects failed", (Throwable)e);
        }
        if (project == null) {
            ret = false;
        } else {
            IFile archiveFile = project.getArchiveLocationFullPath();
            ret = J2eeElementManager.isArchiveWithName(element, archiveFile);
        }
        return ret;
    }

    public static final boolean isClientAPIJarArchive(Element element) {
        return element.getUniqueName().getName().endsWith("ClientAPI.jar");
    }

    public static final boolean isWAR(Element element) {
        return WebAppModelMetaInfo.isWebApp((UniqueName)element.getUniqueName());
    }

    public static final boolean isWarArchive(Element element) {
        boolean ret = false;
        IWebAssemblyProject project = null;
        try {
            project = J2eeElementManager.getWebAssemblyProject((Element)element.getModel());
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching Webmodules failed", (Throwable)e);
        }
        if (project == null) {
            ret = false;
        } else {
            IFile archiveFile = project.getArchiveLocationFullPath();
            ret = J2eeElementManager.isArchiveWithName(element, archiveFile);
        }
        return ret;
    }

    public static final boolean isEAR(Element element) {
        return EarModelMetaInfo.isEAR((UniqueName)element.getUniqueName());
    }

    public static final boolean isEarArchive(Element element) {
        boolean ret = false;
        IEarProject project = null;
        try {
            project = J2eeElementManager.getEarProject((Element)element.getModel());
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching earproject failed", (Throwable)e);
        }
        if (project == null) {
            ret = false;
        } else {
            IFile archiveFile = project.getArchiveLocationFullPath();
            ret = J2eeElementManager.isArchiveWithName(element, archiveFile);
        }
        return ret;
    }

    protected static final IllegalArgumentException createIllegalArgumentException(Element element, String reason) {
        return new IllegalArgumentException("Element <name, metaclass=" + element.getPropertyValue("$name") + ", " + element.getPropertyValue("$metaclass") + "> " + reason);
    }

    public static final IWebSource getWebSource(Element element) {
        if (element instanceof Reference) {
            element = ((Reference)element).getEntity();
        }
        if (J2eeElementManager.isFilter(element)) {
            return new Filter((com.tssap.selena.model.elements.Entity)element);
        }
        if (J2eeElementManager.isServlet(element)) {
            return new Servlet((com.tssap.selena.model.elements.Entity)element);
        }
        if (J2eeElementManager.isListener(element)) {
            com.tssap.selena.model.elements.Entity ent = (com.tssap.selena.model.elements.Entity)element;
            if ("com.tssap.j2ee.core.web.HttpSessionAttributeListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 0);
            }
            if ("com.tssap.j2ee.core.web.HttpSessionListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 1);
            }
            if ("com.tssap.j2ee.core.web.HttpSessionActivationListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 5);
            }
            if ("com.tssap.j2ee.core.web.HttpSessionBindingListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 4);
            }
            if ("com.tssap.j2ee.core.web.ServletContextAttributeListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 2);
            }
            if ("com.tssap.j2ee.core.web.ServletContextListener".equals(element.getPropertyValue("$metaclass"))) {
                return new Listener(ent, 3);
            }
            throw new IllegalStateException("Listener of unknown metaclass: " + element.getPropertyValue("$metaclass"));
        }
        if (J2eeElementManager.isJsp(element)) {
            return new Jsp((com.tssap.selena.model.elements.Entity)element);
        }
        if (J2eeElementManager.isHtmlFile(element)) {
            return new HtmlFile((com.tssap.selena.model.elements.Entity)element);
        }
        if (J2eeElementManager.isJavaFile(element)) {
            return new JavaFile((com.tssap.selena.model.elements.Entity)element);
        }
        return null;
    }

    public static final boolean isJsp(Element element) {
        return element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.web.JSP") || element.getUniqueName().getLocation().endsWith(".jsp");
    }

    public static final boolean isServlet(Element element) {
        return element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.web.Servlet");
    }

    public static final boolean isFilter(Element element) {
        return element.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.web.Filter");
    }

    public static final boolean isListener(Element element) {
        String metaclass = element.getPropertyValue("$metaclass");
        return WebAppModelMetaInfo.isListener((UniqueName)element.getUniqueName()) || WebModelMetaInfo.isWebListener((UniqueName)element.getUniqueName()) || "com.tssap.j2ee.core.web.ServletContextAttributeListener".equals(metaclass) || "com.tssap.j2ee.core.web.ServletContextListener".equals(metaclass) || "com.tssap.j2ee.core.web.HttpSessionAttributeListener".equals(metaclass) || "com.tssap.j2ee.core.web.HttpSessionListener".equals(metaclass) || "com.tssap.j2ee.core.web.HttpSessionBindingListener".equals(metaclass) || "com.tssap.j2ee.core.web.HttpSessionActivationListener".equals(metaclass);
    }

    public static final boolean isHtmlFile(Element element) {
        boolean ret = element.getUniqueName().getName().endsWith(".html") || element.getUniqueName().getName().endsWith(".htm") || element.getUniqueName().getName().endsWith(".xhtml") || element.getUniqueName().getName().endsWith(".xhtm");
        return ret;
    }

    public static final boolean isResourceFile(Element element) {
        return "com.tssap.j2ee.core.web.Resource".equals(element.getPropertyValue("$metaclass"));
    }

    public static final boolean isImageResourceFile(Element element) {
        return J2eeElementManager.isGIFImageResourceFile(element) || J2eeElementManager.isTIFFResourceFile(element) || J2eeElementManager.isJPEGImageResourceFile(element);
    }

    public static final boolean isJPEGImageResourceFile(Element element) {
        String name = element.getUniqueName().getName();
        return "com.tssap.j2ee.core.web.Resource".equals(element.getPropertyValue("$metaclass")) && (name.endsWith(".jpeg") || name.endsWith(".jpg"));
    }

    public static final boolean isGIFImageResourceFile(Element element) {
        String name = element.getUniqueName().getName();
        return "com.tssap.j2ee.core.web.Resource".equals(element.getPropertyValue("$metaclass")) && name.endsWith(".gif");
    }

    public static final boolean isTIFFResourceFile(Element element) {
        String name = element.getUniqueName().getName();
        return "com.tssap.j2ee.core.web.Resource".equals(element.getPropertyValue("$metaclass")) && (name.endsWith(".tiff") || name.endsWith(".tif"));
    }

    public static final boolean isJavaFile(Element element) {
        return "FileAndFolder".equals(element.getPropertyValue("$metaclass")) && element.getUniqueName().getLocation().endsWith(".java");
    }

    public static final boolean isSQLJFile(Element element) {
        return "FileAndFolder".equals(element.getPropertyValue("$metaclass")) && element.getUniqueName().getLocation().endsWith(".sqlj");
    }

    public static final boolean isWebFolder(Element element) {
        String DOMAIN = "com.tssap.j2ee.core.web";
        String SUBDOMAIN = "com.tssap.j2ee.core.web.WebContent";
        boolean ret = element.getUniqueName().getSubDomain().equals("com.tssap.j2ee.core.web.WebContent") && element.getUniqueName().getDomain().equalsIgnoreCase("com.tssap.j2ee.core.web");
        return ret;
    }

    public static final IResource getWebFolder(Element element) {
        IResource ret = null;
        if (J2eeElementManager.isWebFolder(element)) {
            String location = element.getUniqueName().getLocation();
            location = location.substring(location.indexOf("/", 1) + 1);
            IProject project = J2eeElementManager.getWebProject((Element)element.getModel()).getProject();
            if (project != null) {
                ret = project.findMember(location);
            }
        }
        return ret;
    }

    public static final IResource getWebClientSourceFolder(Element element) {
        IResource ret = null;
        if (J2eeElementManager.isWebClientSourceFolder(element)) {
            String location = element.getUniqueName().getLocation();
            location = location.substring(location.indexOf("/", 1) + 1);
            IProject project = J2eeElementManager.getWebProject((Element)element.getModel()).getProject();
            if (project != null) {
                ret = project.findMember(location);
            }
        }
        return ret;
    }

    public static final boolean isWebClientSourceFolder(Element element) {
        String DOMAIN = "com.tssap.j2ee.core.web";
        String SUBDOMAIN = "com.tssap.j2ee.core.web.WebContent";
        boolean ret = element.getUniqueName().getSubDomain().equals("com.tssap.j2ee.core.web.WebContent") && element.getParent() instanceof Model && element.getUniqueName().getDomain().equalsIgnoreCase("com.tssap.j2ee.core.web");
        return ret;
    }

    public static final boolean isWebClientSource(Element element) {
        return J2eeElementManager.isJsp(element) || J2eeElementManager.isHtmlFile(element);
    }

    public static final boolean isWebClientSourceFile(Element element) {
        if (J2eeElementManager.isLocatedUnderneathWebContent(element)) {
            String location = element.getUniqueName().getLocation();
            location = location.substring(location.indexOf("/", 1));
            IResource res = null;
            res = J2eeElementManager.getWebProject((Element)element.getModel()).getProject().findMember(location);
            if (res != null && res instanceof IFile) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isWebClientFolder(Element element) {
        if (J2eeElementManager.isLocatedUnderneathWebContent(element)) {
            String location = element.getUniqueName().getLocation();
            location = location.substring(location.indexOf("/", 1));
            IResource res = null;
            res = J2eeElementManager.getWebProject((Element)element.getModel()).getProject().findMember(location);
            if (res != null && res instanceof IFolder) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isLocatedUnderneathWebContent(Element element) {
        return element.getUniqueName().getLocation().indexOf("webContent") > -1;
    }

    public static final boolean isWebServerSource(Element element) {
        return J2eeElementManager.isServlet(element) || J2eeElementManager.isFilter(element) || J2eeElementManager.isListener(element);
    }

    public static final boolean isProxy(Element element) {
        return element.getUniqueName().getDomain().equals("com.tssap.selena.proxy");
    }

    public static final boolean isWARProxy(Element element) {
        return J2eeElementManager.isProxy(element) && J2eeElementManager.hasMetaClass(element, "com.tssap.j2ee.core.webapp.WebApp");
    }

    public static final boolean isEjbJarProxy(Element element) {
        return J2eeElementManager.isProxy(element) && J2eeElementManager.hasMetaClass(element, "com.tssap.j2ee.core.ejbjar.EjbJar");
    }

    private static final boolean hasMetaClass(Element element, String metaClass) {
        return element.getPropertyValue("$metaclass").equals(metaClass);
    }

    public static final boolean isJspRegistry(Element element) {
        return element.getUniqueName().equals(WebModelMetaInfo.JSP_REGISTRY);
    }

    public static final boolean isServletRegistry(Element element) {
        return element.getUniqueName().equals(WebModelMetaInfo.SERVLET_REGISTRY);
    }

    public static final boolean isFilterRegistry(Element element) {
        return element.getUniqueName().equals(WebModelMetaInfo.FILTER_REGISTRY);
    }

    public static final boolean isListenerRegistry(Element element) {
        return element.getUniqueName().equals(WebModelMetaInfo.LISTENER_REGISTRY);
    }

    public static final boolean isBeanRegistry(Element element) {
        return element.getUniqueName().equals(EjbModelMetaInfo.BEAN_REGISTRY);
    }

    public static final boolean isJavaSrcFolder(Element element) {
        return J2eeElementManager.isJ2eeSourceFolder(element);
    }

    public static final boolean isPackageFragmentFolder(Element element) {
        return J2eeElementManager.isPackageFragment(element);
    }

    public static boolean isPackageFragment(Element element) {
        return J2eeElementManager.getPackageFragment(element) != null;
    }

    public static IPackageFragment getPackageFragment(Element element) {
        IPackageFragment ret = null;
        IFolder folder = J2eeElementManager.getFolder(element);
        IJavaElement javaElement = JavaCore.create((IFolder)folder);
        if (javaElement instanceof IPackageFragmentRoot) {
            ret = J2eeElementManager.getPackageFragmentByName(J2eeProjectManager.getJ2eeProject(element.getModel().getUniqueName().getName()), "");
        } else if (javaElement instanceof IPackageFragment) {
            ret = (IPackageFragment)javaElement;
        }
        return ret;
    }

    public static boolean isFolder(Element element) {
        boolean ret = J2eeElementManager.getFolder(element) != null;
        return ret;
    }

    private static IFolder getFolder(Element element) {
        IFolder ret = null;
        IResource obj = J2eeElementManager.getResourceToElement(element);
        if (obj != null && obj instanceof IFolder) {
            ret = (IFolder)obj;
        }
        return ret;
    }

    private static final IResource getJ2eeFileOrFolder(Element element) {
        IResource ret = null;
        String resourcePath = element.getPropertyValue("$file");
        IJ2eeProject prj = J2eeElementManager.getJ2eeProject((Element)element.getModel());
        if (resourcePath != null && prj != null) {
            ret = prj.getProject().findMember(resourcePath);
        }
        return ret;
    }

    public static final IResource getResourceToElement(Element element) {
        IResource ret = FileAndFolderManagement.getInstance().getResource(element);
        if (ret == null) {
            ret = J2eeElementManager.getJ2eeFileOrFolder(element);
        }
        return ret;
    }

    public static IPackageFragment getPackageFragmentByName(IJ2eeProject prj, String name) {
        try {
            IPackageFragmentRoot[] roots = com.tssap.util.jdt.JDTUtils.getSrcPackageFragmentRoots((IJavaProject)prj.getJavaProject());
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] fragments = roots[i].getChildren();
                int j = 0;
                while (j < fragments.length) {
                    if (fragments[j] instanceof IPackageFragment && fragments[j].getElementName().equals(name)) {
                        return (IPackageFragment)fragments[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            tracer.error("getPackageFragmentByName", "No packageFragments found", (Throwable)exp);
            return null;
        }
        return null;
    }

    public static boolean isInitParameter(Element elem) {
        return "com.tssap.j2ee.core.webapp.InitParameter".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isSecurityConstraint(Element elem) {
        return "com.tssap.j2ee.core.webapp.SecurityConstraint".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isWebResourceCollection(Element elem) {
        return "com.tssap.j2ee.core.webapp.WebResourceCollection".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isMimeMapping(Element elem) {
        return "com.tssap.j2ee.core.webapp.MimeMapping".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isMimeMappingRegistry(Element elem) {
        return "com.tssap.j2ee.core.webapp.MimeMappingRegistry".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isContextParameter(Element elem) {
        return "com.tssap.j2ee.core.webapp.ContextParameter".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isContextParameterRegistry(Element elem) {
        return "com.tssap.j2ee.core.webapp.ContextParameterRegistry".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isEjbRef(Element elem) {
        return "com.tssap.j2ee.core.webapp.EjbRef".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isEjbLocalRef(Element elem) {
        return "com.tssap.j2ee.core.webapp.EjbLocalRef".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isErrorPage(Element elem) {
        return "com.tssap.j2ee.core.webapp.ErrorPage".equals(elem.getPropertyValue("$metaclass"));
    }

    public static boolean isComponentProject(Element elem) {
        if (SelenaElementUtil.isProjectModel((Element)elem)) {
            try {
                IProject prj = J2eeProjectManager.getJ2eeProject(elem.getUniqueName().getName()).getProject();
                if (prj != null) {
                    return DCProjectInfo.isDCProject((IProject)prj);
                }
            }
            catch (Exception e) {
                tracer.warning("Check for DCProject failed", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean isEjbRelation(Element elem) {
        String prop = elem.getPropertyValue("$metaclass");
        return "com.tssap.j2ee.core.ejbjar.EjbRelation".equals(prop) || "com.tssap.j2ee.core.ejb.field.Relation".equals(prop);
    }

    public static boolean isBMPAttribute(Element elem) {
        if (J2eeElementManager.isPersistentField(elem) && !J2eeElementManager.getPersistentField(elem).isPKField() && J2eeElementManager.isEnterpriseJavaBean((Element)elem.getParent())) {
            IEnterpriseJavaBean ejb = null;
            ejb = J2eeElementManager.getEnterpriseJavaBean((Element)elem.getParent());
            if (ejb != null && ejb.getEjbType() == 0 && !((IEntityBean)ejb).isCMP()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isJ2EELibraryProject(Element element) {
        boolean ret = false;
        try {
            IJ2EELibraryProject project = J2eeElementManager.getJ2EELibraryProject(element);
            if (project != null) {
                ret = true;
            }
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching J2eeLibraryProject failed", (Throwable)e);
            return false;
        }
        return ret;
    }

    public static boolean isJ2EEServiceProject(Element element) {
        boolean ret = false;
        try {
            IJ2EEServiceProject project = J2eeElementManager.getJ2EEServiceProject(element);
            if (project != null) {
                ret = true;
            }
        }
        catch (RuntimeException e) {
            tracer.warning("Fetching J2eeServiceProject failed", (Throwable)e);
            return false;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final IJ2EELibraryProject getJ2EELibraryProject(Element element) {
        IJ2EELibraryProject ret = null;
        if (element == null || !(element instanceof Model)) throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
        UniqueName uName = element.getUniqueName();
        if (uName == null) throw J2eeElementManager.createIllegalArgumentException(element, "no unique name available");
        String name = uName.getName();
        if (name == null) {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an service project");
        }
        ret = J2eeProjectManager.getLibraryProject(name);
        if (ret != null) return ret;
        throw J2eeElementManager.createIllegalArgumentException(element, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final IJ2EEServiceProject getJ2EEServiceProject(Element element) {
        IJ2EEServiceProject ret = null;
        if (element == null || !(element instanceof Model)) throw J2eeElementManager.createIllegalArgumentException(element, "element is null");
        UniqueName uName = element.getUniqueName();
        if (uName == null) throw J2eeElementManager.createIllegalArgumentException(element, "no unique name available");
        String name = uName.getName();
        if (name == null) {
            throw J2eeElementManager.createIllegalArgumentException(element, "is not an ear project");
        }
        ret = J2eeProjectManager.getServiceProject(name);
        if (ret != null) return ret;
        throw J2eeElementManager.createIllegalArgumentException(element, "");
    }

    public static boolean isJ2eeSourceFolder(Element elem) {
        IResource res = J2eeElementManager.getResourceToElement(elem);
        if (!(res instanceof IFolder)) {
            return false;
        }
        IProject prj = J2eeElementManager.getJ2eeProject((Element)elem.getModel()).getProject();
        IJavaProject javPrj = JavaCore.create((IProject)prj);
        if (javPrj != null && javPrj.exists()) {
            IPackageFragmentRoot pkgRoot = null;
            pkgRoot = javPrj.getPackageFragmentRoot(res);
            if (pkgRoot != null && pkgRoot.exists()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPersistentFieldAccessor(Element elem) {
        return "cmpAccessor".equals(elem.getPropertyValue("isAccessor"));
    }

    public static boolean isCMRFieldAccessor(Element elem) {
        return "cmrAccessor".equals(elem.getPropertyValue("isAccessor"));
    }

    public static IBusinessMethod[] getPersistentFieldAccessorsToElement(Element elem) {
        if (J2eeElementManager.isEjbField(elem)) {
            return J2eeElementManager.getAccessorsToElement(elem);
        }
        return null;
    }

    public static IBusinessMethod[] getCMRFieldAccessorsToElement(Element elem) {
        if (J2eeElementManager.isEjbRelation(elem)) {
            return J2eeElementManager.getAccessorsToElement(elem);
        }
        return null;
    }

    private static IBusinessMethod[] getAccessorsToElement(Element elem) {
        String name = elem.getPropertyValue("$name");
        String getterName = com.tssap.j2ee.internal.core.ejb.util.JDTUtils.getGetterName((String)name);
        String setterName = com.tssap.j2ee.internal.core.ejb.util.JDTUtils.getSetterName((String)name);
        String fieldType = elem.getPropertyValue("$type");
        IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)elem.getParent());
        if (bean instanceof IBusinessMethodCapableEjb) {
            IBusinessMethod setter;
            ArrayList<IBusinessMethod> resultHolder = new ArrayList<IBusinessMethod>();
            IBusinessMethodCapableEjb theBean = (IBusinessMethodCapableEjb)bean;
            IBusinessMethod getter = theBean.getBusinessMethod(getterName, ArrayUtils.EMPTY_STRING_ARRAY);
            if (getter != null) {
                resultHolder.add(getter);
            }
            if ((setter = theBean.getBusinessMethod(setterName, new String[]{fieldType})) != null) {
                resultHolder.add(setter);
            }
            return resultHolder.toArray(new IBusinessMethod[resultHolder.size()]);
        }
        return null;
    }

    public static boolean isMETAINFFolder(Element element) {
        return J2eeElementManager.isEJBJARMETAINFFolder(element) || J2eeElementManager.isEARMETAINFFolder(element);
    }

    public static boolean isEJBJARMETAINFFolder(Element element) {
        return J2eeElementManager.hasDataModelDomain(element) && J2eeElementManager.isEjbModule((Element)element.getParent()) && element.getUniqueName().getName().equalsIgnoreCase("META-INF");
    }

    public static boolean isEARMETAINFFolder(Element element) {
        return J2eeElementManager.hasDataModelDomain(element) && J2eeElementManager.isEarProject((Element)element.getParent()) && element.getUniqueName().getName().equalsIgnoreCase("META-INF");
    }

    public static boolean isWEBINFFolder(Element element) {
        return J2eeElementManager.hasDataModelDomain(element) && J2eeElementManager.isWebModule((Element)element.getParent()) && element.getUniqueName().getName().equalsIgnoreCase("WEB-INF");
    }

    public static IFolder getMETAINFFolder(Element element) {
        if (J2eeElementManager.isMETAINFFolder(element)) {
            return J2eeElementManager.getFolder(element);
        }
        return null;
    }

    public static IFolder getEARMETAINFFolder(Element element) {
        if (J2eeElementManager.isEARMETAINFFolder(element)) {
            return J2eeElementManager.getFolder(element);
        }
        return null;
    }

    public static IFolder getEJBJARMETAINFFolder(Element element) {
        if (J2eeElementManager.isEJBJARMETAINFFolder(element)) {
            return J2eeElementManager.getFolder(element);
        }
        return null;
    }

    public static IFolder getWEBINFFolder(Element element) {
        if (J2eeElementManager.isWEBINFFolder(element)) {
            return J2eeElementManager.getFolder(element);
        }
        return null;
    }

    private static boolean hasDataModelDomain(Element element) {
        return element.getUniqueName().getDomain().equalsIgnoreCase("DataModel");
    }

    public static boolean isReferencedEjb(Element element) {
        IEnterpriseJavaBean enterpriseJavaBean;
        IEjbModule module;
        boolean ret = false;
        if (J2eeElementManager.isEnterpriseJavaBean(element) && (module = J2eeElementManager.getEjbModule((Element)element.getModel())) != null && (enterpriseJavaBean = J2eeElementManager.getEnterpriseJavaBean(element)) != null) {
            ret = module.isReferenced(enterpriseJavaBean);
        }
        return ret;
    }

    public static boolean isReferencedWebObject(Element element) {
        IWebSource webObject = J2eeElementManager.getWebSource(element);
        if (webObject == null) {
            return false;
        }
        Model model = element.getModel();
        if (J2eeElementManager.isWebModule((Element)model)) {
            IWebModule module = J2eeElementManager.getWebModule((Element)model);
            if (module == null) {
                return false;
            }
            try {
                return module.isReferenced(webObject);
            }
            catch (Exception e) {
                tracer.warning("Check for referencing projects failed", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean isWebRegistry(Element element) {
        return J2eeElementManager.isFilterRegistry(element) || J2eeElementManager.isListenerRegistry(element) || J2eeElementManager.isServletRegistry(element) || J2eeElementManager.isJspRegistry(element);
    }

    public static boolean isEJBSAPDescriptorType(Element elem) {
        return elem.getUniqueName().getName().equalsIgnoreCase("META-INF/ejb-j2ee-engine.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/persistent.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/ejb-jar.xml");
    }

    public static boolean isWEBSAPDescriptorType(Element elem) {
        return elem.getUniqueName().getName().equalsIgnoreCase("WEB-INF/web-j2ee-engine.xml") || elem.getUniqueName().getName().equalsIgnoreCase("WEB-INF/web.xml");
    }

    public static boolean isEARSAPDescriptorType(Element elem) {
        return elem.getUniqueName().getName().equalsIgnoreCase("META-INF/application-j2ee-engine.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/application.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/log-configuration.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/sda-dd.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/data-source-aliases.xml") || elem.getUniqueName().getName().equalsIgnoreCase("META-INF/sap.application.global.properties");
    }

    public static boolean isDCMetaDataNode(Element element) {
        boolean ret = false;
        UniqueName uniqueName = element.getUniqueName();
        if (uniqueName != null) {
            String domain = uniqueName.getDomain();
            String subDomain = uniqueName.getSubDomain();
            if (domain != null && subDomain != null) {
                ret = DCUtil.isDCMetaDataFolder((Element)element);
            }
        }
        return ret;
    }

    public static boolean isJ2eeProject(Element element) {
        return element instanceof Model && (J2eeElementManager.isEjbModule(element) || J2eeElementManager.isWebModule(element) || J2eeElementManager.isJ2EELibraryProject(element) || J2eeElementManager.isJ2EEServiceProject(element) || J2eeElementManager.isEarProject(element));
    }

    public static IEnterpriseJavaBean[] getUnreferencedEjbs(Element element) {
        IEnterpriseJavaBean[] referencedEjbs;
        if (!J2eeElementManager.isEjbModule((Element)element.getModel())) {
            return new IEnterpriseJavaBean[0];
        }
        IEjbModule module = J2eeElementManager.getEjbModule((Element)element.getModel());
        IEnterpriseJavaBean[] beans = module.getEnterpriseBeans();
        if (!J2eeElementManager.hasUnreferencedEjbsInternal(beans, referencedEjbs = module.getReferencedEjbs())) {
            return new IEnterpriseJavaBean[0];
        }
        ArrayList<IEnterpriseJavaBean> unrefBeans = new ArrayList<IEnterpriseJavaBean>();
        HashSet<IType> hashForReferencedEjbs = new HashSet<IType>(referencedEjbs.length);
        int i = 0;
        while (i < referencedEjbs.length) {
            IType beanClass = referencedEjbs[i].getBeanClass();
            hashForReferencedEjbs.add(beanClass);
            ++i;
        }
        int i2 = 0;
        while (i2 < beans.length) {
            IEnterpriseJavaBean bean = beans[i2];
            IType beanClass = bean.getBeanClass();
            boolean isReferenced = hashForReferencedEjbs.contains(beanClass);
            if (!isReferenced) {
                unrefBeans.add(bean);
            }
            ++i2;
        }
        return unrefBeans.toArray(new IEnterpriseJavaBean[0]);
    }

    public static boolean hasUnreferencedEjbs(Element element) {
        boolean ret = false;
        if (J2eeElementManager.isEjbModule((Element)element.getModel())) {
            IEjbModule module = J2eeElementManager.getEjbModule((Element)element.getModel());
            IEnterpriseJavaBean[] ejbs = module.getEnterpriseBeans();
            IEnterpriseJavaBean[] referencedEjbs = module.getReferencedEjbs();
            ret = J2eeElementManager.hasUnreferencedEjbsInternal(ejbs, referencedEjbs);
        }
        return ret;
    }

    private static boolean hasUnreferencedEjbsInternal(IEnterpriseJavaBean[] ejbs, IEnterpriseJavaBean[] referencedEjbs) {
        boolean ret = false;
        HashSet<IType> hashForReferencedEjbs = new HashSet<IType>(referencedEjbs.length);
        int i = 0;
        while (i < referencedEjbs.length) {
            IType beanClass = referencedEjbs[i].getBeanClass();
            hashForReferencedEjbs.add(beanClass);
            ++i;
        }
        int i2 = 0;
        while (!ret && i2 < ejbs.length) {
            IEnterpriseJavaBean ejb = ejbs[i2];
            IType beanClass = ejb.getBeanClass();
            boolean isReferenced = hashForReferencedEjbs.contains(beanClass);
            if (!isReferenced) {
                ret = true;
            }
            ++i2;
        }
        return ret;
    }

    public static IWebSource[] getUnreferencedWebObjects(Element element) {
        if (!J2eeElementManager.isWebModule((Element)element.getModel()) || !J2eeElementManager.hasUnreferencedWebObjects(element)) {
            return new IWebSource[0];
        }
        ArrayList<IWebSource> unrefWebObjects = new ArrayList<IWebSource>();
        IWebModule module = J2eeElementManager.getWebModule((Element)element.getModel());
        IServerSource[] serverSources = module.getServerSources();
        int i = 0;
        while (i < serverSources.length) {
            IServerSource src = serverSources[i];
            if (!module.isReferenced(src)) {
                unrefWebObjects.add(src);
            }
            ++i;
        }
        try {
            IClientSource[] clientSources = module.getClientSources();
            int i2 = 0;
            while (i2 < clientSources.length) {
                IClientSource src = clientSources[i2];
                if (!module.isReferenced(src)) {
                    unrefWebObjects.add(src);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            tracer.warning("Fetching clientsources to module failed", (Throwable)e);
        }
        return unrefWebObjects.toArray(new IWebSource[0]);
    }

    public static boolean hasUnreferencedWebObjects(Element element) {
        if (J2eeElementManager.isWebModule((Element)element.getModel())) {
            IWebModule module = J2eeElementManager.getWebModule((Element)element.getModel());
            IServerSource[] serverSources = module.getServerSources();
            IClientSource[] clientSources = new IClientSource[]{};
            try {
                clientSources = module.getClientSources();
            }
            catch (Exception e) {
                tracer.warning("Fetching all client sources to module failed", (Throwable)e);
            }
            IServerSource[] referencedServerSources = module.getReferencedServerSources();
            IClientSource[] referencedClientSources = module.getReferencedClientSources();
            return serverSources.length != referencedServerSources.length || clientSources.length != referencedClientSources.length;
        }
        return false;
    }

    public static boolean isResourceLocatedUnderneathSourceFolder(Element element) throws Exception {
        IResource res = J2eeElementManager.getResourceToElement(element);
        if (res == null || !res.exists()) {
            return false;
        }
        IJavaProject javPrj = JavaCore.create((IProject)res.getProject());
        if (javPrj == null || !javPrj.exists()) {
            throw new Exception("Not located in a JavaProject");
        }
        IPackageFragmentRoot[] allSrcRoots = JDTUtils.getSrcPackageFragmentRoots((IJavaProject)javPrj);
        int i = 0;
        while (i < allSrcRoots.length) {
            IPackageFragmentRoot root = allSrcRoots[i];
            IFolder folder = (IFolder)root.getUnderlyingResource();
            if (folder.findMember(res.getProjectRelativePath().removeFirstSegments(1)) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

