/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.model;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.j2ee.util.portal.PortalFactory;

public class DCProjectFilter
implements IJ2eeProjectFilter {
    private boolean acceptDC;
    private String devConfiguration = null;

    public DCProjectFilter(boolean acceptDC) {
        this.acceptDC = acceptDC;
    }

    public DCProjectFilter(String devConfiguration) {
        this.acceptDC = true;
        this.devConfiguration = devConfiguration;
    }

    public boolean accept(IJ2eeProject prj) {
        boolean ret = false;
        boolean hasDCNature = J2eeProjectManager.isComponentProject(prj);
        if (this.acceptDC && hasDCNature) {
            if (this.devConfiguration != null && !this.devConfiguration.equals(this.getDevConfig(prj))) {
                return false;
            }
            ret = true;
        } else if (!this.acceptDC && !hasDCNature) {
            ret = true;
        }
        return ret;
    }

    private String getDevConfig(IJ2eeProject prj) {
        IComp co = PortalFactory.getComp();
        if (co != null) {
            return co.getDevConfiguration(prj.getProject());
        }
        return null;
    }
}

