/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.wsproxy.plugin;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IPPEntityService;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.ICoreModelExtender;
import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.wsproxy.PRXRoot;
import com.sap.ide.metamodel.wsproxy.ProxyDefinition;
import com.sap.ide.metamodel.wsproxy.plugin.PRXRootManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class MetamodelPRXEclipse
extends Plugin
implements ICoreModelExtender {
    private static MetamodelPRXEclipse plugin;
    private static final String CONTENT_FOLDER_NAME = "content";

    public MetamodelPRXEclipse(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static MetamodelPRXEclipse getDefault() {
        return plugin;
    }

    public void postReload(Metamodel metamodel) {
    }

    public void doDCProjectInitialization(IDCExtendedProject iDCExtendedProject, Metamodel metamodel) {
        final PRXRoot root = PRXRootManager.getPRXRoot(metamodel);
        final IProject project = iDCExtendedProject.getProject();
        iDCExtendedProject.addPPEntityService(new IPPEntityService(){

            public Iterator getEntities(String aType) {
                try {
                    ArrayList<Entity> list = new ArrayList<Entity>();
                    if (aType.equals(IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT.toString()) || aType.equals(IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT.toString())) {
                        ProxyDefinition[] prxDefs = root.getProxyDefinitions();
                        int i = 0;
                        while (i < prxDefs.length) {
                            list.add(this.createEntity((DevelopmentObject)prxDefs[i]));
                            ++i;
                        }
                    }
                    return ((AbstractList)list).iterator();
                }
                catch (LoadException e) {
                    WebServiceCorePlugin.logError((Throwable)e, this.getClass());
                    return null;
                }
            }

            private Entity createEntity(DevelopmentObject developmentObject) {
                Entity entity = ComponentFactory.createEntity();
                String objectName = developmentObject.getName();
                String objectPackage = "";
                if (developmentObject.isMDO()) {
                    objectPackage = ((MainDevelopmentObject)developmentObject).getPackage();
                    objectPackage = objectPackage.replace('.', '/');
                }
                IPPModel.EntityType entityType = null;
                if (WebServiceFilterFactory.isStandaloneProxyDCProject((IProject)project)) {
                    entityType = IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT;
                } else if (WebServiceFilterFactory.isDeployableProxyDCProject((IProject)project)) {
                    entityType = IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT;
                }
                String type = entityType.toString();
                entity.setName(objectName);
                entity.setCaption(objectName);
                entity.setDescription(objectName);
                entity.setPackageName(objectPackage);
                entity.setType(type);
                return entity;
            }

            public String[] getTypes() {
                if (WebServiceFilterFactory.isStandaloneProxyDCProject((IProject)project)) {
                    return new String[]{IPPModel.EntityType.WEB_SERVICE_STANDALONE_CLIENT.toString()};
                }
                if (WebServiceFilterFactory.isDeployableProxyDCProject((IProject)project)) {
                    return new String[]{IPPModel.EntityType.WEB_SERVICE_DEPLOYABLE_CLIENT.toString()};
                }
                return new String[0];
            }
        });
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public String getContentPath() {
        return null;
    }

    public String getMetamodelName() {
        return "WSD";
    }

    public Root getRoot(Metamodel metamodel) {
        return PRXRootManager.getPRXRoot(metamodel);
    }

    public static void internalError(Class theClass, String methodName, String message, Exception exception, boolean logOnly) {
        ServicesUI.internalError((Class)theClass, (String)methodName, (String)message, (Throwable)exception, (Plugin)plugin, (boolean)logOnly);
    }

    public IMMRepositoryObjectProvider getRepositoryObjectProvider() {
        return null;
    }

    public void preMetamodelShutdown(Metamodel metamodel) {
    }
}

