/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.utils;

import com.sap.caf.rt.exception.ServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBLocalHome;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HomeFactory {
    private InitialContext context;
    private Map cache;
    private static HomeFactory factory;

    private HomeFactory() throws ServiceException {
        try {
            this.context = new InitialContext();
            this.cache = Collections.synchronizedMap(new HashMap());
        }
        catch (NamingException ne) {
            throw new ServiceException((Throwable)ne);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public static HomeFactory getInstance() {
        return factory;
    }

    public EJBLocalHome getLocalHome(String jndiHomeName) throws ServiceException {
        EJBLocalHome home = null;
        try {
            if (this.cache.containsKey(jndiHomeName)) {
                home = (EJBLocalHome)this.cache.get(jndiHomeName);
            } else {
                home = (EJBLocalHome)this.context.lookup(jndiHomeName);
                this.cache.put(jndiHomeName, home);
            }
        }
        catch (NamingException ne) {
            throw new ServiceException((Throwable)ne);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return home;
    }

    static {
        try {
            factory = new HomeFactory();
        }
        catch (ServiceException se) {
            se.printStackTrace(System.err);
        }
    }
}

