/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.extsrv;

import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.IServiceResponse;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.rt.bol.da.remote.MessageEntityConverter;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;

public class MPConnector {
    private static ICoreFactory coreFactory;
    private static IDataServiceFactory dataServiceFactory;
    private static IServicesRegistry servicesRegistry;
    private static IServiceDescriptionPersistence serviceDescriptionPersistence;
    private static IMappingService mappingService;
    private static boolean initialized;

    public static boolean initialize() {
        if (!initialized) {
            try {
                InitialContext context = new InitialContext();
                coreFactory = (ICoreFactory)context.lookup("/sap.com/com.sap.caf/CoreFactory");
                dataServiceFactory = coreFactory.getDataServiceFactory();
                servicesRegistry = dataServiceFactory.getServicesRegistry();
                serviceDescriptionPersistence = dataServiceFactory.getServiceDescriptionPersistence();
                mappingService = dataServiceFactory.getMappingService();
                initialized = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return initialized;
    }

    public static synchronized void process(String serviceId, String operationName, Object inputParam, Object outputParam, String mpType, Properties credentialProps) throws Exception {
        MPConnector.initialize();
        IServiceDefinition sd = servicesRegistry.readServiceDefinition(serviceId);
        IPorttype pt = sd.getPortType();
        IOperation op = pt.getOperation(operationName);
        IMessageValue imv = MessageEntityConverter.getInstance().createInputMessageValue(inputParam, op.getInputOperationpart().getMessage());
        Properties props = null;
        props = (Properties)sd.getOperationProperties().get(operationName);
        if (props != null) {
            credentialProps.putAll((Map<?, ?>)props);
        }
        if ((props = sd.getPortTypeProperties()) != null) {
            credentialProps.putAll((Map<?, ?>)props);
        }
        IServiceResponse sr = dataServiceFactory.executeOperation(mpType, imv, op, credentialProps, null);
        MessageEntityConverter.getInstance().retrieveMessageValue(sr.getResponseMessage(), outputParam);
    }

    static {
        initialized = false;
    }
}

