/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.topic;

import com.sap.caf.core.CoreServices;
import com.sap.caf.core.besrv.topic.Topic;
import com.sap.caf.km.ejb.svc.kmcoll.TopicHeader;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;

public class TopicServiceBean
extends EntityServiceBase
implements SessionBean {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$core$besrv$topic$TopicServiceBean == null ? (class$com$sap$caf$core$besrv$topic$TopicServiceBean = TopicServiceBean.class$("com.sap.caf.core.besrv.topic.TopicServiceBean")) : class$com$sap$caf$core$besrv$topic$TopicServiceBean));
    static /* synthetic */ Class class$com$sap$caf$core$besrv$topic$TopicServiceBean;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public Topic create(String name, String subject, String text, String discussion, String parentTopicRid) throws CAFCreateException {
        String method = "create(String name, String subject, String text, String discussion, String parentTopicRid)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object[])new Object[]{name, subject, text, discussion, parentTopicRid});
        Topic topic = new Topic();
        topic.setDiscussion(discussion);
        topic.setParentTopicRid(parentTopicRid);
        topic.setName(name);
        topic.setText(text);
        topic.setSubject(subject);
        Date changeDate = new Date();
        topic.setCreatedBy(user);
        topic.setCreatedAt(changeDate);
        topic.setLastChangedBy(user);
        topic.setLastChangedAt(changeDate);
        try {
            String topicRid = CoreServices.getCollaborationService().createTopic(discussion, parentTopicRid, name, subject, text);
            topic.setKey(topicRid);
            topic.setRid(topicRid);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object)new Object[]{topic});
        return topic;
    }

    public Topic read(String key) throws CAFRetrieveException {
        String method = "read(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object[])new Object[]{key});
        Topic topic = null;
        try {
            TopicHeader header = CoreServices.getCollaborationService().findTopic(key);
            if (header != null) {
                topic = new Topic(header);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object)new Object[]{topic});
        return topic;
    }

    public void update(Topic topic) throws CAFUpdateException {
        String method = "update(Topic)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object[])new Object[]{topic});
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
    }

    public void delete(Topic topic) throws CAFDeleteException {
        String method = "delete(Topic)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object[])new Object[]{topic});
        try {
            CoreServices.getCollaborationService().removeTopic(topic.getDiscussion(), topic.getKey());
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
            throw new CAFDeleteException((Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
    }

    public Collection findByDiscussion(String discussionId) throws CAFRetrieveException {
        String method = "findByDiscussion(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object[])new Object[]{discussionId});
        ArrayList<Topic> result = new ArrayList<Topic>();
        Topic topic = null;
        try {
            TopicHeader[] topicHeaders = CoreServices.getCollaborationService().findByDiscussion(discussionId);
            if (topicHeaders != null) {
                for (int index = 0; index < topicHeaders.length; ++index) {
                    topic = new Topic(topicHeaders[index]);
                    result.add(topic);
                }
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Topic", (String)method, (Location)location, (Object)new Object[]{topic});
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

