/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.document;

import com.sap.caf.core.besrv.document.Document;
import com.sap.caf.core.besrv.document.DocumentPK;
import com.sap.caf.km.da.DocumentDataAccessService;
import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearch;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;

public class DocumentServiceBean
extends EntityServiceBase
implements SessionBean {
    private IDataAccessService dataAccessService;
    private IIndexSearch m_indexSearch;
    protected String _objectName = "sap.com/caf.core/Document";
    private static final String APPLICATION = (class$com$sap$caf$core$besrv$document$DocumentServiceBean == null ? (class$com$sap$caf$core$besrv$document$DocumentServiceBean = DocumentServiceBean.class$("com.sap.caf.core.besrv.document.DocumentServiceBean")) : class$com$sap$caf$core$besrv$document$DocumentServiceBean).getName();
    private static final String jARMReqPrefix = "XAP:BO:";
    private static final String JARM_REQUEST = "XAP:BO:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    static /* synthetic */ Class class$com$sap$caf$core$besrv$document$DocumentServiceBean;
    static /* synthetic */ Class class$com$sap$caf$core$besrv$document$Document;

    public void ejbRemove() {
        String method = JARM_REQUEST + ":ejbRemove()";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)2);
        this.dataAccessService.destroy();
        CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)2);
    }

    public void ejbCreate() throws CreateException {
        String method = JARM_REQUEST + ":ejbCreate()";
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)0);
        try {
            this.dataAccessService = DocumentDataAccessService.getInstance();
            this.dataAccessService.activate();
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)"Error in ejbCreate()", (Throwable)e);
            throw new CreateException();
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)location, (int)0);
        }
    }

    public Document create(String kmParentFolder, String title) throws CAFCreateException {
        String method = JARM_REQUEST + ":create(String, String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{kmParentFolder, title}, (int)1);
        if (!this.checkPermission("create", null, user, "sap.com/caf.core/Document")) {
            Object[] permissionExceptionArgs = new Object[]{user, "create", null, "sap.com/caf.core/Document"};
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Document", (String)method, (Location)location);
            throw new CAFCreateException("BO_PERMISSION", permissionExceptionArgs);
        }
        Document document = new Document();
        document.setTitle(title);
        Date changeDate = new Date();
        document.setCreatedBy(user);
        document.setCreatedAt(changeDate);
        document.setLastChangedBy(user);
        document.setLastChangedAt(changeDate);
        try {
            String parentFolder = null;
            parentFolder = kmParentFolder == null || kmParentFolder.length() == 0 ? KMDataAccessHelper.getTempFolderRid() : kmParentFolder;
            document.setParentFolder(parentFolder);
            DocumentPK primaryKey = new DocumentPK(PrimaryKeyFactory.getInstance().getPrimaryKey());
            document.setKey(primaryKey.key);
            document.setDocumentId(primaryKey.key);
            document.setDescription("Created by " + this._objectName + " CAF service");
            this.dataAccessService.create((IDependentObject)document);
            Document newDoc = this.read(document.getKey());
            document.setCreatedAt(newDoc.getCreatedAt());
            document.setLastChangedAt(newDoc.getLastChangedAt());
            CAFPermission.createOwnerPermission((String)user, (String)primaryKey.key);
        }
        catch (DataAccessException e) {
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        if (CAFContext.PUBLISH_ENABLED) {
            try {
                if (this.pub == null) {
                    this.initPublishing();
                }
                this.pub.publishCreated(this.getPublishingArgs(document));
            }
            catch (BEException e) {
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFCreateException("BO_PUBLISH", (Throwable)e);
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFCreateException("BO_PUBLISH", (Throwable)e);
            }
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{document}, (int)1);
        return document;
    }

    public Document read(String key) throws CAFRetrieveException {
        Document doc;
        String method = JARM_REQUEST + ":read(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{key}, (int)1);
        DocumentPK documentPk = new DocumentPK(key);
        try {
            doc = (Document)this.dataAccessService.load((Object)documentPk, class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocumentServiceBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document);
        }
        catch (DataAccessException e) {
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        if (!this.checkPermission("read", doc, user, "sap.com/caf.core/Document")) {
            Object[] permissionExceptionArgs = new Object[]{user, "read", null, "sap.com/caf.core/Document"};
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Document", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_PERMISSION", permissionExceptionArgs);
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{doc}, (int)1);
        return doc;
    }

    public void update(Document doc) throws CAFUpdateException {
        Document oldDocument;
        String method = JARM_REQUEST + ":update(Document)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{doc}, (int)1);
        if (!this.checkPermission("update", doc, user, "sap.com/caf.core/Document")) {
            Object[] permissionExceptionArgs = new Object[]{user, "update", null, "sap.com/caf.core/Document"};
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Document", (String)method, (Location)location);
            throw new CAFUpdateException("BO_PERMISSION", permissionExceptionArgs);
        }
        try {
            oldDocument = this.read(doc.getKey());
        }
        catch (CAFRetrieveException e) {
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        Date dOldChanged = oldDocument.getLastChangedAt();
        Date dChanged = doc.getLastChangedAt();
        if (dOldChanged != null && !dOldChanged.equals(dChanged) || dOldChanged == null && dChanged != null) {
            CAFUpdateException e = new CAFUpdateException("BO_UPDATE");
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw e;
        }
        doc.setLastChangedBy(user);
        doc.setLastChangedAt(new Date());
        try {
            this.dataAccessService.store((IDependentObject)doc);
            this.reindex(doc);
        }
        catch (DataAccessException e) {
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        if (CAFContext.PUBLISH_ENABLED) {
            Object[] publArgs = null;
            try {
                if (this.pub == null) {
                    this.initPublishing();
                }
                publArgs = this.getPublishingArgs(doc);
                this.pub.publishChanged(publArgs);
            }
            catch (BEException e) {
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFUpdateException("BO_PUBLISH", (Throwable)e);
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFUpdateException("BO_PUBLISH", (Throwable)e);
            }
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
    }

    public void delete(Document doc) throws CAFDeleteException {
        String method = JARM_REQUEST + ":delete(Document)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{doc}, (int)1);
        if (!this.checkPermission("delete", doc, user, "sap.com/caf.core/Document")) {
            Object[] permissionExceptionArgs = new Object[]{user, "delete", null, "sap.com/caf.core/Document"};
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Document", (String)method, (Location)location);
            throw new CAFDeleteException("BO_PERMISSION", permissionExceptionArgs);
        }
        try {
            this.dataAccessService.remove((IDependentObject)doc);
        }
        catch (DataAccessException e) {
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFDeleteException("BO_DELETE", (Throwable)e);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
            throw new CAFDeleteException((Throwable)e);
        }
        if (CAFContext.PUBLISH_ENABLED) {
            Object[] publArgs = null;
            try {
                if (this.pub == null) {
                    this.initPublishing();
                }
                publArgs = this.getPublishingArgs(doc);
                this.pub.publishRemoved(publArgs);
            }
            catch (BEException e) {
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFDeleteException("BO_PUBLISH", (Throwable)e);
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
                throw new CAFDeleteException("BO_PUBLISH", (Throwable)e);
            }
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
    }

    public Collection findByDocumentKey(String documentKey) throws CAFFindException {
        String method = JARM_REQUEST + ":findByDocumentKey(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{documentKey}, (int)1);
        try {
            Document doc = (Document)this.dataAccessService.findByPrimaryKey((Object)new DocumentPK(documentKey), class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocumentServiceBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document);
            ArrayList<Document> list = new ArrayList<Document>(1);
            if (doc != null && this.checkPermission("read", doc, user, "sap.com/caf.core/Document")) {
                list.add(doc);
            }
            ArrayList<Document> arrayList = list;
            return arrayList;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new CAFFindException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public Collection findByTitle(String parentFolder, String title) throws CAFFindException {
        String method = JARM_REQUEST + ":findByTitle(String, String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{parentFolder, title}, (int)1);
        try {
            IntQueryFilter fParentFolder = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)parentFolder, (String)"parentFolder", (boolean)true));
            fParentFolder.setAttribute("parentFolder");
            fParentFolder.condition = "==";
            IntQueryFilter fTitle = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)title, (String)"title", (boolean)true));
            fTitle.setAttribute("title");
            fTitle.condition = "==";
            Collection resultQuery = this.dataAccessService.query(class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocumentServiceBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document, new IntQueryFilter[]{fTitle, fParentFolder}, null);
            Collection collection = this.checkPermissions(resultQuery, "create", user, "sap.com/caf.core/Document");
            return collection;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new CAFFindException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public Collection findByDocumentId(String parentFolder, String documentId) throws CAFFindException {
        String method = JARM_REQUEST + ":findByDocumentId(String, String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{parentFolder, documentId}, (int)1);
        try {
            IntQueryFilter fParentFolder = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)parentFolder, (String)"parentFolder", (boolean)true));
            fParentFolder.setAttribute("parentFolder");
            fParentFolder.condition = "==";
            IntQueryFilter fDocumentId = new IntQueryFilter(QueryFilter.createStringFilter((String)"exact", (String)documentId, (String)"documentId", (boolean)true));
            fDocumentId.setAttribute("documentId");
            fDocumentId.condition = "==";
            Collection result = this.dataAccessService.query(class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocumentServiceBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document, new IntQueryFilter[]{fDocumentId, fParentFolder}, null);
            Collection collection = this.checkPermissions(result, "create", user, "sap.com/caf.core/Document");
            return collection;
        }
        catch (Exception ex) {
            location.throwing((Throwable)ex);
            throw new CAFFindException((Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public Collection findByRid(String rid) throws CAFFindException {
        String method = JARM_REQUEST + ":findByRid(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            Collection collection = this.findByDocumentId(RidUtils.getPath((String)rid), RidUtils.getName((String)rid));
            return collection;
        }
        catch (CAFFindException ex) {
            location.throwing(method, (Throwable)ex);
            throw ex;
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    private boolean checkPermission(String permission, IBusinessObject object, String user, String objectName) {
        try {
            if (!CAFPermission.checkAclPermission((Object)object, (String)user, (String)permission, (String)objectName)) {
                return false;
            }
        }
        catch (CAFPermissionException e) {
            return false;
        }
        return true;
    }

    private Collection checkPermissions(Collection objectList, String permission, String user, String objectName) {
        ArrayList<IBusinessObject> filteredResult = new ArrayList<IBusinessObject>();
        Iterator i = objectList.iterator();
        while (i.hasNext()) {
            IBusinessObject doc = (IBusinessObject)i.next();
            if (!this.checkPermission(permission, doc, user, "sap.com/caf.core/Document")) continue;
            filteredResult.add(doc);
        }
        return filteredResult;
    }

    private void reindex(Document doc) throws Exception {
        InitialContext context = new InitialContext();
        if (this.m_indexSearch == null) {
            String INDEX_SEARCH_JNDI_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/IndexSearchBean";
            Object obj = context.lookup(INDEX_SEARCH_JNDI_NAME);
            IndexSearchLocalHome home = (IndexSearchLocalHome)obj;
            this.m_indexSearch = home.create();
        }
        String relRid = doc.getRid();
        Collection col = doc.getRelatedObjectRids();
        if (!col.isEmpty()) {
            Object oBOName = col.iterator().next();
            String sBOName = (String)oBOName;
            StringTokenizer st = new StringTokenizer(sBOName, "/");
            st.nextToken();
            sBOName = st.nextToken();
            MetaModel mm = new MetaModel();
            DataObject dobj = mm.getDataObjectByGUID(sBOName);
            Application app = dobj.getBusinessEntityInterface().getApplication();
            sBOName = app.getProviderName() + '/' + app.getObjectName() + '/' + dobj.getObjectName();
            this.m_indexSearch.indexRelatedObject(sBOName, relRid);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

