/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.discussionroom;

import com.sap.caf.core.CoreServices;
import com.sap.caf.core.besrv.discussionroom.DiscussionRoom;
import com.sap.caf.km.ejb.svc.kmcoll.RoomHeader;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;

public class DiscussionRoomServiceBean
extends EntityServiceBase
implements SessionBean {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$core$besrv$discussionroom$DiscussionRoomServiceBean == null ? (class$com$sap$caf$core$besrv$discussionroom$DiscussionRoomServiceBean = DiscussionRoomServiceBean.class$("com.sap.caf.core.besrv.discussionroom.DiscussionRoomServiceBean")) : class$com$sap$caf$core$besrv$discussionroom$DiscussionRoomServiceBean));
    static /* synthetic */ Class class$com$sap$caf$core$besrv$discussionroom$DiscussionRoomServiceBean;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public DiscussionRoom create(String name, String description, Collection team, String relatedObjectRid) throws CAFCreateException {
        String method = "create(String name, String description, Collection team)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object[])new Object[]{name, description, team});
        DiscussionRoom discussionRoom = null;
        try {
            RoomHeader header = CoreServices.getCollaborationService().createDiscussionRoom(name, description, team, relatedObjectRid);
            discussionRoom = new DiscussionRoom(header);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object)new Object[]{discussionRoom});
        return discussionRoom;
    }

    public DiscussionRoom read(String key) throws CAFRetrieveException {
        String method = "read(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object[])new Object[]{key});
        DiscussionRoom room = null;
        try {
            RoomHeader header = CoreServices.getCollaborationService().findDiscussionRoom(key);
            if (header != null) {
                room = new DiscussionRoom(header);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object)new Object[]{room});
        return room;
    }

    public void update(DiscussionRoom room) throws CAFUpdateException {
        String method = "update(DiscussionRoom)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object[])new Object[]{room});
        try {
            CoreServices.getCollaborationService().updateDiscussionRoom(room.getKey(), room.getName(), room.getDescription(), room.getRelatedObjectRid());
            CoreServices.getCollaborationService().assignUsers(room.getKey(), (Collection)room.getTeam());
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
    }

    public void delete(DiscussionRoom room) throws CAFDeleteException {
        String method = "delete(DiscussionRoom)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object[])new Object[]{room});
        try {
            CoreServices.getCollaborationService().deleteDiscussionRoom(room.getKey());
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
            throw new CAFDeleteException((Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
    }

    public DiscussionRoom findByDiscussionRoomForDashboard(String key) throws CAFRetrieveException {
        String method = "findByDiscussionRoomForDashboard(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object[])new Object[]{key});
        DiscussionRoom room = null;
        try {
            RoomHeader header = CoreServices.getCollaborationService().findRoomWithTodayPosts(key);
            if (header != null) {
                room = new DiscussionRoom(header);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.DiscussionRoom", (String)method, (Location)location, (Object)new Object[]{room});
        return room;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

