/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.discussion;

import com.sap.caf.core.CoreServices;
import com.sap.caf.core.besrv.discussion.Discussion;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;

public class DiscussionServiceBean
extends EntityServiceBase
implements SessionBean {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$core$besrv$discussion$DiscussionServiceBean == null ? (class$com$sap$caf$core$besrv$discussion$DiscussionServiceBean = DiscussionServiceBean.class$("com.sap.caf.core.besrv.discussion.DiscussionServiceBean")) : class$com$sap$caf$core$besrv$discussion$DiscussionServiceBean));
    static /* synthetic */ Class class$com$sap$caf$core$besrv$discussion$DiscussionServiceBean;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public Discussion create(String documentId, String parentFolder) throws CAFCreateException {
        String method = "create(String documentId, String parentFolder)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object[])new Object[]{documentId, parentFolder});
        Discussion discussion = new Discussion();
        discussion.setParentFolder(parentFolder);
        discussion.setDocumentId(documentId);
        Date changeDate = new Date();
        discussion.setCreatedBy(user);
        discussion.setCreatedAt(changeDate);
        discussion.setLastChangedBy(user);
        discussion.setLastChangedAt(changeDate);
        try {
            String discussionRid = CoreServices.getCollaborationService().createDiscussion(documentId, parentFolder, documentId);
            discussion.setKey(discussionRid);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object)new Object[]{discussion});
        return discussion;
    }

    public Discussion read(String key) throws CAFRetrieveException {
        String method = "read(String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object[])new Object[]{key});
        Discussion discussion = null;
        try {
            DiscussionHeader header = CoreServices.getCollaborationService().findDiscussion(key);
            if (header != null) {
                discussion = new Discussion(header);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object)new Object[]{discussion});
        return discussion;
    }

    public void update(Discussion discussion) throws CAFUpdateException {
        String method = "update(Discussion)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object[])new Object[]{discussion});
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location);
    }

    public void delete(Discussion discussion) throws CAFDeleteException {
        String method = "delete(Discussion)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location, (Object[])new Object[]{discussion});
        try {
            CoreServices.getCollaborationService().deleteDiscussion(discussion.getKey());
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
            location.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location);
            throw new CAFDeleteException((Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:SRV:com.sap.caf.core.services.Discussion", (String)method, (Location)location);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

