/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.currency;

import com.sap.caf.core.besrv.currency.Currency;
import com.sap.caf.core.besrv.currency.CurrencyPK;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedEvent;
import com.sap.caf.rt.services.notify.notif.bobject.IBOChangedEvent;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.jdo.spi.PersistenceCapable;

public class CurrencyServiceBean
extends EntityServiceBase
implements SessionBean {
    private IDataAccessService dataAccessService;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$caf$core$besrv$currency$CurrencyServiceBean == null ? (class$com$sap$caf$core$besrv$currency$CurrencyServiceBean = CurrencyServiceBean.class$("com.sap.caf.core.besrv.currency.CurrencyServiceBean")) : class$com$sap$caf$core$besrv$currency$CurrencyServiceBean));
    static /* synthetic */ Class class$com$sap$caf$core$besrv$currency$CurrencyServiceBean;
    static /* synthetic */ Class class$com$sap$caf$core$besrv$currency$Currency;

    public void ejbRemove() {
        String method = "XAP:BO:sap.com/caf.core/Currency:ejbRemove()";
        CAFPublicLogger.entering(null, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        this.dataAccessService.destroy();
        CAFPublicLogger.exiting(null, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
    }

    public void ejbCreate() throws CreateException {
        this._objectName = "sap.com/caf.core/Currency";
        String method = "ejbCreate()";
        CAFPublicLogger.entering(null, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        try {
            this.dataAccessService = DataAccessFactory.getDataAccessService((int)DataAccessFactory.DATASOURCE_LOCAL);
            this.dataAccessService.activate();
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)"Error in ejbCreate()", (Throwable)e);
            throw new CreateException();
        }
        finally {
            CAFPublicLogger.exiting(null, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        }
    }

    public Currency create() throws CAFCreateException {
        String method = "XAP:BO:sap.com/caf.core/Currency:create()";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object[])new Object[0], (int)1);
        Currency be = new Currency();
        try {
            BOChangedEvent event = new BOChangedEvent((IDependentObject)be, BOSubscrType.CREATED);
            be.setNotifEvent((IBOChangedEvent)event);
            Date time = new Date();
            be.setCreatedBy(user);
            be.setCreatedAt(time);
            be.setLastChangedBy(user);
            be.setLastChangedAt(time);
            CurrencyPK primaryKey = new CurrencyPK(PrimaryKeyFactory.getInstance().getPrimaryKey());
            be.setKey(primaryKey.key);
            this.dataAccessService.create((IDependentObject)be);
        }
        catch (CAFBaseException e) {
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFCreateException("BO_CREATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object)new Object[]{be}, (int)1);
        return be;
    }

    public Currency read(String key) throws CAFRetrieveException {
        Currency be;
        String method = "XAP:BO:sap.com/caf.core/Currency:read(java.lang.String)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object[])new Object[]{key}, (int)1);
        CurrencyPK primaryKey = new CurrencyPK(key);
        try {
            be = (Currency)this.dataAccessService.load((Object)primaryKey, class$com$sap$caf$core$besrv$currency$Currency == null ? (class$com$sap$caf$core$besrv$currency$Currency = CurrencyServiceBean.class$("com.sap.caf.core.besrv.currency.Currency")) : class$com$sap$caf$core$besrv$currency$Currency);
            BOChangedEvent event = new BOChangedEvent((IDependentObject)be, BOSubscrType.UPDATED);
            be.setNotifEvent((IBOChangedEvent)event);
        }
        catch (DataAccessException e) {
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFRetrieveException("BO_READ", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object)new Object[]{be}, (int)1);
        return be;
    }

    public void update(Currency be) throws CAFUpdateException {
        String method = "XAP:BO:sap.com/caf.core/Currency:update(Currency)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object[])new Object[]{be}, (int)1);
        String prevLastChangedBy = be.getLastChangedBy();
        Date prevLastChangedAt = be.getLastChangedAt();
        Date now = new Date();
        Currency beForUpdate = be;
        boolean locking = true;
        if (be instanceof PersistenceCapable && ((PersistenceCapable)be).jdoIsPersistent()) {
            locking = false;
        }
        if (locking) {
            Currency oldBE;
            try {
                oldBE = this.read(be.getKey());
            }
            catch (CAFRetrieveException e) {
                LOCATION.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
                throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
                LOCATION.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
                throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
            }
            if (!oldBE.getLastChangedAt().equals(be.getLastChangedAt())) {
                CAFUpdateException e = new CAFUpdateException("BO_UPDATE");
                CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
                LOCATION.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
                throw e;
            }
            try {
                oldBE.copyContentFrom(be);
            }
            catch (CAFBaseException e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
                LOCATION.throwing(method, (Throwable)e);
                CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
                throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
            }
            oldBE.setLastChangedBy(user);
            oldBE.setLastChangedAt(now);
            beForUpdate = oldBE;
        }
        be.setLastChangedBy(user);
        be.setLastChangedAt(now);
        try {
            this.dataAccessService.store((IDependentObject)beForUpdate);
            this.notifyChanged(beForUpdate.getNotifEvent());
        }
        catch (DataAccessException e) {
            be.setLastChangedBy(prevLastChangedBy);
            be.setLastChangedAt(prevLastChangedAt);
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            be.setLastChangedBy(prevLastChangedBy);
            be.setLastChangedAt(prevLastChangedAt);
            CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFUpdateException("BO_UPDATE", (Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
    }

    public void delete(Currency be) throws CAFDeleteException {
        String method = "XAP:BO:sap.com/caf.core/Currency:delete(Currency)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object[])new Object[]{be}, (int)1);
        try {
            IBOChangedEvent event = be.getNotifEvent();
            this.dataAccessService.remove((IDependentObject)be);
            this.notifyChanged(event);
        }
        catch (DataAccessException e) {
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFDeleteException("BO_DELETE", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)LOCATION, (String)method, (String)("Error in " + method), (Throwable)e);
            LOCATION.throwing(method, (Throwable)e);
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
            throw new CAFDeleteException((Throwable)e);
        }
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
    }

    public ArrayList getAllCurrencies() throws CAFFindException {
        String method = "XAP:BO:sap.com/caf.core/Currency:getAllCurrencies()";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        HashMap queriesMap = new HashMap();
        ArrayList result = this.findByMultipleParameters(queriesMap, false, "getAllCurrencies");
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        return result;
    }

    public ArrayList findByCyrrencyCode(QueryFilter currencyCodeFilter) throws CAFFindException {
        String method = "XAP:BO:sap.com/caf.core/Currency:findByCyrrencyCode(QueryFilter)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        HashMap<String, QueryFilter> queriesMap = new HashMap<String, QueryFilter>();
        queriesMap.put("currencyCode", currencyCodeFilter);
        ArrayList result = this.findByMultipleParameters(queriesMap, false, "findByCyrrencyCode");
        CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        return result;
    }

    public ArrayList findByMultipleParameters(Map mapNameToFilter, boolean implCheck, String findByName) throws CAFFindException {
        String method = "XAP:BO:sap.com/caf.core/Currency:findByMultipleParameters(Map)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (Object[])new Object[]{mapNameToFilter}, (int)1);
        ArrayList<Currency> result = new ArrayList<Currency>();
        Set inputSet = mapNameToFilter.entrySet();
        Iterator it = inputSet.iterator();
        int nSize = inputSet.size();
        Object[] objAttribs = new Object[nSize];
        String strInputParams = "input params : ";
        ArrayList resultQueries = new ArrayList(nSize);
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String strParamName = (String)entry.getKey();
            Object oValue = entry.getValue();
            resultQueries.addAll(this.extractQueryFilters(strParamName, oValue));
            strInputParams = strInputParams + (0 != i ? ", " : "") + strParamName + "={" + i + "}";
            objAttribs[i] = oValue;
            ++i;
        }
        CAFPublicLogger.LOC_CAF.debugT(strInputParams, objAttribs);
        try {
            Collection resultSet = this.dataAccessService.query(class$com$sap$caf$core$besrv$currency$Currency == null ? (class$com$sap$caf$core$besrv$currency$Currency = CurrencyServiceBean.class$("com.sap.caf.core.besrv.currency.Currency")) : class$com$sap$caf$core$besrv$currency$Currency, resultQueries.toArray(new IntQueryFilter[0]), findByName);
            Date time = new Date();
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                Currency bo = (Currency)iter.next();
                if (bo.getCreatedBy() == null) {
                    bo.setCreatedBy(user);
                }
                if (bo.getCreatedAt() == null) {
                    bo.setCreatedAt(time);
                }
                if (bo.getLastChangedBy() == null) {
                    bo.setLastChangedBy(user);
                }
                if (bo.getLastChangedAt() == null) {
                    bo.setLastChangedAt(time);
                }
                if (implCheck && !this.checkPermission("read", bo, user, "sap.com/caf.core/Currency")) continue;
                result.add(bo);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOCATION.throwing(method, (Throwable)e);
            throw new CAFFindException("BO_FIND", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)"XAP:BO:sap.com/caf.core/Currency", (String)method, (Location)LOCATION, (int)1);
        }
        return result;
    }

    protected Collection extractQueryFilters(String strParamName, Object oValue) throws CAFFindException {
        ArrayList<IntQueryFilter> resCollection = new ArrayList<IntQueryFilter>();
        if (oValue instanceof Collection) {
            int colSize = ((Collection)oValue).size();
            Iterator iter = ((Collection)oValue).iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                Iterator i = this.extractIntQueryFilter(strParamName, value).iterator();
                while (i.hasNext()) {
                    IntQueryFilter qf = (IntQueryFilter)i.next();
                    if (colSize > 1) {
                        if (resCollection.size() == 0) {
                            qf.setInStatementCondition(1);
                        } else if (!iter.hasNext()) {
                            qf.setInStatementCondition(2);
                        } else {
                            qf.setInStatementCondition(3);
                        }
                    }
                    resCollection.add(qf);
                }
            }
        } else if (oValue instanceof Map) {
            int mapSize = ((Map)oValue).size();
            Iterator iter = ((Map)oValue).keySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = (Map.Entry)iter.next();
                Iterator i = this.extractIntQueryFilter((String)me.getKey(), me.getValue()).iterator();
                while (i.hasNext()) {
                    IntQueryFilter qf = (IntQueryFilter)i.next();
                    if (mapSize > 1) {
                        if (resCollection.size() == 0) {
                            qf.setInStatementCondition(1);
                        } else if (!iter.hasNext()) {
                            qf.setInStatementCondition(2);
                        } else {
                            qf.setInStatementCondition(3);
                        }
                    }
                    resCollection.add(qf);
                }
            }
        } else {
            resCollection.addAll(this.extractIntQueryFilter(strParamName, oValue));
        }
        return resCollection;
    }

    protected Collection extractIntQueryFilter(String strParamName, Object oValue) throws CAFFindException {
        IntQueryFilter resQueryFilter = null;
        ArrayList<Object> resCollection = new ArrayList<Object>();
        QueryFilter qf = QueryFilter.getQueryFilter((Object)oValue);
        if (qf == null) {
            throw new CAFFindException("filter is not valid");
        }
        if (qf instanceof IntQueryFilter) {
            resCollection.add(qf);
        } else if (qf instanceof QueryFilter) {
            int dotIndex = strParamName.indexOf(46);
            String attrName = dotIndex == -1 ? strParamName : strParamName.substring(0, dotIndex);
            String subAttrName = dotIndex == -1 ? null : strParamName.substring(dotIndex + 1, strParamName.length());
            resQueryFilter = new IntQueryFilter(qf);
            resQueryFilter.setAttribute(strParamName);
            resCollection.add(resQueryFilter);
        }
        return resCollection;
    }

    private boolean checkPermission(String permission, IBusinessObject object, String user, String objectName) {
        boolean allowAccess = true;
        try {
            if (!CAFPermission.checkAclPermission((Object)object, (String)user, (String)permission, (String)objectName)) {
                allowAccess = false;
            }
        }
        catch (CAFPermissionException e) {
            allowAccess = false;
        }
        return allowAccess;
    }

    private void notifyChanged(IBOChangedEvent notifEvent) throws NotifException {
        if (this.notifPub == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not send a notification: notification publisher is NULL");
            }
            return;
        }
        if (notifEvent == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not send a notification: notification event is NULL");
            }
            return;
        }
        this.notifPub.notify((INotifEvent)notifEvent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

