/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.service.creation;

import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ext.ModelPlugin;
import com.tssap.j2ee.model.service.IJ2EEServiceProject;
import com.tssap.j2ee.service.creation.IJ2EEServiceProjectCreation;
import com.tssap.j2ee.ui.creation.internal.AbstractJ2eeJavaProjectCreation;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.ui.wizard.J2eeProjectJavaPage;
import com.tssap.j2ee.util.core.CompConstants;
import com.tssap.j2ee.util.file.FileUtil;
import com.tssap.j2ee.util.jdt.JDTClasspathUtil;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class J2EEServiceProjectCreation
extends AbstractJ2eeJavaProjectCreation
implements IJ2EEServiceProjectCreation {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$service$creation$J2EEServiceProjectCreation == null ? (class$com$tssap$j2ee$service$creation$J2EEServiceProjectCreation = J2EEServiceProjectCreation.class$("com.tssap.j2ee.service.creation.J2EEServiceProjectCreation")) : class$com$tssap$j2ee$service$creation$J2EEServiceProjectCreation));
    private static final String PLACEHOLDER_COMPONENT_NAME = "$COMPONENT_NAME$";
    private static final String PLACEHOLDER_SOFTWARE_TYPE = "$SOFTWARE_TYPE$";
    private static final String DEFAULT_SOFTWARE_TYPE = "primary-service";
    static /* synthetic */ Class class$com$tssap$j2ee$service$creation$J2EEServiceProjectCreation;

    protected void doCreateProject(IProgressMonitor monitor) throws CoreException, J2eeCreateException, InvocationTargetException, InterruptedException {
        String METHOD = "doCreateProject()";
        try {
            monitor.beginTask("Project creation ... ", 6);
            IRunnableWithProgress jr = this.getJavaRunnable();
            if (jr == null) {
                jr = new J2eeProjectJavaPage(this.getNewProject(), this.getLocation()).getRunnable();
            }
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(jr);
            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProject projectHandle = this.getNewProject();
            if (!projectHandle.isOpen()) {
                projectHandle.open(null);
            }
            ProjectUtil.updateProjectNatures((IProject)projectHandle, (String)"com.tssap.j2ee.service.serviceNature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JDTClasspathUtil.removeSourceFolderEntries((IProject)this.getNewProject());
            IJ2EEServiceProject serviceProject = J2eeProjectManager.getServiceProject((String)this.getNewProject().getName());
            if (serviceProject == null) {
                TRACER.error(METHOD, "New service-project not found in model");
                throw new J2eeCreateException();
            }
            IFile file = serviceProject.getProject().getFile("server/service-provider.xml");
            String[] p = new String[]{PLACEHOLDER_COMPONENT_NAME};
            String[] pv = new String[]{serviceProject.getProject().getName()};
            FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/server/service-provider.xml", (IFile)file, (String[])p, (String[])pv);
            file = serviceProject.getProject().getFile("server/runtime.properties");
            p = new String[]{PLACEHOLDER_COMPONENT_NAME};
            pv = new String[]{serviceProject.getProject().getName()};
            FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/server/runtime.properties", (IFile)file, (String[])p, (String[])pv);
            file = serviceProject.getProject().getFile("server/properties");
            p = new String[]{PLACEHOLDER_COMPONENT_NAME};
            pv = new String[]{serviceProject.getProject().getName()};
            FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/server/properties", (IFile)file, (String[])p, (String[])pv);
            file = serviceProject.getProject().getFile("META-INF/sda-dd.xml");
            p = new String[]{PLACEHOLDER_SOFTWARE_TYPE};
            pv = new String[]{DEFAULT_SOFTWARE_TYPE};
            FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/META-INF/sda-dd.xml", (IFile)file, (String[])p, (String[])pv);
            monitor.worked(1);
            if (this.getCompWizard() != null) {
                this.setArchiveInfo((IRepresentArchive)serviceProject, "sda", CompConstants.getDcLocationLibrary((String)this.getCompWizard().getBuildVariant()));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected Properties getComponentProperties() {
        Properties p = new Properties();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new String[]{"defServ", "compilation", "", ""});
        ((Hashtable)p).put("DCPublicParts", list);
        String archiveName = CompUtil.getCompArchiveName((String)this.getCompWizard().getName(), (String)this.getCompWizard().getVendor());
        list = new ArrayList();
        list.add(new String[]{"defServ", archiveName, "SERVER_COMPONENTS"});
        ((Hashtable)p).put("DCPublicPartEntity", list);
        list = new ArrayList();
        list.add("META-INF");
        list.add("server");
        list.add("dispatcher");
        ((Hashtable)p).put("DCSourceFolder", list);
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

