/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.transformation;

import com.sap.aii.upload.transformation.ClassicTransformation;
import com.sap.aii.upload.transformation.ClassicTransformationXSD;
import com.sap.aii.upload.transformation.Common;
import com.sap.aii.upload.transformation.DateTime;
import com.sap.aii.upload.transformation.InvalidDocumentException;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.TransformationConstants;
import com.sap.aii.util.xml.api.TransformationServices;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RFC2XSD
extends ClassicTransformationXSD {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$transformation$RFC2XSD == null ? (class$com$sap$aii$upload$transformation$RFC2XSD = RFC2XSD.class$("com.sap.aii.upload.transformation.RFC2XSD")) : class$com$sap$aii$upload$transformation$RFC2XSD).getName());
    private List rfcContainerList = new Vector();
    private List rfcnameList = new Vector();
    private List parameterList = new Vector();
    private List exceptionList = new Vector();
    private List requestParamList = new Vector();
    private List responseParamList = new Vector();
    private List commonParamList = new Vector();
    private List linkedTypesContainer = new Vector();
    private List linkedTypesName = new Vector();
    private Hashtable tableTypes = new Hashtable();
    private List structureTypes = new Vector();
    private DateTime dt = new DateTime();
    private List exceptionExistList = new Vector();
    static /* synthetic */ Class class$com$sap$aii$upload$transformation$RFC2XSD;

    private void init() throws InvalidDocumentException {
        XElement list = this.inputdoc.getRoot();
        if (list == null) {
            throw new InvalidDocumentException("<list>", 1);
        }
        XElement std = Common.getSubElement(list, "storedData", TransformationConstants.cpns);
        Common.handleRFCPart(std, this.rfcContainerList, this.rfcnameList, this.parameterList, this.exceptionList, this.requestParamList, this.responseParamList, this.commonParamList, this.exceptionExistList, this.part == 3 ? 1 : 2);
        XElement links = Common.getSubElement(list, "links", XDOMFactory.NO_NAMESPACE);
        XElement[] cpStoredDataList = links.getSubElements("storedData", "urn:sap-com:ifr:cp");
        int i = 0;
        while (i < cpStoredDataList.length) {
            XElement cpStoredData = cpStoredDataList[i];
            XElement cpId = Common.getSubElement(cpStoredData, "id", TransformationConstants.cpns);
            String type = Common.getSubElementTextTrim(cpId, "type", TransformationConstants.cpns);
            if (type.equals("rfc")) {
                Common.handleRFCPart(cpStoredData, this.rfcContainerList, this.rfcnameList, this.parameterList, this.exceptionList, this.requestParamList, this.responseParamList, this.commonParamList, this.exceptionExistList, this.part == 3 ? 1 : 2);
            } else if (type.equals("type")) {
                XElement data = Common.getSubElement(cpStoredData, "data", TransformationConstants.cpns);
                XElement container = Common.getSubElement(data, "container", TransformationConstants.ifrns);
                XElement properties = Common.getSubElement(container, "properties", TransformationConstants.ifrns);
                String category = Common.getSubElementTextTrim(properties, "category", TransformationConstants.ifrns);
                if (category.compareTo("structure") == 0) {
                    this.structureTypes.add(cpStoredData);
                } else {
                    String name = Common.getSubElementTextTrim(cpId, "name", TransformationConstants.cpns);
                    String key = type + name;
                    this.tableTypes.put(key, cpStoredData);
                }
            }
            ++i;
        }
    }

    void transform2001(XDocument doc) throws InvalidDocumentException {
        this.inputdoc = doc;
        this.init();
        XElement resultRoot = this.getTypes();
        this.resultdoc = ClassicTransformation.f.newXDocument().setRoot(resultRoot);
    }

    private XElement getTypes() throws InvalidDocumentException {
        XElement schema = TransformationServices.getSchema((String)"urn:sap-com:document:sap:rfc:functions");
        schema.add(Common.rfcns);
        if (this.part == 3) {
            int pos = 0;
            while (pos < this.rfcnameList.size()) {
                String rfcname = (String)this.rfcnameList.get(pos);
                if (((Boolean)this.exceptionExistList.get(pos)).booleanValue()) {
                    schema.add(Common.getExceptionsXElement((List)this.exceptionList.get(pos), (String)this.rfcnameList.get(pos)));
                }
                ++pos;
            }
        } else {
            int pos = 0;
            while (pos < this.rfcnameList.size()) {
                String rfcname = (String)this.rfcnameList.get(pos);
                XElement commonComplexType = Common.getCommonComplexTypeParameterList(pos, this.commonParamList, this.tableTypes, this.dt, this.language);
                if (this.part == 2) {
                    XElement responseElem = TransformationServices.getElement((String)(rfcname + ".Response"));
                    XElement responseAll = commonComplexType.getSubElement("all", "http://www.w3.org/2001/XMLSchema");
                    List responseParam = (List)this.responseParamList.get(pos);
                    int i = 0;
                    while (i < responseParam.size()) {
                        XElement param = (XElement)responseParam.get(i);
                        responseAll.add(Common.getElementForType(param, "parameter", this.tableTypes, this.dt, this.language));
                        ++i;
                    }
                    responseElem.add(commonComplexType);
                    schema.add(responseElem);
                } else {
                    XElement requestElem = TransformationServices.getElement((String)rfcname);
                    XElement requestComplexType = (XElement)commonComplexType.clone();
                    XElement requestAll = requestComplexType.getSubElement("all", "http://www.w3.org/2001/XMLSchema");
                    List requestParam = (List)this.requestParamList.get(pos);
                    int i = 0;
                    while (i < requestParam.size()) {
                        XElement param = (XElement)requestParam.get(i);
                        requestAll.add(Common.getElementForType(param, "parameter", this.tableTypes, this.dt, this.language));
                        ++i;
                    }
                    requestElem.add(requestComplexType);
                    schema.add(requestElem);
                }
                ++pos;
            }
            Common.addDDICStructureTypes(schema, this.structureTypes, this.tableTypes, this.dt, this.language);
            Common.addDateTimeTypes(schema, this.dt.dateTypeExists(), this.dt.timeTypeExists(), "s0");
        }
        return schema;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

