/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.transformation;

import com.sap.aii.upload.transformation.ClassicTransformation;
import com.sap.aii.upload.transformation.ClassicTransformationWSDL;
import com.sap.aii.upload.transformation.Common;
import com.sap.aii.upload.transformation.DateTime;
import com.sap.aii.upload.transformation.InvalidDocumentException;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.TransformationConstants;
import com.sap.aii.util.xml.api.TransformationServices;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RFC2WSDL
extends ClassicTransformationWSDL {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$transformation$RFC2WSDL == null ? (class$com$sap$aii$upload$transformation$RFC2WSDL = RFC2WSDL.class$("com.sap.aii.upload.transformation.RFC2WSDL")) : class$com$sap$aii$upload$transformation$RFC2WSDL).getName());
    private List rfcContainerList = new Vector();
    private List rfcnameList = new Vector();
    private List parameterList = new Vector();
    private List exceptionList = new Vector();
    private List requestParamList = new Vector();
    private List responseParamList = new Vector();
    private List commonParamList = new Vector();
    private List linkedTypesContainer = new Vector();
    private List linkedTypesName = new Vector();
    private Hashtable tableTypes = new Hashtable();
    private List structureTypes = new Vector();
    private DateTime dt = new DateTime();
    private List exceptionExistList = new Vector();
    private boolean multiRFC = false;
    static /* synthetic */ Class class$com$sap$aii$upload$transformation$RFC2WSDL;

    private void init() throws InvalidDocumentException {
        XElement list = this.inputdoc.getRoot();
        if (list == null) {
            throw new InvalidDocumentException("<list>", 1);
        }
        XElement std = list.getSubElement("storedData", "urn:sap-com:ifr:cp");
        if (std != null) {
            this.multiRFC = false;
            Common.handleRFCPart(std, this.rfcContainerList, this.rfcnameList, this.parameterList, this.exceptionList, this.requestParamList, this.responseParamList, this.commonParamList, this.exceptionExistList, 0);
        } else {
            this.multiRFC = true;
        }
        XElement links = Common.getSubElement(list, "links", XDOMFactory.NO_NAMESPACE);
        XElement[] cpStoredDataList = links.getSubElements("storedData", "urn:sap-com:ifr:cp");
        int i = 0;
        while (i < cpStoredDataList.length) {
            XElement cpStoredData = cpStoredDataList[i];
            XElement cpId = Common.getSubElement(cpStoredData, "id", TransformationConstants.cpns);
            String type = Common.getSubElementTextTrim(cpId, "type", TransformationConstants.cpns);
            if (type.equals("rfc")) {
                Common.handleRFCPart(cpStoredData, this.rfcContainerList, this.rfcnameList, this.parameterList, this.exceptionList, this.requestParamList, this.responseParamList, this.commonParamList, this.exceptionExistList, 0);
            } else if (type.equals("type")) {
                String name;
                XElement data = Common.getSubElement(cpStoredData, "data", TransformationConstants.cpns);
                XElement container = Common.getSubElement(data, "container", TransformationConstants.ifrns);
                XElement properties = Common.getSubElement(container, "properties", TransformationConstants.ifrns);
                String category = Common.getSubElementTextTrim(properties, "category", TransformationConstants.ifrns);
                if (category.compareTo("structure") == 0) {
                    this.structureTypes.add(cpStoredData);
                } else {
                    name = Common.getSubElementTextTrim(cpId, "name", TransformationConstants.cpns);
                    String key = type + name;
                    this.tableTypes.put(key, cpStoredData);
                }
                if (this.addSAPBinding) {
                    name = Common.getSubElementTextTrim(cpId, "name", TransformationConstants.cpns);
                    this.linkedTypesName.add(name);
                    this.linkedTypesContainer.add(container);
                }
            }
            ++i;
        }
        if (!this.multiRFC && this.porttypeName == null) {
            this.porttypeName = (String)this.rfcnameList.get(0);
        }
    }

    private XElement getBindingSOAP() {
        String[] operations = new String[this.rfcnameList.size()];
        int[] inputOutputFault = new int[this.rfcnameList.size()];
        String[][] faultNames = new String[this.rfcnameList.size()][1];
        int i = 0;
        while (i < this.rfcnameList.size()) {
            operations[i] = (String)this.rfcnameList.get(i);
            if (((Boolean)this.exceptionExistList.get(i)).booleanValue()) {
                faultNames[i][0] = operations[i] + ".Exception";
                inputOutputFault[i] = 3;
            } else {
                inputOutputFault[i] = 0;
            }
            ++i;
        }
        return TransformationServices.getWSDLBindingPart((String)this.porttypeName, (String)"s0", (String)(this.porttypeName + "." + "PortType"), (String[])operations, (int[])inputOutputFault, (String[][])faultNames);
    }

    void transform2001(XDocument doc) throws InvalidDocumentException {
        this.inputdoc = doc;
        this.init();
        XElement resultRoot = TransformationServices.getWSDLDefinitions((String)"urn:sap-com:document:sap:rfc:functions");
        resultRoot.add(Common.rfcns);
        resultRoot.add(this.getTypes());
        int i = 0;
        while (i < this.rfcnameList.size()) {
            String name = (String)this.rfcnameList.get(i);
            resultRoot.add(this.getMessageXElement(name, "Input", ""));
            resultRoot.add(this.getMessageXElement(name, "Output", ".Response"));
            if (((Boolean)this.exceptionExistList.get(i)).booleanValue()) {
                resultRoot.add(this.getMessageXElement(name, "Exception", ".Exception"));
            }
            ++i;
        }
        resultRoot.add(this.getPortType());
        if (this.addSAPBinding) {
            resultRoot.add(this.getBindingRFC());
        }
        if (this.soapLocation != null) {
            resultRoot.add(this.getBindingSOAP());
            resultRoot.add(TransformationServices.getServicePart((String)this.bsname, (String)this.soapLocation, (String)this.fnamespace, (String)this.fname, (String)this.porttypeName, (String)"", (String)"s0"));
        }
        this.resultdoc = ClassicTransformation.f.newXDocument().setRoot(resultRoot);
    }

    private XElement getTypes() throws InvalidDocumentException {
        XElement types = TransformationServices.getWSDLTypes();
        XElement schema = TransformationServices.getSchema((String)"urn:sap-com:document:sap:rfc:functions");
        schema.add(Common.rfcns);
        types.add(schema);
        int pos = 0;
        while (pos < this.rfcnameList.size()) {
            String rfcname = (String)this.rfcnameList.get(pos);
            XElement commonComplexType = Common.getCommonComplexTypeParameterList(pos, this.commonParamList, this.tableTypes, this.dt, this.language);
            XElement requestElem = TransformationServices.getElement((String)rfcname);
            XElement requestComplexType = (XElement)commonComplexType.clone();
            XElement requestAll = requestComplexType.getSubElement("all", "http://www.w3.org/2001/XMLSchema");
            List requestParam = (List)this.requestParamList.get(pos);
            int i = 0;
            while (i < requestParam.size()) {
                XElement param = (XElement)requestParam.get(i);
                requestAll.add(Common.getElementForType(param, "parameter", this.tableTypes, this.dt, this.language));
                ++i;
            }
            requestElem.add(requestComplexType);
            XElement responseElem = TransformationServices.getElement((String)(rfcname + ".Response"));
            XElement responseAll = commonComplexType.getSubElement("all", "http://www.w3.org/2001/XMLSchema");
            List responseParam = (List)this.responseParamList.get(pos);
            int i2 = 0;
            while (i2 < responseParam.size()) {
                XElement param = (XElement)responseParam.get(i2);
                responseAll.add(Common.getElementForType(param, "parameter", this.tableTypes, this.dt, this.language));
                ++i2;
            }
            responseElem.add(commonComplexType);
            schema.add(requestElem);
            schema.add(responseElem);
            if (((Boolean)this.exceptionExistList.get(pos)).booleanValue()) {
                schema.add(Common.getExceptionsXElement((List)this.exceptionList.get(pos), (String)this.rfcnameList.get(pos)));
            }
            ++pos;
        }
        Common.addDDICStructureTypes(schema, this.structureTypes, this.tableTypes, this.dt, this.language);
        Common.addDateTimeTypes(schema, this.dt.dateTypeExists(), this.dt.timeTypeExists(), "s0");
        return types;
    }

    private XElement getMessageXElement(String rfcname, String messageExt, String paramExt) {
        XElement message = TransformationServices.getWSDLMessageElement((String)(rfcname + "." + messageExt));
        XElement part = TransformationServices.getWSDLMessagePart((String)"parameters", (String)("s0:" + rfcname + paramExt));
        message.add(part);
        return message;
    }

    private XElement getPortType() {
        XElement portType = TransformationServices.getWSDLPortType((String)(this.porttypeName + "." + "PortType"));
        int i = 0;
        while (i < this.rfcnameList.size()) {
            String name = (String)this.rfcnameList.get(i);
            XElement operation = TransformationServices.getWSDLPorttypeOperation((String)name);
            XElement input = TransformationServices.getWSDLInputMessage((String)("s0:" + name + ".Input"));
            operation.add(input);
            XElement output = TransformationServices.getWSDLOutputMessage((String)("s0:" + name + ".Output"));
            operation.add(output);
            if (((Boolean)this.exceptionExistList.get(i)).booleanValue()) {
                String exname = name + ".Exception";
                XElement fault = TransformationServices.getWSDLFaultMessage((String)("s0:" + exname), (String)exname);
                operation.add(fault);
            }
            portType.add(operation);
            ++i;
        }
        return portType;
    }

    private XElement getBindingRFC() {
        XElement sapBinding = ClassicTransformation.f.newXElement("binding", Common.rfcns);
        sapBinding.add(ClassicTransformation.f.newXAttribute("style", "rfc"));
        XElement binding = TransformationServices.getWSDLBinding((String)(this.porttypeName + ".SAPBinding"), (String)("s0:" + this.porttypeName + ".PortType"));
        binding.add(sapBinding);
        int i = 0;
        while (i < this.linkedTypesContainer.size()) {
            XElement sapType = ClassicTransformation.f.newXElement("type", Common.rfcns);
            sapType.add(ClassicTransformation.f.newXAttribute("name", (String)this.linkedTypesName.get(i)));
            sapType.add((XElement)((XElement)this.linkedTypesContainer.get(i)).clone());
            binding.add(sapType);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.rfcnameList.size()) {
            String name = (String)this.rfcnameList.get(i2);
            XElement rfcContainer = (XElement)this.rfcContainerList.get(i2);
            XElement operation = ClassicTransformation.f.newXElement("operation", "http://schemas.xmlsoap.org/wsdl/");
            operation.add(ClassicTransformation.f.newXAttribute("name", name));
            operation.add((XElement)rfcContainer.clone());
            binding.add(operation);
            ++i2;
        }
        return binding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

