/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.transformation;

import com.sap.aii.upload.transformation.DateTime;
import com.sap.aii.upload.transformation.InvalidDocumentException;
import com.sap.aii.upload.transformation.TServices;
import com.sap.aii.util.xml.api.TransformationConstants;
import com.sap.aii.util.xml.api.TransformationServices;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Common {
    public static final XDOMFactory f = new XDOMFactory();
    public static final String rfcnsPrefix = "s0";
    public static final String rfcnsUri = "urn:sap-com:document:sap:rfc:functions";
    public static final XNamespace rfcns = f.newXNamespace("s0", "urn:sap-com:document:sap:rfc:functions");
    public static final String idocnsPrefix = "s1";
    public static final String idocnsUri = "urn:sap-com:document:sap:idoc:functions";
    public static final XNamespace idocns = f.newXNamespace("s1", "urn:sap-com:document:sap:idoc:functions");
    public static final String PARAM_RFC_MESSAGE_PART = "MESSAGE_PART";
    public static final String PROPERTY_RFC_REQUEST = "REQUEST";
    public static final String PROPERTY_RFC_RESPONSE = "RESPONSE";
    public static final String PROPERTY_RFC_FAULT = "FAULT";
    public static final String PARAM_SPEC_XSD_VERSION = "XSD_VERSION";
    public static final String PARAM_SPEC_WSDL_VERSION = "WSDL_VERSION";
    public static final String PROPERTY_PORTTYPENAME = "porttypename";
    public static final String PROPERTY_SAPBINDING = "SAPBINDING";
    public static final String PROPERTY_SAPBINDING_TRUE = "TRUE";
    public static final String PARAMETER_WSDL_SOAP_FNAME = "WSDL_SOAP_FNAME";
    public static final String PARAMETER_WSDL_SOAP_FNAMESPACE = "WSDL_SOAP_FNAMESPACE";
    public static final String PARAMETER_WSDL_SOAP_BSNAME = "WSDL_SOAP_BSNAME";
    public static final String PARAMETER_WSDL_SOAP_LOCATION_PART = "WSDL_SOAP_LOCATION_PART";
    public static final int ALL = 0;
    public static final int EXCEPTIONS = 1;
    public static final int NO_EXCEPTIONS = 2;

    public static String getXlinkHrefKey(String text) {
        String key = "";
        if (text != null) {
            String hrefValue = text.substring(text.indexOf("?") + 1);
            key = key + TransformationServices.getValueFromXlinkHref((String)"TYPE", (String)hrefValue);
            key = key + TransformationServices.getValueFromXlinkHref((String)"NAME", (String)hrefValue);
        }
        return key;
    }

    public static void addAbapTypeMapping(XElement root, XElement definition, DateTime dt) throws InvalidDocumentException {
        if (root == null || definition == null) {
            return;
        }
        String abapType = Common.getSubElementTextTrim(definition, "abapType", TransformationConstants.ifrns);
        if (abapType.compareTo("T") == 0) {
            root.add(f.newXAttribute("type", "s0:time"));
            dt.setTimeExists();
        } else if (abapType.compareTo("D") == 0) {
            root.add(f.newXAttribute("type", "s0:date"));
            dt.setDateExists();
        } else if (abapType.compareTo("F") == 0) {
            root.add(f.newXAttribute("type", "xsd:double"));
        } else if (abapType.compareTo("b") == 0) {
            root.add(f.newXAttribute("type", "xsd:unsignedByte"));
        } else if (abapType.compareTo("s") == 0) {
            root.add(f.newXAttribute("type", "xsd:short"));
        } else if (abapType.compareTo("I") == 0) {
            root.add(f.newXAttribute("type", "xsd:int"));
        } else if (abapType.compareTo("g") == 0) {
            root.add(f.newXAttribute("type", "xsd:string"));
        } else if (abapType.compareTo("y") == 0) {
            root.add(f.newXAttribute("type", "xsd:base64Binary"));
        } else {
            XElement simpleType = f.newXElement("simpleType", TransformationConstants.xsdns);
            XElement elem = f.newXElement("restriction", TransformationConstants.xsdns);
            simpleType.add(elem);
            if (abapType.compareTo("X") == 0) {
                elem.add(f.newXAttribute("base", "xsd:base64Binary"));
                elem.add(TransformationServices.getFacetXElement((String)"length", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            } else if (abapType.compareTo("C") == 0) {
                elem.add(f.newXAttribute("base", "xsd:string"));
                elem.add(TransformationServices.getFacetXElement((String)"maxLength", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            } else if (abapType.compareTo("P") == 0) {
                elem.add(f.newXAttribute("base", "xsd:decimal"));
                elem.add(TransformationServices.getFacetXElement((String)"totalDigits", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
                elem.add(TransformationServices.getFacetXElement((String)"fractionDigits", (String)Common.getSubElementTextTrim(definition, "decimals", TransformationConstants.ifrns)));
            } else if (abapType.compareTo("N") == 0) {
                elem.add(f.newXAttribute("base", "xsd:string"));
                elem.add(TransformationServices.getFacetXElement((String)"pattern", (String)"\\d+"));
                elem.add(TransformationServices.getFacetXElement((String)"maxLength", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            }
            root.add(simpleType);
        }
    }

    public static XElement getGenericDateTimeType(String name, String pattern) {
        XElement simpleType = TransformationServices.getSimpleType((String)name);
        XElement restriction = TransformationServices.getRestriction((String)"xsd:string");
        simpleType.add(restriction);
        XElement pat = TransformationServices.getPattern();
        pat.add(f.newXAttribute("value", pattern));
        restriction.add(pat);
        return simpleType;
    }

    public static XElement getSimpleTypeDateTime(String name, String sapname, String prefix) {
        XElement simpleType = TransformationServices.getSimpleType((String)name);
        XElement union = TransformationServices.getUnion();
        union.add(f.newXAttribute("memberTypes", "xsd:" + name + " " + (prefix != null ? prefix + ":" : "") + sapname));
        simpleType.add(union);
        return simpleType;
    }

    public static XElement getElementForType(XElement parent, String category, Hashtable tableTypes, DateTime dt, String language) throws InvalidDocumentException {
        XElement deeperDef;
        XElement def;
        XElement elem = TransformationServices.getElement(null);
        boolean isTablesParamDefByStructure = false;
        if (category.compareTo("tableType") == 0) {
            elem.add(f.newXAttribute("name", "item"));
            elem.add(f.newXAttribute("minOccurs", "0"));
            elem.add(f.newXAttribute("maxOccurs", "unbounded"));
        } else {
            elem.add(f.newXAttribute("name", TransformationServices.escapeName((String)parent.getAttributeValue("name"))));
            if (category.compareTo("parameter") == 0) {
                String classV;
                XElement properties = Common.getSubElement(parent, "properties", TransformationConstants.ifrns);
                String optional = Common.getSubElementTextTrim(properties, "optional", TransformationConstants.ifrns);
                if (optional.compareTo("true") == 0) {
                    elem.add(f.newXAttribute("minOccurs", "0"));
                }
                if ((classV = Common.getSubElementTextTrim(properties, "class", TransformationConstants.ifrns)).compareTo("tables") == 0) {
                    isTablesParamDefByStructure = true;
                }
            } else {
                elem.add(f.newXAttribute("minOccurs", "0"));
            }
            elem.add(TransformationServices.getXSDAnnotationDocu((String)TransformationServices.getMetaDocumentation((XElement)parent, (String)language), (String)language));
        }
        XElement definition = Common.getSubElement(parent, "definition", TransformationConstants.ifrns);
        if (definition.getSubElement("scalarType", "urn:sap-com:ifr:v2:metamodel") != null) {
            def = definition.getSubElement("scalarType", "urn:sap-com:ifr:v2:metamodel");
            deeperDef = Common.getSubElement(def, "definition", TransformationConstants.ifrns);
            Common.addAbapTypeMapping(elem, deeperDef, dt);
        } else if (definition.getSubElement("abapType", "urn:sap-com:ifr:v2:metamodel") != null) {
            def = definition.getSubElement("abapType", "urn:sap-com:ifr:v2:metamodel");
            deeperDef = Common.getSubElement(def, "definition", TransformationConstants.ifrns);
            Common.addAbapTypeMapping(elem, deeperDef, dt);
        } else if (definition.getSubElement("complexType", "urn:sap-com:ifr:v2:metamodel") != null) {
            XElement complexType = definition.getSubElement("complexType", "urn:sap-com:ifr:v2:metamodel");
            String type = Common.getAttributeValue(complexType, "type");
            if (type.compareTo("structure") == 0) {
                if (!isTablesParamDefByStructure) {
                    elem.add(f.newXAttribute("type", "s0:" + TransformationServices.escapeName((String)complexType.getAttributeValue("name"))));
                } else {
                    XElement tabComplexType = f.newXElement("complexType", TransformationConstants.xsdns);
                    XElement tabSequence = f.newXElement("sequence", TransformationConstants.xsdns);
                    tabComplexType.add(tabSequence);
                    XElement tabElem = TransformationServices.getElement((String)"item");
                    tabElem.add(f.newXAttribute("minOccurs", "0"));
                    tabElem.add(f.newXAttribute("maxOccurs", "unbounded"));
                    String ctName = Common.getAttributeValue(complexType, "name");
                    tabElem.add(f.newXAttribute("type", "s0:" + TransformationServices.escapeName((String)ctName)));
                    tabSequence.add(tabElem);
                    elem.add(tabComplexType);
                }
            } else {
                String href = Common.getAttributeValue(complexType, f.newXName("href", "http://www.w3.org/1999/xlink"));
                String key = Common.getXlinkHrefKey(href);
                XElement storedData = (XElement)tableTypes.get(key);
                elem.add(Common.getComplexTableTypeInPlace(storedData, tableTypes, dt, language));
            }
        } else {
            throw new InvalidDocumentException(Common.getPath(parent) + "<ifr:complexType/abapType/scalarType>", 1);
        }
        return elem;
    }

    public static XElement getComplexTableTypeInPlace(XElement storedData, Hashtable tableTypes, DateTime dt, String language) throws InvalidDocumentException {
        XElement complexType = TransformationServices.getComplexType(null);
        XElement sequence = TransformationServices.getSequence();
        complexType.add(sequence);
        XElement data = Common.getSubElement(storedData, "data", TransformationConstants.cpns);
        XElement container = Common.getSubElement(data, "container", TransformationConstants.ifrns);
        XElement element = Common.getElementForType(container, "tableType", tableTypes, dt, language);
        sequence.add(element);
        return complexType;
    }

    public static void addDDICStructureTypes(XElement parent, List structureTypes, Hashtable tableTypes, DateTime dt, String language) throws InvalidDocumentException {
        int i = 0;
        while (i < structureTypes.size()) {
            XElement storedData = (XElement)structureTypes.get(i);
            XElement data = Common.getSubElement(storedData, "data", TransformationConstants.cpns);
            XElement container = Common.getSubElement(data, "container", TransformationConstants.ifrns);
            XElement definition = Common.getSubElement(container, "definition", TransformationConstants.ifrns);
            XElement fields = Common.getSubElement(definition, "fields", TransformationConstants.ifrns);
            XElement[] fieldList = fields.getSubElements("field", "urn:sap-com:ifr:v2:metamodel");
            XElement sequence = TransformationServices.getSequence();
            int j = 0;
            while (j < fieldList.length) {
                sequence.add(Common.getElementForType(fieldList[j], "field", tableTypes, dt, language));
                ++j;
            }
            XElement cpId = Common.getSubElement(storedData, "id", TransformationConstants.cpns);
            String name = Common.getSubElementTextTrim(cpId, "name", TransformationConstants.cpns);
            XElement complexType = TransformationServices.getComplexType((String)TransformationServices.escapeName((String)name));
            complexType.add(sequence);
            parent.add(complexType);
            ++i;
        }
    }

    public static XElement getCommonComplexTypeParameterList(int pos, List commonParamList, Hashtable tableTypes, DateTime dt, String language) throws InvalidDocumentException {
        XElement all = f.newXElement("all", TransformationConstants.xsdns);
        List commonParam = (List)commonParamList.get(pos);
        int i = 0;
        while (i < commonParam.size()) {
            XElement param = (XElement)commonParam.get(i);
            all.add(Common.getElementForType(param, "parameter", tableTypes, dt, language));
            ++i;
        }
        XElement complexType = TransformationServices.getComplexType(null);
        complexType.add(all);
        return complexType;
    }

    public static void addParameters(XElement parent, List parameterList) throws InvalidDocumentException {
        int i = 0;
        while (i < parameterList.size()) {
            XElement sourceParameter = (XElement)parameterList.get(i);
            String name = Common.getAttributeValue(sourceParameter, "name");
            XElement properties = Common.getSubElement(sourceParameter, "properties", TransformationConstants.ifrns);
            String direction = Common.getSubElementTextTrim(properties, "class", TransformationConstants.ifrns);
            XElement parameter = f.newXElement("parameter", rfcns);
            parameter.add(f.newXAttribute("name", TransformationServices.escapeName((String)name)));
            parameter.add(f.newXAttribute("direction", direction));
            parent.add(parameter);
            ++i;
        }
    }

    public static void handleSegment(XElement anchor, XElement segments, Map segmentTypeMap, DateTime dt, String language) throws InvalidDocumentException {
        if (segments == null) {
            return;
        }
        XElement[] segmentList = segments.getSubElements("segment", "urn:sap-com:ifr:v2:metamodel");
        int i = 0;
        while (i < segmentList.length) {
            XElement properties = Common.getSubElement(segmentList[i], "properties", TransformationConstants.ifrns);
            String par = Common.getSubElementTextTrim(properties, "isParent", TransformationConstants.ifrns);
            boolean isParent = new Boolean(par);
            XElement definition = Common.getSubElement(segmentList[i], "definition", TransformationConstants.ifrns);
            XElement segmentType = Common.getSubElement(definition, "segmentType", TransformationConstants.ifrns);
            String segmentTypeName = Common.getAttributeValue(segmentType, "name");
            XElement linkedSegmentTypeContainer = (XElement)segmentTypeMap.get(segmentTypeName);
            XElement segmentElem = TransformationServices.getElement((String)TransformationServices.escapeName((String)Common.getAttributeValue(segmentList[i], "name")));
            Common.addOccurence(segmentElem, properties, isParent);
            anchor.add(segmentElem);
            segmentElem.add(TransformationServices.getXSDAnnotationDocu((String)TransformationServices.getMetaDocumentation((XElement)linkedSegmentTypeContainer, (String)language), (String)language));
            XElement complexType = TransformationServices.getComplexType(null);
            segmentElem.add(complexType);
            XElement sequenceElem = TransformationServices.getSequence();
            complexType.add(sequenceElem);
            Common.handleSegmentType(sequenceElem, linkedSegmentTypeContainer, dt, language);
            complexType.add(TServices.getIDOCAttributeDeclaration("SEGMENT"));
            if (isParent) {
                XElement seg = Common.getSubElement(definition, "segments", TransformationConstants.ifrns);
                Common.handleSegment(sequenceElem, seg, segmentTypeMap, dt, language);
            }
            ++i;
        }
    }

    public static void handleSegmentType(XElement anchor, XElement segmentTypeContainer, DateTime dt, String language) throws InvalidDocumentException {
        XElement definition = Common.getSubElement(segmentTypeContainer, "definition", TransformationConstants.ifrns);
        XElement fields = Common.getSubElement(definition, "fields", TransformationConstants.ifrns);
        XElement[] fieldList = fields.getSubElements("field", "urn:sap-com:ifr:v2:metamodel");
        int i = 0;
        while (i < fieldList.length) {
            String fname = Common.getAttributeValue(fieldList[i], "name");
            String fieldName = TransformationServices.escapeName((String)fname);
            XElement fieldElem = TransformationServices.getElement((String)fieldName, (String)"0", null);
            anchor.add(fieldElem);
            fieldElem.add(TransformationServices.getXSDAnnotationDocu((String)TransformationServices.getMetaDocumentation((XElement)fieldList[i], (String)language), (String)language));
            XElement fieldDef = Common.getSubElement(fieldList[i], "definition", TransformationConstants.ifrns);
            XElement fieldType = Common.getSubElement(fieldDef, "scalarType", TransformationConstants.ifrns);
            XElement typeDef = Common.getSubElement(fieldType, "definition", TransformationConstants.ifrns);
            Common.addTypeMapping(fieldElem, typeDef, dt);
            ++i;
        }
    }

    public static void addTypeMapping(XElement root, XElement definition, DateTime dt) throws InvalidDocumentException {
        if (root == null || definition == null) {
            return;
        }
        String type = Common.getSubElementTextTrim(definition, "type", TransformationConstants.ifrns);
        if (type.compareTo("TIMS") == 0) {
            root.add(f.newXAttribute("type", "time"));
            dt.setTimeExists();
        } else if (type.compareTo("DATS") == 0) {
            root.add(f.newXAttribute("type", "date"));
            dt.setDateExists();
        } else if (type.compareTo("FLTP") == 0) {
            root.add(f.newXAttribute("type", "xsd:double"));
        } else if (type.compareTo("INT1") == 0) {
            root.add(f.newXAttribute("type", "xsd:unsignedByte"));
        } else if (type.compareTo("INT2") == 0 || type.compareTo("PREC") == 0) {
            root.add(f.newXAttribute("type", "xsd:short"));
        } else if (type.compareTo("INT4") == 0) {
            root.add(f.newXAttribute("type", "xsd:int"));
        } else if (type.compareTo("STRG") == 0 || type.compareTo("SSTR") == 0) {
            root.add(f.newXAttribute("type", "xsd:string"));
        } else if (type.compareTo("SRST") == 0) {
            root.add(f.newXAttribute("type", "xsd:base64Binary"));
        } else {
            XElement simpleType = TransformationServices.getSimpleType(null);
            XElement elem = TransformationServices.getRestriction(null);
            simpleType.add(elem);
            if (type.compareTo("RAW") == 0 || type.compareTo("LRAW") == 0) {
                elem.add(f.newXAttribute("base", "xsd:base64Binary"));
                elem.add(TransformationServices.getFacetXElement((String)"length", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            } else if (type.compareTo("CUKY") == 0 || type.compareTo("CLNT") == 0 || type.compareTo("CHAR") == 0 || type.compareTo("LCHR") == 0 || type.compareTo("VARC") == 0 || type.compareTo("UNIT") == 0) {
                elem.add(f.newXAttribute("base", "xsd:string"));
                elem.add(TransformationServices.getFacetXElement((String)"maxLength", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            } else if (type.compareTo("CURR") == 0 || type.compareTo("DEC") == 0 || type.compareTo("QUAN") == 0) {
                elem.add(f.newXAttribute("base", "xsd:decimal"));
                elem.add(TransformationServices.getFacetXElement((String)"totalDigits", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            } else if (type.compareTo("NUMC") == 0) {
                elem.add(f.newXAttribute("base", "xsd:string"));
                elem.add(TransformationServices.getFacetXElement((String)"pattern", (String)"\\d+"));
                elem.add(TransformationServices.getFacetXElement((String)"maxLength", (String)Common.getSubElementTextTrim(definition, "length", TransformationConstants.ifrns)));
            }
            root.add(simpleType);
        }
    }

    public static void addOccurence(XElement segmentRes, XElement properties, boolean isParent) throws InvalidDocumentException {
        String occmin;
        String occmax;
        if (!isParent) {
            occmax = Common.getSubElementTextTrim(properties, "maxOccurs", TransformationConstants.ifrns);
            boolean mandatory = new Boolean(Common.getSubElementTextTrim(properties, "mandatory", TransformationConstants.ifrns));
            occmin = !mandatory ? "0" : Common.getSubElementTextTrim(properties, "minOccurs", TransformationConstants.ifrns);
        } else {
            occmax = Common.getSubElementTextTrim(properties, "groupMaxOccurs", TransformationConstants.ifrns);
            boolean mandatory = new Boolean(Common.getSubElementTextTrim(properties, "groupMandatory", TransformationConstants.ifrns));
            occmin = !mandatory ? "0" : Common.getSubElementTextTrim(properties, "groupMinOccurs", TransformationConstants.ifrns);
        }
        Double d = new Double(occmax);
        if (d > 999999.0) {
            occmax = "999999";
        }
        segmentRes.add(f.newXAttribute("minOccurs", occmin));
        segmentRes.add(f.newXAttribute("maxOccurs", occmax));
    }

    public static XElement getExceptionsXElement(List exceptionListLocal, String rfcName) throws InvalidDocumentException {
        XElement restriction = TransformationServices.getRestriction((String)"xsd:string");
        int i = 0;
        while (i < exceptionListLocal.size()) {
            XElement e = (XElement)exceptionListLocal.get(i);
            XElement xElement = TransformationServices.getEnumeration();
            xElement.add(f.newXAttribute("value", TransformationServices.escapeName((String)Common.getAttributeValue(e, "name"))));
            restriction.add(xElement);
            ++i;
        }
        XElement simpleType = TransformationServices.getSimpleType(null);
        simpleType.add(restriction);
        XElement elemName = TransformationServices.getElement((String)"Name");
        elemName.add(simpleType);
        XElement elemText = TransformationServices.getElement((String)"Text");
        elemText.add(f.newXAttribute("minOccurs", "0"));
        elemText.add(f.newXAttribute("type", "xsd:string"));
        XElement elemIN1 = TransformationServices.getElement((String)"ID");
        elemIN1.add(TransformationServices.getSimpleType(null).add(TransformationServices.getRestriction((String)"xsd:string").add(TransformationServices.getFacetXElement((String)"maxLength", (String)"20"))));
        XElement restrictionIN = TransformationServices.getRestriction((String)"xsd:string").add(TransformationServices.getFacetXElement((String)"pattern", (String)"\\d+"));
        restrictionIN.add(TransformationServices.getFacetXElement((String)"maxLength", (String)"3"));
        XElement elemIN2 = TransformationServices.getElement((String)"Number");
        elemIN2.add(TransformationServices.getSimpleType(null).add(restrictionIN));
        XElement sequenceIN = TransformationServices.getSequence();
        sequenceIN.add(elemIN1);
        sequenceIN.add(elemIN2);
        XElement complexTypeIN = TransformationServices.getComplexType(null);
        complexTypeIN.add(sequenceIN);
        XElement elemMessage = TransformationServices.getElement((String)"Message");
        elemMessage.add(f.newXAttribute("minOccurs", "0"));
        elemMessage.add(complexTypeIN);
        XElement sequenceIN2 = TransformationServices.getSequence();
        sequenceIN2.add(Common.getExceptionAttributeTypes("V1"));
        sequenceIN2.add(Common.getExceptionAttributeTypes("V2"));
        sequenceIN2.add(Common.getExceptionAttributeTypes("V3"));
        sequenceIN2.add(Common.getExceptionAttributeTypes("V4"));
        XElement complexTypeIN2 = TransformationServices.getComplexType(null);
        complexTypeIN2.add(sequenceIN2);
        XElement elemAttributes = TransformationServices.getElement((String)"Attributes");
        elemAttributes.add(f.newXAttribute("minOccurs", "0"));
        elemAttributes.add(complexTypeIN2);
        XElement sequence = TransformationServices.getSequence();
        sequence.add(elemName);
        sequence.add(elemText);
        sequence.add(elemMessage);
        sequence.add(elemAttributes);
        XElement complexType = TransformationServices.getComplexType(null);
        complexType.add(sequence);
        XElement elem = TransformationServices.getElement((String)(rfcName + ".Exception"));
        elem.add(complexType);
        return elem;
    }

    public static void handleRFCPart(XElement cpStoredData, List rfcContainerList, List rfcnameList, List parameterList, List exceptionList, List requestParamList, List responseParamList, List commonParamList, List exceptionExistList, int parts) throws InvalidDocumentException {
        XElement data = Common.getSubElement(cpStoredData, "data", TransformationConstants.cpns);
        XElement rfcContainer = Common.getSubElement(data, "container", TransformationConstants.ifrns);
        rfcContainerList.add(rfcContainer);
        XElement rfcDefinition = Common.getSubElement(rfcContainer, "definition", TransformationConstants.ifrns);
        XElement id = Common.getSubElement(cpStoredData, "id", TransformationConstants.cpns);
        String name = Common.getSubElementTextTrim(id, "name", TransformationConstants.cpns);
        rfcnameList.add(TransformationServices.escapeName((String)name));
        XElement parameters = Common.getSubElement(rfcDefinition, "parameters", TransformationConstants.ifrns);
        XElement[] parameterListLocal = parameters.getSubElements("parameter", "urn:sap-com:ifr:v2:metamodel");
        parameterList.add(Arrays.asList(parameterListLocal));
        if (parts == 0 || parts == 1) {
            XElement exceptions = rfcDefinition.getSubElement("exceptions", "urn:sap-com:ifr:v2:metamodel");
            List<Object> exceptionListLocal = new Vector();
            if (exceptions != null) {
                exceptionListLocal = Arrays.asList(exceptions.getSubElements("exception", "urn:sap-com:ifr:v2:metamodel"));
            }
            if (exceptionListLocal.size() > 0) {
                exceptionExistList.add(Boolean.TRUE);
            } else {
                exceptionExistList.add(Boolean.FALSE);
            }
            exceptionList.add(exceptionListLocal);
        }
        if (parts == 0 || parts == 2) {
            Vector<XElement> requestParamListLocal = new Vector<XElement>();
            Vector<XElement> responseParamListLocal = new Vector<XElement>();
            Vector<XElement> commonParamListLocal = new Vector<XElement>();
            int i = 0;
            while (i < parameterListLocal.length) {
                XElement parameter = parameterListLocal[i];
                XElement property = Common.getSubElement(parameter, "properties", TransformationConstants.ifrns);
                String classValue = Common.getSubElementTextTrim(property, "class", TransformationConstants.ifrns);
                if (classValue.compareTo("import") == 0) {
                    requestParamListLocal.add(parameter);
                } else if (classValue.compareTo("export") == 0) {
                    responseParamListLocal.add(parameter);
                } else {
                    commonParamListLocal.add(parameter);
                }
                ++i;
            }
            requestParamList.add(requestParamListLocal);
            responseParamList.add(responseParamListLocal);
            commonParamList.add(commonParamListLocal);
        }
    }

    public static void addDateTimeTypes(XElement schema, boolean date, boolean time, String prefix) {
        if (date) {
            schema.add(Common.getSimpleTypeDateTime("date", "genericDate", prefix));
            schema.add(Common.getGenericDateTimeType("genericDate", "....-..-.."));
        }
        if (time) {
            schema.add(Common.getSimpleTypeDateTime("time", "genericTime", prefix));
            schema.add(Common.getGenericDateTimeType("genericTime", "..:..:.."));
        }
    }

    private static XElement getExceptionAttributeTypes(String name) {
        XElement simpleType = TransformationServices.getSimpleType(null);
        simpleType.add(TransformationServices.getRestriction((String)"xsd:string").add(TransformationServices.getFacetXElement((String)"maxLength", (String)"50")));
        XElement elem = TransformationServices.getElement((String)name);
        elem.add(f.newXAttribute("minOccurs", "0"));
        elem.add(simpleType);
        return elem;
    }

    private static String getPath(XElement e) {
        StringBuffer res = new StringBuffer();
        XElement p = e;
        while (p != null) {
            StringBuffer buf = new StringBuffer();
            XName name = p.getName();
            buf.append("<");
            String prefix = name.getNamespace().getPrefix();
            if (!"".equals(prefix)) {
                buf.append(prefix + ":");
            }
            buf.append(name.getLocalName());
            List attList = p.getAttributes();
            int i = 0;
            while (i < attList.size()) {
                XAttribute att = (XAttribute)attList.get(i);
                buf.append(" " + att.getQualifiedName() + "=" + att.getValue());
                ++i;
            }
            buf.append(">");
            res.insert(0, buf.toString());
            p = p.getParent();
        }
        return res.toString();
    }

    public static String getSubElementTextTrim(XElement parent, String name, XNamespace nsp) throws InvalidDocumentException {
        String text = parent.getSubElementTextTrim(name, nsp.getURI());
        if (text == null) {
            String act = "<";
            if (!"".equals(nsp.getPrefix())) {
                act = act + nsp.getPrefix() + ":";
            }
            throw new InvalidDocumentException(Common.getPath(parent) + act + name + ">", 1);
        }
        return text;
    }

    public static XElement getSubElement(XElement parent, String name, XNamespace nsp) throws InvalidDocumentException {
        XElement child = parent.getSubElement(name, nsp.getURI());
        if (child == null) {
            String act = "<";
            if (!"".equals(nsp.getPrefix())) {
                act = act + nsp.getPrefix() + ":";
            }
            throw new InvalidDocumentException(Common.getPath(parent) + act + name + ">", 1);
        }
        return child;
    }

    public static String getAttributeValue(XElement parent, XName name) throws InvalidDocumentException {
        String val = parent.getAttributeValue(name);
        if (val == null) {
            StringBuffer act = new StringBuffer(Common.getPath(parent));
            act.insert(act.length() - 1, " " + name.getQualifiedName() + "=...");
            throw new InvalidDocumentException(act.toString(), 2);
        }
        return val;
    }

    public static String getAttributeValue(XElement parent, String name) throws InvalidDocumentException {
        String val = parent.getAttributeValue(name);
        if (val == null) {
            StringBuffer act = new StringBuffer(Common.getPath(parent));
            act.insert(act.length() - 1, " " + name + "=...");
            throw new InvalidDocumentException(act.toString(), 2);
        }
        return val;
    }
}

