/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.tool;

import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.StorageException;
import com.sap.aii.upload.api.StorageInterface;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadObject;
import com.sap.aii.util.xml.api.XML;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLMemoryStream;
import com.sap.aii.util.xml.api.XMLStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class Tools {
    public static final String NAMESPACE_CP = "urn:sap-com:ifr:cp";

    private Tools() {
    }

    public static XML expandCollected(StorageInterface storage, SimpleUploadKey root, Collection links) throws NotFoundException, StorageException {
        HashSet<SimpleUploadKey> missingObjects = new HashSet<SimpleUploadKey>();
        HashSet<SimpleUploadKey> foundObjects = new HashSet<SimpleUploadKey>();
        Stack stack = new Stack();
        if (links != null) {
            stack.addAll(links);
        }
        try {
            XMLMemoryStream xml = new XMLMemoryStream();
            xml.openTag("list");
            xml.addNamespace("cp", NAMESPACE_CP);
            if (root != null) {
                Tools.addObjectToXML(storage, (XMLStream)xml, stack, root);
            }
            xml.openTag("links");
            while (!stack.isEmpty()) {
                SimpleUploadKey link = (SimpleUploadKey)stack.pop();
                if (foundObjects.contains(link) || missingObjects.contains(link)) continue;
                try {
                    Tools.addObjectToXML(storage, (XMLStream)xml, stack, link);
                    foundObjects.add(link);
                }
                catch (NotFoundException e) {
                    missingObjects.add(link);
                }
            }
            xml.closeTag();
            if (!missingObjects.isEmpty()) {
                xml.openTag("missingLinks");
                Iterator i = missingObjects.iterator();
                while (i.hasNext()) {
                    SimpleUploadKey link = (SimpleUploadKey)i.next();
                    Tools.addObjectIdToXML((XMLStream)xml, link);
                }
                xml.closeTag();
            }
            xml.closeTag();
            return xml.toXML();
        }
        catch (XMLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void addObjectIdToXML(XMLStream xml, SimpleUploadKey key) throws XMLException {
        xml.openTag(NAMESPACE_CP, "id");
        xml.addTextTag(NAMESPACE_CP, "type", key.getType());
        xml.addTextTag(NAMESPACE_CP, "name", key.getName());
        xml.closeTag();
    }

    private static void addObjectToXML(StorageInterface storage, XMLStream xml, Collection references, SimpleUploadKey key) throws NotFoundException, XMLException, StorageException {
        UploadObject obj = storage.read((UploadKey)key);
        xml.openTag(NAMESPACE_CP, "storedData");
        Tools.addObjectIdToXML(xml, key);
        xml.openTag(NAMESPACE_CP, "data");
        xml.addXML(obj.getObject());
        xml.closeTag();
        xml.closeTag();
        references.addAll(obj.getReferences());
    }
}

