/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.tool;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.MemoryStorage;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.StorageException;
import com.sap.aii.upload.api.StorageInterface;
import com.sap.aii.upload.api.UploadControl;
import com.sap.aii.upload.api.UploadEngine;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadResult;
import com.sap.aii.upload.api.UploadSource;
import com.sap.aii.upload.sap.SAPConnection;
import com.sap.aii.upload.sap.SAPConnectionData;
import com.sap.aii.upload.sap.SAPLoginData;
import com.sap.aii.upload.sap.SAPUploadSource;
import com.sap.aii.upload.tool.Tools;
import com.sap.aii.upload.transformation.InvalidDocumentException;
import com.sap.aii.upload.transformation.NotSupportedSpecificationException;
import com.sap.aii.upload.transformation.RFC2WSDL;
import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.BlobServices;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.InvalidArgumentException;
import com.sap.aii.util.misc.api.ResourceException;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.prop.api.PropertySource;
import com.sap.aii.util.prop.api.PropertySourceFactory;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import com.sap.aii.util.xml.api.XML;
import com.sap.aii.util.xml.api.XMLServices;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.mw.jco.JCO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;

public class RFC2WSDLTool {
    static /* synthetic */ Class class$com$sap$aii$upload$tool$RFC2WSDLTool;

    public XML getWSDLforRFCs(JCO.Client jcoClient, String[] rfcNames, String portType) throws ConnectionException, NotFoundException, StorageException, ResourceException, InvalidDocumentException, NotSupportedSpecificationException {
        return this.getWSDLforRFCs(new SAPConnection(jcoClient), rfcNames, portType);
    }

    public XML getWSDLforRFCs(SAPConnectionData connectData, SAPLoginData loginData, String[] rfcNames, String portType) throws ConnectionException, NotFoundException, StorageException, ResourceException, InvalidDocumentException, NotSupportedSpecificationException {
        SAPConnection connection = new SAPConnection(connectData, loginData);
        XML result = this.getWSDLforRFCs(connection, rfcNames, portType);
        connection.close();
        return result;
    }

    private XML getWSDLforRFCs(SAPConnection connection, String[] rfcNames, String portType) throws ConnectionException, NotFoundException, StorageException, ResourceException, InvalidDocumentException, NotSupportedSpecificationException {
        Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$tool$RFC2WSDLTool == null ? (class$com$sap$aii$upload$tool$RFC2WSDLTool = RFC2WSDLTool.class$("com.sap.aii.upload.tool.RFC2WSDLTool")) : class$com$sap$aii$upload$tool$RFC2WSDLTool).getName());
        MemoryStorage storage = MemoryStorage.getInstance();
        HashSet<SimpleUploadKey> objects = new HashSet<SimpleUploadKey>();
        int i = 0;
        while (i < rfcNames.length) {
            objects.add(new SimpleUploadKey("rfc", rfcNames[i]));
            ++i;
        }
        log.debug("reading rfc definitions from R/3");
        SAPUploadSource source = new SAPUploadSource(connection);
        try {
            UploadEngine engine = new UploadEngine((StorageInterface)storage);
            UploadControl uploadControl = new UploadControl();
            uploadControl.setLoadDocuRefs(false);
            UploadResult result = new UploadResult();
            engine.uploadObjects(uploadControl, (UploadSource)source, objects, result);
            HashSet failed = new HashSet(result.getObjectkeys(-2));
            failed.addAll(result.getObjectkeys(-1));
            if (!failed.isEmpty()) {
                throw new NotFoundException((UploadKey)failed.iterator().next());
            }
            Object var14_15 = null;
            source.close();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            source.close();
            throw throwable;
        }
        log.debug("generating wsdl");
        XML xml = Tools.expandCollected((StorageInterface)storage, null, objects);
        try {
            RFC2WSDL transformer = new RFC2WSDL();
            Properties p = new Properties();
            p.setProperty("SAPBINDING", "TRUE");
            p.setProperty("porttypename", portType);
            transformer.setProperties(p);
            transformer.transform(XMLServices.getXDOM((XML)xml));
            return XMLServices.getXML((AIIBlob)BlobServices.getBlobFromArray((byte[])transformer.getDocument(), (String)"xml"));
        }
        catch (InvalidArgumentException e) {
            throw new UnexpectedException((Exception)((Object)e));
        }
        catch (XDOMException e) {
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    private static void initMain() {
        if (System.getProperty("log.initialConfiguration") == null) {
            System.setProperty("log.initialConfiguration", "NONE");
        }
        Properties prop = new Properties();
        prop.setProperty("com.sap.aii.util.xml.parserFactory", "com.sap.engine.lib.jaxp.SAXParserFactoryImpl");
        prop.setProperty("com.sap.aii.util.xml.transformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
        PropertySourceFactory.setPropertySource((PropertySource)new BasicPropertySource(prop, ""));
    }

    public static void main(String[] args) throws Exception {
        RFC2WSDLTool.initMain();
        RFC2WSDLTool tool = new RFC2WSDLTool();
        String user = "user";
        String passwd = "pw";
        String host = "";
        String sysnr = "";
        String client = "";
        String outputfile = "";
        if (args.length < 7) {
            System.out.println("Usage: RFC2WSDLTool <outputfile> <Host> <SystemNr> <Client> <user> <password>  <List of RFMs>\n");
            System.exit(1);
        } else {
            outputfile = args[0];
            host = args[1];
            sysnr = args[2];
            client = args[3];
            user = args[4];
            passwd = args[5];
        }
        String[] rfms = new String[args.length - 6];
        int i = 6;
        while (i < args.length) {
            rfms[i - 6] = args[i];
            ++i;
        }
        File file = new File(outputfile);
        if (file.exists()) {
            file.delete();
        }
        SAPConnectionData connectData = new SAPConnectionData(host, sysnr, client);
        SAPLoginData loginData = new SAPLoginData(user, passwd);
        XML wsdl = tool.getWSDLforRFCs(connectData, loginData, rfms, "dummy");
        System.out.println("writing wsdl to file \"" + file.getCanonicalPath() + "\"");
        FileOutputStream fos = new FileOutputStream(file);
        wsdl.sendToOutputstream((OutputStream)fos);
        fos.close();
        System.out.println("ok.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

