/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap.akhUpload;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.sap.InvalidAKHException;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKH;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKHNodeImpl;
import com.sap.aii.upload.sap.api.SAPUploadAKHNodes;
import com.sap.aii.upload.sap.api.SAPUploadAKHPopAccess;
import com.sap.aii.util.log.api.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SAPUploadAKHPop
implements SAPUploadAKHPopAccess,
Serializable {
    private static final transient Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$akhUpload$SAPUploadAKHPop == null ? (class$com$sap$aii$upload$sap$akhUpload$SAPUploadAKHPop = SAPUploadAKHPop.class$("com.sap.aii.upload.sap.akhUpload.SAPUploadAKHPop")) : class$com$sap$aii$upload$sap$akhUpload$SAPUploadAKHPop).getName());
    private static final long serialVersionUID = 42L;
    private String systemID = "";
    private String client = "";
    private String sapRelease = "";
    private String description = "";
    private Map akhNodeID2eoks = new HashMap();
    private Set rootsOfEmptySubTrees = new HashSet();
    static /* synthetic */ Class class$com$sap$aii$upload$sap$akhUpload$SAPUploadAKHPop;

    private SAPUploadAKHPop() {
    }

    public SAPUploadAKHPop(SAPUploadAKH akh, Map akhNodeID2eoks, String systemID, String client, String sapRelease, String description) throws ConnectionException, InvalidAKHException {
        this.akhNodeID2eoks = akhNodeID2eoks;
        this.systemID = systemID;
        this.client = client;
        this.sapRelease = sapRelease;
        this.description = description;
        this.reduceNodeRefs(akh);
        SAPUploadAKHNodeImpl rootNode = (SAPUploadAKHNodeImpl)akh.getAKHRoot();
        if (rootNode == null) {
            akhNodeID2eoks = new HashMap();
            this.rootsOfEmptySubTrees = new HashSet();
            throw new InvalidAKHException(InvalidAKHException.createMsg_CAN_NOT_POPULATE_AKH());
        }
        this.buildRefToEmptySubTrees(rootNode);
    }

    private void reduceNodeRefs(SAPUploadAKH akh) {
        Iterator iter = akh.getNodeID2ReducedNodeMap().keySet().iterator();
        while (iter.hasNext()) {
            Object potentialSet;
            SAPUploadAKHNodeImpl nextNode;
            String newNodeID;
            String nodeID = (String)iter.next();
            if (nodeID.equals(newNodeID = (nextNode = (SAPUploadAKHNodeImpl)akh.getNodeID2ReducedNodeMap().get(nodeID)).getID()) || (potentialSet = this.akhNodeID2eoks.get(nodeID)) == null) continue;
            if (this.akhNodeID2eoks.containsKey(newNodeID)) {
                ((Map)this.akhNodeID2eoks.get(newNodeID)).putAll((Map)this.akhNodeID2eoks.get(nodeID));
            } else {
                this.akhNodeID2eoks.put(newNodeID, this.akhNodeID2eoks.get(nodeID));
            }
            this.akhNodeID2eoks.remove(nodeID);
        }
    }

    private boolean buildRefToEmptySubTrees(SAPUploadAKHNodeImpl node) {
        boolean subTreeIsEmpty = true;
        SAPUploadAKHNodes children = node.getChildren();
        SAPUploadAKHNodeImpl child = (SAPUploadAKHNodeImpl)children.getFirstChild();
        while (child != null) {
            if (!this.buildRefToEmptySubTrees(child)) {
                subTreeIsEmpty = false;
            }
            child = (SAPUploadAKHNodeImpl)children.getNextChild();
        }
        if (!this.getObjectsInNode(node.getID()).isEmpty()) {
            subTreeIsEmpty = false;
        }
        node.setIsEmptySubTree(subTreeIsEmpty);
        if (subTreeIsEmpty) {
            this.rootsOfEmptySubTrees.add(node.getID());
        }
        return subTreeIsEmpty;
    }

    public Map getPopulation() {
        return this.akhNodeID2eoks;
    }

    public Set getEmptySubTrees() {
        return this.rootsOfEmptySubTrees;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String getClient() {
        return this.client;
    }

    public String getSapRelease() {
        return this.sapRelease;
    }

    public String getDescription() {
        return this.description;
    }

    public Set getObjectsInNode(String nodeID) {
        if (this.akhNodeID2eoks.containsKey(nodeID)) {
            return ((Map)this.akhNodeID2eoks.get(nodeID)).keySet();
        }
        return new HashSet();
    }

    public Map getObjectInfos(String nodeID) {
        if (this.akhNodeID2eoks.containsKey(nodeID)) {
            return (Map)this.akhNodeID2eoks.get(nodeID);
        }
        return new HashMap();
    }

    public boolean isEmptySubTree(String nodeID) {
        return this.rootsOfEmptySubTrees.contains(nodeID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

