/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDFlatStructure;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDScalarField;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mdi.ddtypes.DDType;
import java.util.HashMap;
import java.util.Map;

class SAPUploadType
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadType == null ? (class$com$sap$aii$upload$sap$SAPUploadType = SAPUploadType.class$("com.sap.aii.upload.sap.SAPUploadType")) : class$com$sap$aii$upload$sap$SAPUploadType).getName());
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadType;

    public SAPUploadType(ObjectFactory of) {
        super(of);
    }

    public Map getObjectInfos(String type) {
        return new HashMap();
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        DDType type;
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        if (key.getType().equals("type")) {
            DDFactory ddf = this.bof.getDDFactory();
            type = (DDType)ddf.getDDObject(name);
            if (type == null) {
                throw new NotFoundException((UploadKey)key);
            }
        } else {
            throw new NotFoundException((UploadKey)key);
        }
        this.addDictionaryType(ws, type);
    }

    private void addDictionaryType(WorkingSet ws, DDType t) throws XMLException, MetaDataAccessException {
        if (t instanceof DDTabletype) {
            this.addTable(ws, (DDTabletype)t);
        } else if (t instanceof DDStructure) {
            this.addStructure(ws, (DDStructure)t);
        }
    }

    private void addStructure(WorkingSet ws, DDStructure s) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        this.addDescriptor(ws, s.getDescription(), "TB", s.getName());
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "release", this.bof.getSapRelease());
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "category", "structure");
        this.addUnicodeProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "isFlatStructure", SAPUploadCommon.toXMLString(s instanceof DDFlatStructure));
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        if (this.isUnicodeSupported()) {
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength1", SAPUploadCommon.toXMLString(this.tool.getInternalLength(s, 1)));
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength2", SAPUploadCommon.toXMLString(this.tool.getInternalLength(s, 2)));
        } else {
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength1", SAPUploadCommon.toXMLString(s.getStructureLength()));
        }
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "fields");
        int i = 1;
        while (i <= s.getNumberOfFields()) {
            DDField f = s.getField(i);
            log.fine("field " + f.getName());
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "field");
            xml.addAttr("name", f.getName());
            String kind = f.getTypeKind();
            DDObject obj = f.getChild();
            if (f instanceof DDScalarField) {
                xml.addAttr("category", "simple");
                this.addDescriptor(ws, f.getFieldtext(), "DE", f.getChildName());
            } else {
                xml.addAttr("category", "complex");
                xml.openTag("urn:sap-com:ifr:v2:metamodel", "descriptor");
                this.addDescription(ws, f.getFieldtext());
                xml.closeTag();
            }
            this.addField(ws, f);
            xml.closeTag();
            ++i;
        }
        xml.closeTag();
        xml.closeTag();
    }

    protected boolean isBasedOnDictionaryReference(DDType t) {
        return !(t instanceof DDBuiltInType);
    }

    private void addTable(WorkingSet ws, DDTabletype tt) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "descriptor");
        this.addDescription(ws, tt.getDescription());
        xml.closeTag();
        DDType linetype = (DDType)tt.getChild();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "release", this.bof.getSapRelease());
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "category", "tableType");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "basedOnDictionaryReference", SAPUploadCommon.toXMLString(this.isBasedOnDictionaryReference(linetype)));
        this.addUnicodeProperties(ws);
        xml.closeTag();
        this.addTypeDefinition(ws, linetype, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

