/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SingleUploadResult;
import com.sap.aii.upload.api.UploadControl;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadSource;
import com.sap.aii.upload.sap.AKHUploadSource;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.InvalidAKHException;
import com.sap.aii.upload.sap.SAPConnection;
import com.sap.aii.upload.sap.SAPConnectionData;
import com.sap.aii.upload.sap.SAPConnectionException;
import com.sap.aii.upload.sap.SAPLoginData;
import com.sap.aii.upload.sap.SAPUploadDocu;
import com.sap.aii.upload.sap.SAPUploadException;
import com.sap.aii.upload.sap.SAPUploadFactory;
import com.sap.aii.upload.sap.SAPUploadFunction;
import com.sap.aii.upload.sap.SAPUploadIDoc;
import com.sap.aii.upload.sap.SAPUploadIDocMessageType;
import com.sap.aii.upload.sap.SAPUploadIDocType;
import com.sap.aii.upload.sap.SAPUploadSegmentType;
import com.sap.aii.upload.sap.SAPUploadType;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKH;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.MetaDataAccessFunctionNotFoundException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mw.jco.JCO;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SAPUploadSource
implements UploadSource,
AKHUploadSource {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadSource == null ? (class$com$sap$aii$upload$sap$SAPUploadSource = SAPUploadSource.class$("com.sap.aii.upload.sap.SAPUploadSource")) : class$com$sap$aii$upload$sap$SAPUploadSource).getName());
    private static final Set ROOT_TYPES = new TreeSet();
    private static final Set ALL_TYPES = new TreeSet();
    private static final String PROP_RESET_THRESHOLD = "com.sap.aii.upload.resetThreshold";
    private static final int RESET_THRESHOLD = 0;
    private int resetThreshold = -1;
    private SAPConnection connection = null;
    private boolean ownConnect = false;
    private SAPUploadFactory sapUploadFactory = null;
    private ObjectFactory bof = null;
    private InternalHandler uploadFunction = null;
    private InternalHandler uploadType = null;
    private InternalHandler uploadBusinessObject = null;
    private InternalHandler uploadBapi = null;
    private InternalHandler uploadIDoc = null;
    private InternalHandler uploadIDocMessageType = null;
    private InternalHandler uploadIDocType = null;
    private InternalHandler uploadSegmentType = null;
    private InternalHandler uploadDocu = null;
    private InternalHandler uploadAkh = null;
    private int counter = 0;
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadSource;

    public SAPUploadSource(SAPConnection connection) throws ConnectionException {
        this.connection = connection;
        this.ownConnect = false;
        this.init();
    }

    public SAPUploadSource(SAPConnectionData connect, SAPLoginData login) throws ConnectionException {
        this.connection = new SAPConnection(connect, login);
        this.ownConnect = true;
        this.init();
    }

    private int getUploadThreshold() {
        if (this.resetThreshold < 0) {
            String value = AIIProperties.getInstance().getProperty(PROP_RESET_THRESHOLD, null);
            if (value != null) {
                try {
                    this.resetThreshold = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.resetThreshold = 0;
                    log.error("Property \"com.sap.aii.upload.resetThreshold\" contains no integer value: \"" + value + "\" (using " + this.resetThreshold + " as threshold)", (Throwable)e);
                }
            } else {
                this.resetThreshold = 0;
            }
            log.debug("ResetThreshold = " + this.resetThreshold);
        }
        return this.resetThreshold;
    }

    public String getSystemID() {
        return this.connection.getJCoClient().getAttributes().getSystemID();
    }

    private void init() throws ConnectionException {
        try {
            JCO.Client client = this.connection.getJCoClient();
            this.bof = new ObjectFactory(client);
            log.debug("init MDI to System " + this.connection.getConnectionData().getConnectionName() + " (BasisRelease: " + this.bof.getSapRelease().trim() + ")");
        }
        catch (ObjectFactoryException e) {
            throw new SAPConnectionException.MDIError(e);
        }
        this.sapUploadFactory = new SAPUploadFactory(this.bof);
    }

    public synchronized boolean isFeatureSupported(String name) {
        if (name.equalsIgnoreCase("AKH")) {
            return this.bof.isSupported("AKH") && this.bof.isSupported("RFM_DEVCLASS_COMPONENT_ID");
        }
        return this.bof.isSupported(name);
    }

    public synchronized String getBasisRelease() {
        return this.bof.getSapRelease().trim();
    }

    public synchronized void close() {
        if (this.bof != null) {
            this.bof = null;
        }
        if (this.ownConnect && this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private static String toMemString(long size) {
        if (size < 10000L) {
            return Long.toString(size);
        }
        if (size < 10000000L) {
            return Long.toString(size >> 10) + "k";
        }
        if (size < 10000000000L) {
            return Long.toString(size >> 20) + "M";
        }
        return Long.toString(size >> 30) + "G";
    }

    private static String getMemoryStatus() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        return SAPUploadSource.toMemString(total - free) + "/" + SAPUploadSource.toMemString(total);
    }

    private void reset() {
        Runtime rt = Runtime.getRuntime();
        log.debug("reset SAPUploadSource (using " + SAPUploadSource.getMemoryStatus() + ")");
        this.sapUploadFactory = null;
        this.bof = null;
        this.uploadFunction = null;
        this.uploadType = null;
        this.uploadBusinessObject = null;
        this.uploadBapi = null;
        this.uploadIDoc = null;
        this.uploadIDocMessageType = null;
        this.uploadIDocType = null;
        this.uploadSegmentType = null;
        this.uploadDocu = null;
        this.uploadAkh = null;
        this.connection.getJCoClient().reset();
        System.gc();
        try {
            this.init();
            this.bof.getRfms().search("*", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug("reset finished        (using " + SAPUploadSource.getMemoryStatus() + ")");
    }

    public void finalize() {
        if (this.bof != null || this.connection != null) {
            this.close();
        }
    }

    private InternalHandler getHandler(String type) {
        if (type.equals("rfc")) {
            if (this.uploadFunction == null) {
                this.uploadFunction = new SAPUploadFunction(this.bof);
            }
            return this.uploadFunction;
        }
        if (type.equals("type")) {
            if (this.uploadType == null) {
                this.uploadType = new SAPUploadType(this.bof);
            }
            return this.uploadType;
        }
        if (type.equals("idoc")) {
            if (this.uploadIDoc == null) {
                this.uploadIDoc = new SAPUploadIDoc(this.bof);
            }
            return this.uploadIDoc;
        }
        if (type.equals("imsg")) {
            if (this.uploadIDocMessageType == null) {
                this.uploadIDocMessageType = new SAPUploadIDocMessageType(this.bof);
            }
            return this.uploadIDocMessageType;
        }
        if (type.equals("ityp") || type.equals("iext")) {
            if (this.uploadIDocType == null) {
                this.uploadIDocType = new SAPUploadIDocType(this.bof);
            }
            return this.uploadIDocType;
        }
        if (type.equals("iseg")) {
            if (this.uploadSegmentType == null) {
                this.uploadSegmentType = new SAPUploadSegmentType(this.bof);
            }
            return this.uploadSegmentType;
        }
        if (type.equals("docu")) {
            if (this.uploadDocu == null) {
                this.uploadDocu = new SAPUploadDocu(this.bof);
            }
            return this.uploadDocu;
        }
        return null;
    }

    public synchronized SingleUploadResult uploadObject(UploadKey key, UploadControl uploadControl) throws ConnectionException, NotFoundException, UploadException {
        ++this.counter;
        int threshold = this.getUploadThreshold();
        if (threshold > 0 && this.counter >= threshold) {
            this.reset();
            this.counter = 0;
        }
        WorkingSet ws = new WorkingSet(key, uploadControl);
        InternalHandler handler = this.getHandler(key.getType());
        if (handler == null) {
            throw new NotFoundException(key);
        }
        try {
            XMLStream xml = ws.getStream();
            xml.openTag("ifr", "urn:sap-com:ifr:v2:metamodel", "container");
            xml.addNamespace("xlink", "http://www.w3.org/1999/xlink");
            handler.uploadObject(ws);
            xml.closeTag();
            return ws.getResult();
        }
        catch (XMLException e) {
            throw new UploadException((Throwable)e);
        }
        catch (MetaDataAccessFunctionNotFoundException e) {
            throw new SAPUploadException.RfcNotFound(e);
        }
        catch (ObjectFactoryException e) {
            Exception origEx = e.getOriginalException();
            if (origEx != null && origEx instanceof JCO.Exception) {
                JCO.Exception jcoEx = (JCO.Exception)((Object)origEx);
                if (jcoEx.getGroup() == 104) {
                    throw new SAPUploadException.R3Error(jcoEx);
                }
                throw new SAPUploadException.JCOError(jcoEx);
            }
            throw new SAPUploadException.MDIError(e);
        }
    }

    public synchronized Set getRootObjectTypes() {
        return Collections.unmodifiableSet(ROOT_TYPES);
    }

    public synchronized Set getAllObjectTypes() {
        return Collections.unmodifiableSet(ALL_TYPES);
    }

    public synchronized Map getObjectInfos(String type) throws ConnectionException, UploadException {
        InternalHandler upload = this.getHandler(type);
        return upload.getObjectInfos(type);
    }

    public synchronized SAPUploadAKH getAKH() throws InvalidAKHException, ConnectionException {
        return this.sapUploadFactory.getAKH();
    }

    public synchronized Map getAKHEoks() throws ConnectionException, UploadException {
        return this.sapUploadFactory.getAKHEoks();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ROOT_TYPES.add("rfc");
        ROOT_TYPES.add("idoc");
        ALL_TYPES.addAll(ROOT_TYPES);
        ALL_TYPES.add("imsg");
        ALL_TYPES.add("ityp");
        ALL_TYPES.add("iseg");
        ALL_TYPES.add("iext");
        ALL_TYPES.add("type");
        ALL_TYPES.add("akh");
        ALL_TYPES.add("akhpop");
    }
}

