/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.IDocSegment;
import com.sap.mdi.IDocSegmentField;
import com.sap.mdi.IDocSegmentFields;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import java.util.HashMap;
import java.util.Map;

class SAPUploadSegmentType
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadSegmentType == null ? (class$com$sap$aii$upload$sap$SAPUploadSegmentType = SAPUploadSegmentType.class$("com.sap.aii.upload.sap.SAPUploadSegmentType")) : class$com$sap$aii$upload$sap$SAPUploadSegmentType).getName());
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadSegmentType;

    public SAPUploadSegmentType(ObjectFactory of) {
        super(of);
    }

    public Map getObjectInfos(String type) {
        return new HashMap();
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        if (!key.getType().equals("iseg")) {
            throw new NotFoundException((UploadKey)key);
        }
        IDocSegment idocSegment = this.tool.getIDocSegment(name);
        if (idocSegment == null) {
            throw new NotFoundException((UploadKey)key);
        }
        this.addIDocSegment(ws, idocSegment);
    }

    private void addIDocSegment(WorkingSet ws, IDocSegment idocSegment) throws XMLException {
        XMLStream xml = ws.getStream();
        this.addDescriptor(ws, idocSegment.getDescription(), "TB", idocSegment.getName());
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "released", "?");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "definition", idocSegment.getDefinition());
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "fields");
        IDocSegmentFields segFields = idocSegment.getIDocSegmentFields();
        int i = 0;
        while (i < segFields.getSize()) {
            IDocSegmentField segField = segFields.getIDocSegmentField(i);
            log.finest("field " + segField.getName());
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "field");
            xml.addAttr("name", segField.getName());
            this.addDescriptor(ws, segField.getDescription(), "DE", segField.getDataElementName());
            this.addSegFieldDefinition(ws, segField);
            xml.closeTag();
            ++i;
        }
        xml.closeTag();
        xml.closeTag();
    }

    private void addSegFieldDefinition(WorkingSet ws, IDocSegmentField segField) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "scalarType");
        xml.addAttr("name", segField.getDataElementName());
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "type", segField.getDataTypeDD());
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "length", SAPUploadCommon.toXMLString(segField.getInternalLength()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "decimals", SAPUploadCommon.toXMLString(this.tool.getDecimals(segField)));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "outputLength", SAPUploadCommon.toXMLString(segField.getOutputLength()));
        xml.closeTag();
        xml.closeTag();
        xml.closeTag();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

