/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.CorruptMetadataException;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.IDocMessageType;
import com.sap.mdi.IDocMessageTypes;
import com.sap.mdi.IDocSegment;
import com.sap.mdi.IDocSegments;
import com.sap.mdi.IDocType;
import com.sap.mdi.IDocTypeBase;
import com.sap.mdi.IDocTypeExtension;
import com.sap.mdi.IDocTypes;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import java.util.HashMap;
import java.util.Map;

class SAPUploadIDocType
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadIDocType == null ? (class$com$sap$aii$upload$sap$SAPUploadIDocType = SAPUploadIDocType.class$("com.sap.aii.upload.sap.SAPUploadIDocType")) : class$com$sap$aii$upload$sap$SAPUploadIDocType).getName());
    private final boolean inplaceSegmentType = AIIProperties.getInstance().getProperty("ifr.upload.inplaceSegmentType", "false").equals("true");
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadIDocType;

    public SAPUploadIDocType(ObjectFactory of) {
        super(of);
    }

    public Map getObjectInfos(String type) {
        return new HashMap();
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        String type = key.getType();
        if (type.equals("ityp")) {
            IDocType idocType = this.bof.getIDocType(name);
            if (idocType == null) {
                throw new NotFoundException((UploadKey)key);
            }
            this.addIDocType(ws, (IDocTypeBase)idocType);
        } else if (type.equals("iext")) {
            IDocTypeExtension idocType = this.tool.getIDocTypeExtension(name);
            if (idocType == null) {
                throw new NotFoundException((UploadKey)key);
            }
            this.addIDocType(ws, (IDocTypeBase)idocType);
        } else {
            throw new NotFoundException((UploadKey)key);
        }
    }

    private IDocType getIDocType(SimpleUploadKey key) throws NotFoundException, MetaDataAccessException {
        String[] names = this.getNames(key);
        IDocMessageTypes mesTypes = this.bof.getIDocMessageTypes();
        if (mesTypes == null) {
            throw new NotFoundException((UploadKey)key);
        }
        IDocMessageType mesType = mesTypes.getIDocMessageType(names[0]);
        if (mesType == null) {
            throw new NotFoundException((UploadKey)key);
        }
        IDocTypes idocTypes = mesType.getIDocTypes();
        if (idocTypes == null) {
            throw new NotFoundException((UploadKey)key);
        }
        return idocTypes.getIDocType(names[1]);
    }

    private String[] getNames(SimpleUploadKey key) throws NotFoundException {
        String name = key.getName();
        int pointpos = name.indexOf(".");
        if (pointpos < 0) {
            throw new NotFoundException((UploadKey)key);
        }
        String[] res = new String[]{name.substring(0, pointpos), name.substring(pointpos + 1)};
        return res;
    }

    private void addIDocType(WorkingSet ws, IDocTypeBase idocType) throws XMLException, MetaDataAccessException, CorruptMetadataException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "descriptor");
        this.addDescription(ws, idocType.getDescription());
        xml.closeTag();
        this.addIDocTypeProperties(ws, idocType);
        this.addIDocTypeDefinition(ws, idocType);
    }

    private void addIDocTypeProperties(WorkingSet ws, IDocTypeBase idocType) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "akhNode", "?");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "package", idocType.getDevelopmentClass());
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "released", idocType.getRelease()).addComment("release since which this idoctype is released");
        if (idocType instanceof IDocTypeExtension) {
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "extended", "true");
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "basicType", ((IDocTypeExtension)idocType).getIDocTypeName());
        } else {
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "extended", "false");
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "basicType", "");
        }
        xml.closeTag();
    }

    private void addIDocTypeDefinition(WorkingSet ws, IDocTypeBase idoc) throws XMLException, MetaDataAccessException, CorruptMetadataException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        IDocSegments segments = null;
        if (idoc instanceof IDocType) {
            IDocType idocType = (IDocType)idoc;
            segments = idocType.getIDocSegments();
        } else if (idoc instanceof IDocTypeExtension) {
            IDocTypeExtension idocExt = (IDocTypeExtension)idoc;
            segments = idocExt.getIDocSegments();
        }
        if (segments == null || segments.getSize() == 0) {
            throw new CorruptMetadataException.MissingIDOCSegments(idoc.getName());
        }
        this.addSegments(ws, segments);
        xml.closeTag();
    }

    private void addSegments(WorkingSet ws, IDocSegments segs) throws XMLException {
        XMLStream xml = ws.getStream();
        if (segs == null || segs.getSize() < 1) {
            return;
        }
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "segments");
        int i = 0;
        while (i < segs.getSize()) {
            IDocSegment seg = segs.getIDocSegment(i);
            this.tool.addSegmentToBuffer(seg);
            this.addSegment(ws, seg);
            ++i;
        }
        xml.closeTag();
    }

    private void addSegment(WorkingSet ws, IDocSegment seg) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "segment");
        xml.addAttr("name", seg.getName());
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "mandatory", SAPUploadCommon.toXMLString(seg.isMandatory()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "minOccurs", SAPUploadCommon.toXMLString(seg.getOccurrenceMinimum()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "maxOccurs", SAPUploadCommon.toXMLString(seg.getOccurrenceMaximum()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "isParent", SAPUploadCommon.toXMLString(seg.isStartOfSegmentGroup()));
        if (seg.isStartOfSegmentGroup()) {
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "groupMandatory", SAPUploadCommon.toXMLString(seg.isGroupMandatory()));
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "groupMinOccurs", SAPUploadCommon.toXMLString(seg.getGroupOccurrenceMinimum()));
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "groupMaxOccurs", SAPUploadCommon.toXMLString(seg.getGroupOccurrenceMaximum()));
        }
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "segmentType");
        String name = seg.getName();
        xml.addAttr("name", name);
        xml.addAttr("definition", seg.getDefinition());
        this.addLink(ws, "iseg", name);
        xml.closeTag();
        IDocSegments segs = seg.getChildren();
        if (segs != null) {
            this.addSegments(ws, segs);
        }
        xml.closeTag();
        xml.closeTag();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

