/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.IDocMessageType;
import com.sap.mdi.IDocMessageTypes;
import com.sap.mdi.IDocType;
import com.sap.mdi.IDocTypes;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import java.util.HashMap;
import java.util.Map;

class SAPUploadIDocMessageType
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadIDocMessageType == null ? (class$com$sap$aii$upload$sap$SAPUploadIDocMessageType = SAPUploadIDocMessageType.class$("com.sap.aii.upload.sap.SAPUploadIDocMessageType")) : class$com$sap$aii$upload$sap$SAPUploadIDocMessageType).getName());
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadIDocMessageType;

    public SAPUploadIDocMessageType(ObjectFactory of) {
        super(of);
    }

    public Map getObjectInfos(String type) {
        return new HashMap();
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        if (!key.getType().equals("imsg")) {
            throw new NotFoundException((UploadKey)key);
        }
        IDocMessageTypes mesTypes = this.bof.getIDocMessageTypes();
        if (mesTypes == null) {
            throw new NotFoundException((UploadKey)key);
        }
        IDocMessageType mesType = mesTypes.getIDocMessageType(name);
        if (mesType == null) {
            throw new NotFoundException((UploadKey)key);
        }
        this.addIDocMessageType(ws, mesType);
    }

    private void addIDocMessageType(WorkingSet ws, IDocMessageType mesType) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "descriptor");
        this.addDescription(ws, mesType.getDescription());
        xml.closeTag();
        this.addIDocMessageTypeProperties(ws, mesType);
        this.addIDocMessageTypeDefinition(ws, mesType);
    }

    private void addIDocMessageTypeProperties(WorkingSet ws, IDocMessageType mesType) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "usageScenario");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "component", "?");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "direction", "?");
        xml.closeTag();
        xml.closeTag();
    }

    private void addIDocMessageTypeDefinition(WorkingSet ws, IDocMessageType mes) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "idocTypes");
        IDocTypes idocTypes = mes.getIDocTypes();
        int i = 0;
        while (i < idocTypes.getSize()) {
            IDocType idocType = idocTypes.getIDocType(i);
            String release = idocType.getRelease();
            log.fine("idoc-type " + idocType.getName() + " rel=" + release);
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "idocType");
            String name = idocType.getName();
            xml.addAttr("name", name);
            xml.closeTag();
            ++i;
        }
        xml.closeTag();
        xml.closeTag();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

