/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.IDocMessageType;
import com.sap.mdi.IDocMessageTypes;
import com.sap.mdi.IDocType;
import com.sap.mdi.IDocTypeExtension;
import com.sap.mdi.IDocTypeExtensions;
import com.sap.mdi.IDocTypes;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class SAPUploadIDoc
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadIDoc == null ? (class$com$sap$aii$upload$sap$SAPUploadIDoc = SAPUploadIDoc.class$("com.sap.aii.upload.sap.SAPUploadIDoc")) : class$com$sap$aii$upload$sap$SAPUploadIDoc).getName());
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadIDoc;

    public SAPUploadIDoc(ObjectFactory of) {
        super(of);
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        String type = key.getType();
        if (!type.equals("idoc")) {
            throw new NotFoundException((UploadKey)key);
        }
        this.uploadIDoc(ws, key);
    }

    public Map getObjectInfos(String type) throws ConnectionException {
        if (!type.equals("idoc")) {
            return Collections.EMPTY_MAP;
        }
        HashMap<SimpleUploadKey, Properties> result = new HashMap<SimpleUploadKey, Properties>();
        try {
            IDocMessageTypes imsgs = this.bof.getIDocMessageTypes();
            int i = 0;
            while (i < imsgs.getSize()) {
                IDocMessageType imsg = imsgs.getIDocMessageType(i);
                IDocTypes itypes = imsg.getIDocTypes();
                int j = 0;
                while (j < itypes.getSize()) {
                    IDocType itype = itypes.getIDocType(j);
                    String baseName = imsg.getName() + "." + itype.getName();
                    Properties p = new Properties();
                    p.setProperty("description", itype.getDescription());
                    result.put(new SimpleUploadKey("idoc", baseName), p);
                    IDocTypeExtensions iexts = itype.getIDocTypeExtensions();
                    int k = 0;
                    while (k < iexts.getSize()) {
                        IDocTypeExtension iext = iexts.getIDocTypeExtension(k);
                        String name = baseName + "." + iext.getName();
                        p = new Properties();
                        p.setProperty("description", iext.getDescription());
                        result.put(new SimpleUploadKey("idoc", name), p);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (MetaDataAccessException e) {
            log.warning("exception in getObjectInfos()", (Throwable)e);
        }
        return result;
    }

    private ArrayList splitNames(String name) throws NotFoundException {
        ArrayList<String> res = new ArrayList<String>();
        int pos = name.indexOf(".");
        while (pos >= 0) {
            res.add(name.substring(0, pos));
            name = name.substring(pos + 1);
            pos = name.indexOf(".");
        }
        res.add(name);
        return res;
    }

    private void uploadIDoc(WorkingSet ws, SimpleUploadKey key) throws XMLException, MetaDataAccessException, NotFoundException {
        String name = key.getName();
        ArrayList parts = this.splitNames(name);
        if (parts.size() < 2) {
            throw new NotFoundException((UploadKey)key);
        }
        String msgName = (String)parts.get(0);
        String typeName = (String)parts.get(1);
        String extName = null;
        if (parts.size() > 2) {
            extName = (String)parts.get(2);
        }
        IDocMessageType idocMsg = null;
        IDocType idocType = null;
        IDocTypeExtension idocExt = null;
        try {
            idocMsg = this.bof.getIDocMessageTypes().getIDocMessageType(msgName);
            if (idocMsg == null) {
                throw new NotFoundException((UploadKey)key);
            }
            idocType = idocMsg.getIDocTypes().getIDocType(typeName);
            if (idocType == null) {
                throw new NotFoundException((UploadKey)key);
            }
            if (extName != null && (idocExt = idocType.getIDocTypeExtensions().getIDocTypeExtension(extName)) == null) {
                throw new NotFoundException((UploadKey)key);
            }
        }
        catch (MetaDataAccessException e) {
            throw new NotFoundException((UploadKey)key);
        }
        this.addIDoc(ws, idocMsg, idocType, idocExt);
    }

    private void addIDoc(WorkingSet ws, IDocMessageType idocMsg, IDocType idocType, IDocTypeExtension idocExt) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "descriptor");
        this.addDescription(ws, idocType.getDescription());
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "akhNode", "?");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "package", idocType.getDevelopmentClass());
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "released", idocType.getRelease()).addComment("release since which this idoctype is released");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "asynchronous", "true");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "synchronous", "false");
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "messageType");
        this.addLink(ws, "imsg", idocMsg.getName());
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "idocType");
        this.addLink(ws, "ityp", idocType.getName());
        xml.closeTag();
        if (idocExt != null) {
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "extensionType");
            this.addLink(ws, "iext", idocExt.getName());
            xml.closeTag();
        }
        xml.closeTag();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

