/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.IFRManInfo;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.MetaDataAccessConnectionException;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmException;
import com.sap.mdi.RfmExceptions;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.RfmParameters;
import com.sap.mdi.Rfms;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mdi.ddtypes.DDType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class SAPUploadFunction
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadFunction == null ? (class$com$sap$aii$upload$sap$SAPUploadFunction = SAPUploadFunction.class$("com.sap.aii.upload.sap.SAPUploadFunction")) : class$com$sap$aii$upload$sap$SAPUploadFunction).getName());
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadFunction;

    public SAPUploadFunction(ObjectFactory of) {
        super(of);
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        if (!key.getType().equals("rfc")) {
            throw new NotFoundException((UploadKey)key);
        }
        Rfms rfms = this.bof.getRfms();
        if (!rfms.exists(name)) {
            throw new NotFoundException((UploadKey)key);
        }
        Rfm rfm = null;
        try {
            rfm = rfms.getRfm(name);
        }
        catch (MetaDataAccessConnectionException e) {
            throw new NotFoundException((UploadKey)key);
        }
        this.addFunction(ws, rfm);
    }

    public Map getObjectInfos(String type) throws ConnectionException, UploadException {
        HashMap<SimpleUploadKey, Properties> result = new HashMap<SimpleUploadKey, Properties>();
        boolean supportReleased = this.bof.isSupported("RFM_RELEASED");
        Rfms rfms = this.bof.getRfms();
        Set oks = this.getObjectKeySet(type);
        IFRManInfo ifrManInfo = IFRManInfo.getInstance();
        Iterator i = oks.iterator();
        while (i.hasNext()) {
            SimpleUploadKey key = (SimpleUploadKey)i.next();
            try {
                Rfm rfm = rfms.getRfm(key.getName());
                Properties p = new Properties();
                p.setProperty("description", rfm.getDescription());
                if (supportReleased) {
                    p.setProperty("released", this.releasedInt2String(rfm.getReleased()));
                }
                IFRManInfo.RfcInfo rfcInfo = ifrManInfo.getRfcInfo(rfm.getName());
                p.setProperty("isOutbound", String.valueOf(rfcInfo.isOutbound()));
                try {
                    String comp = rfm.getComponentId();
                    if (comp != null) {
                        p.setProperty("akhNode", comp);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                result.put(key, p);
            }
            catch (MetaDataAccessException e) {
                log.warning("exception in getObjectInfos()", (Throwable)e);
            }
        }
        return result;
    }

    private Set getObjectKeySet(String type) throws ConnectionException, UploadException {
        HashSet<SimpleUploadKey> result = new HashSet<SimpleUploadKey>();
        if (!type.equals("rfc")) {
            return result;
        }
        try {
            Rfms rfms = this.bof.getRfms().search("*", "");
            int i = 0;
            while (i < rfms.getSize()) {
                Rfm rfm = rfms.getRfm(i);
                SimpleUploadKey objectKey = new SimpleUploadKey(type, rfm.getName());
                result.add(objectKey);
                ++i;
            }
        }
        catch (MetaDataAccessException e) {
            log.error("", (Throwable)e);
            throw new UploadException((Throwable)e);
        }
        return result;
    }

    private void addObjectKeyToMap(Map akhNodeID2objectKeySets, String key, UploadKey objectKey) {
        if (akhNodeID2objectKeySets != null) {
            if (!akhNodeID2objectKeySets.containsKey(key)) {
                HashSet<UploadKey> objectKeySet = new HashSet<UploadKey>();
                objectKeySet.add(objectKey);
                akhNodeID2objectKeySets.put(key, objectKeySet);
            } else {
                ((Set)akhNodeID2objectKeySets.get(key)).add(objectKey);
            }
        }
    }

    private String releasedInt2String(int status) {
        switch (status) {
            case 0: {
                return "no";
            }
            case 1: {
                return "internal";
            }
            case 2: {
                return "external";
            }
            case 3: {
                return "obsolete";
            }
        }
        log.warning("unknown released-status " + status);
        return "?";
    }

    private void addFunction(WorkingSet ws, Rfm rfm) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        this.addDescriptor(ws, rfm.getDescription(), "FU", rfm.getName());
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "release", this.bof.getSapRelease());
        String pack = rfm.getDevclass();
        if (pack == null) {
            pack = "?";
        }
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "package", pack);
        String node = rfm.getComponentId();
        if (node == null) {
            node = "?";
        }
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "akhNode", node);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "released", this.releasedInt2String(rfm.getReleased()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "outbound", SAPUploadCommon.toXMLString(IFRManInfo.getInstance().getRfcInfo(rfm.getName()).isOutbound()));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "synchronous", "true");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "asynchronous", "false");
        this.addUnicodeProperties(ws);
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        RfmExceptions exceps = rfm.getRfmExceptions();
        if (exceps.getSize() > 0) {
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "exceptions");
            int i = 0;
            while (i < exceps.getSize()) {
                RfmException e = exceps.getRfmException(i);
                log.fine("exception " + e.getName());
                this.addException(ws, rfm, e);
                ++i;
            }
            xml.closeTag();
        }
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "parameters");
        RfmParameters parms = rfm.getRfmParameters();
        int i = 0;
        while (i < parms.getSize()) {
            RfmParameter p = parms.getRfmParameter(i);
            log.fine("parameter " + p.getName());
            this.addParameter(ws, rfm, p);
            ++i;
        }
        xml.closeTag();
        xml.closeTag();
    }

    private void addException(WorkingSet ws, Rfm rfm, RfmException e) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "exception");
        xml.addAttr("name", e.getName());
        String name = rfm.getName() + "                              ";
        name = name.substring(0, 30) + e.getName();
        this.addDescriptor(ws, e.getDescription(), "FX", name);
        xml.closeTag();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addParameter(WorkingSet ws, Rfm rfm, RfmParameter p) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "parameter");
        xml.addAttr("name", p.getName());
        String name = rfm.getName() + "                              ";
        name = name.substring(0, 30) + p.getName();
        this.addDescriptor(ws, p.getDescription(), "FU", name);
        String io = "";
        String pclass = "?";
        if (p.isTable()) {
            io = "inout";
            pclass = "tables";
        } else if (p.isChanging()) {
            io = "inout";
            pclass = "changing";
        } else if (p.isExport() && p.isImport()) {
            io = "inout";
            pclass = "import_export";
        } else if (p.isExport()) {
            io = "out";
            pclass = "export";
        } else if (p.isImport()) {
            io = "in";
            pclass = "import";
        } else {
            log.error("parameter " + p.getName() + " not import, export, table or changing?!");
        }
        boolean basedOnDic = p.isBasedOnDictionaryReference();
        DDObject obj = null;
        if (basedOnDic) {
            obj = p.getDDObject();
        }
        String type = "?";
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        if (obj != null) {
            if (obj instanceof DDField) {
                xml.addComment("Reference to Field");
                xml.openTag("urn:sap-com:ifr:v2:metamodel", "field");
                xml.addAttr("name", obj.getParent().getName() + "." + obj.getName());
                this.addFieldProperties(ws, (DDField)obj);
                xml.closeTag();
                obj = obj.getChild();
            }
            if (obj instanceof DDStructure) {
                type = "structure";
                xml.addComment("Structure");
                this.addDataType(ws, (DDType)((DDStructure)obj));
            } else if (obj instanceof DDTabletype) {
                type = "tableType";
                xml.addComment("TableType");
                this.addDataType(ws, (DDType)((DDTabletype)obj));
            } else {
                if (!(obj instanceof DDDataelement) && !(obj instanceof DDBuiltInType)) throw new InternalError("unknown R/3 ParameterType " + obj.getClass().getName());
                type = "scalar";
                xml.addComment("Scalar");
                this.addDataType(ws, (DDType)obj);
            }
        } else {
            xml.addComment("direct ABAP-Type");
            type = "scalar";
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "abapType");
            xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "abapType", p.getScalarDataTypeABAP());
            if (this.isUnicodeSupported()) {
                xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength1", SAPUploadCommon.toXMLString(p.getInternalLengthUc(1)));
                xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength2", SAPUploadCommon.toXMLString(p.getInternalLengthUc(2)));
                xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength4", SAPUploadCommon.toXMLString(p.getInternalLengthUc(4)));
            } else {
                xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "internalLength1", SAPUploadCommon.toXMLString(p.getInternalLength()));
            }
            xml.closeTag();
            xml.closeTag();
        }
        boolean isOptional = p.isOptional();
        String defaultDef = null;
        if (p.isImport()) {
            defaultDef = p.isScalar() ? p.getScalarDefaultDefinition() : p.getDataelementDefaultValue();
        }
        if (defaultDef != null && defaultDef.length() > 0) {
            isOptional = true;
            xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "defaultDefinition", defaultDef);
        }
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "direction", io);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "class", pclass);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "type", type);
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "optional", SAPUploadCommon.toXMLString(isOptional));
        xml.addTextTag("urn:sap-com:ifr:v2:metamodel", "basedOnDictionaryReference", SAPUploadCommon.toXMLString(basedOnDic));
        xml.closeTag();
        xml.closeTag();
    }

    private static int getLengthOfABAPType(String type, int unicode) {
        if (type.equals("I")) {
            return 4;
        }
        if (type.equals("F")) {
            return 8;
        }
        if (type.equals("D")) {
            return 8 * unicode;
        }
        if (type.equals("T")) {
            return 6 * unicode;
        }
        if (type.equals("g") || type.equalsIgnoreCase("STRING")) {
            return 0;
        }
        if (type.equals("y") || type.equalsIgnoreCase("XSTRING")) {
            return 0;
        }
        log.error("get length of unknown ABAP type: " + type);
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

