/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.sap.InvalidAKHException;
import com.sap.aii.upload.sap.SAPUploadFunction;
import com.sap.aii.upload.sap.SAPUploadIDoc;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKH;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKHNodeImpl;
import com.sap.aii.upload.sap.akhUpload.SAPUploadAKHPop;
import com.sap.aii.upload.sap.api.SAPUploadAKHNode;
import com.sap.aii.util.log.api.Logger;
import com.sap.mdi.AKHNode;
import com.sap.mdi.AKHNodes;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SAPUploadFactory {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadFactory == null ? (class$com$sap$aii$upload$sap$SAPUploadFactory = SAPUploadFactory.class$("com.sap.aii.upload.sap.SAPUploadFactory")) : class$com$sap$aii$upload$sap$SAPUploadFactory).getName());
    private static final int maxDepth = 3;
    public static final String OTHERS_NODE = "Others";
    private ObjectFactory bof;
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadFactory;

    public SAPUploadFactory(ObjectFactory bof) {
        this.bof = bof;
    }

    public SAPUploadAKH getAKH() throws InvalidAKHException {
        HashMap<String, SAPUploadAKHNode> nodeID2ReducedNode = new HashMap<String, SAPUploadAKHNode>();
        SAPUploadAKH sapUploadAKH = null;
        AKHNode akhRoot = null;
        SAPUploadAKHNode rootNode = null;
        try {
            sapUploadAKH = new SAPUploadAKH(nodeID2ReducedNode, this.bof.getConnection().getSystemID(), this.bof.getConnection().getClient(), this.bof.getSapRelease(), "");
            akhRoot = this.bof.getAKHRoot();
            rootNode = SAPUploadFactory.createSAPUploadAKHNode(null, akhRoot);
            sapUploadAKH.setRootNode(rootNode);
            nodeID2ReducedNode.put(rootNode.getID(), rootNode);
        }
        catch (MetaDataAccessException e) {
            sapUploadAKH.setRootNode(null);
            log.error("Can't create root node of akh.", (Throwable)e);
            throw new InvalidAKHException(InvalidAKHException.createMsg_CAN_NOT_BUILD_AKH());
        }
        try {
            log.debug("Creating akh.");
            SAPUploadFactory.addChildren(akhRoot.getChildren(), rootNode, 1, nodeID2ReducedNode);
            SAPUploadAKHNodeImpl othersNode = new SAPUploadAKHNodeImpl(rootNode, OTHERS_NODE, OTHERS_NODE, OTHERS_NODE, OTHERS_NODE);
            rootNode.addChild(othersNode);
            nodeID2ReducedNode.put(othersNode.getID(), othersNode);
        }
        catch (MetaDataAccessException e) {
            sapUploadAKH.setRootNode(null);
            log.error("", (Throwable)e);
            throw new InvalidAKHException(InvalidAKHException.createMsg_CAN_NOT_BUILD_AKH());
        }
        return sapUploadAKH;
    }

    public Map getAKHEoks() throws ConnectionException, UploadException {
        Map objectInfos = new SAPUploadFunction(this.bof).getObjectInfos("rfc");
        objectInfos.putAll(new SAPUploadIDoc(this.bof).getObjectInfos("idoc"));
        return objectInfos;
    }

    public static SAPUploadAKHPop createAKHPop(SAPUploadAKH akh, Map eoks, String nameFilter, Properties propertyFilter) throws ConnectionException, InvalidAKHException {
        if (akh == null) {
            throw new InvalidAKHException(InvalidAKHException.createMsg_NULL_VALUE_FOR_AKH());
        }
        if (eoks == null) {
            throw new InvalidAKHException(InvalidAKHException.createMsg_CAN_NOT_BUILD_AKH_POP());
        }
        if (propertyFilter != null && ((Hashtable)propertyFilter).isEmpty()) {
            propertyFilter = null;
        }
        if (nameFilter == null) {
            nameFilter = "*";
        }
        HashMap akhNodeID2eoks = new HashMap();
        log.debug("Filtering AKHEoks");
        Map filteredObjectInfos = SAPUploadFactory.filterObjectKeySet(eoks, nameFilter, propertyFilter);
        log.debug("Creating AKHPop from AKHEoks");
        akhNodeID2eoks.putAll(SAPUploadFactory.createAKHPopMapping(filteredObjectInfos));
        SAPUploadAKHPop akhPop = new SAPUploadAKHPop(akh, akhNodeID2eoks, akh.getSystemID(), akh.getClient(), akh.getSapRelease(), "");
        return akhPop;
    }

    private static Map createAKHPopMapping(Map eoks) {
        long startTime = System.currentTimeMillis();
        log.finest("Creating AKHPopMapping; timer started");
        HashMap newAkhNodeID2eoks = new HashMap();
        Iterator iter = eoks.keySet().iterator();
        while (iter.hasNext()) {
            Object objectKey = iter.next();
            Properties objectProperties = (Properties)eoks.get(objectKey);
            String akhNodeID = objectProperties.getProperty("akhNode");
            if (akhNodeID == null || akhNodeID.length() < 1) {
                SAPUploadFactory.addMapToMap(newAkhNodeID2eoks, OTHERS_NODE, objectKey, objectProperties);
                continue;
            }
            SAPUploadFactory.addMapToMap(newAkhNodeID2eoks, akhNodeID, objectKey, objectProperties);
        }
        log.finest("Creating of AKHPopMapping took " + (System.currentTimeMillis() - startTime) + " ms.");
        return newAkhNodeID2eoks;
    }

    private static void addMapToMap(Map mainMap, String mainKey, Object subMapKey, Object subMapValue) {
        if (mainMap == null || mainKey == null || subMapKey == null || subMapValue == null) {
            log.warning("addMapToMap was called with invalid parameters: (" + mainMap + ", " + mainKey + ", " + subMapKey + ", " + subMapValue + ") -> call will be ignored");
            return;
        }
        if (!mainMap.containsKey(mainKey)) {
            HashMap<Object, Object> newMapping = new HashMap<Object, Object>();
            newMapping.put(subMapKey, subMapValue);
            mainMap.put(mainKey, newMapping);
        } else {
            ((Map)mainMap.get(mainKey)).put(subMapKey, subMapValue);
        }
    }

    public static Map filterObjectKeySet(Map eoks, String nameFilter, Properties propertyFilter) {
        if (eoks == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        log.debug("Starting filtering Set");
        HashMap filteredEOKS = new HashMap();
        Iterator iter = eoks.keySet().iterator();
        while (iter.hasNext()) {
            SimpleUploadKey nextObjectKey = (SimpleUploadKey)iter.next();
            String objectName = nextObjectKey.getName();
            if (!nameFilter.equals("*") && nameFilter != null && !nameFilter.equals(objectName) && (!nameFilter.endsWith("*") || !objectName.startsWith(nameFilter.substring(0, nameFilter.length() - 1)))) continue;
            if (propertyFilter == null) {
                filteredEOKS.put(nextObjectKey, eoks.get(nextObjectKey));
                continue;
            }
            boolean addObject = true;
            Properties objectProperties = (Properties)eoks.get(nextObjectKey);
            Enumeration<?> filterNames = propertyFilter.propertyNames();
            while (filterNames.hasMoreElements()) {
                String nextFilterName = (String)filterNames.nextElement();
                String filterValue = propertyFilter.getProperty(nextFilterName);
                if (filterValue != null && !filterValue.equals("*")) {
                    String eoksValue = objectProperties.getProperty(nextFilterName);
                    if (!(eoksValue != null && (filterValue.equals(eoksValue) || filterValue.endsWith("*") && eoksValue.startsWith(filterValue.substring(0, filterValue.length() - 1))))) {
                        addObject = false;
                    }
                } else {
                    log.debug("Filter was null");
                }
                if (!addObject) continue;
                filteredEOKS.put(nextObjectKey, eoks.get(nextObjectKey));
            }
        }
        log.debug("Size of filtered enriched ObjectKeySet: " + filteredEOKS.keySet().size());
        log.debug("Finished filtering of enriched Set within " + (System.currentTimeMillis() - startTime) + " ms.");
        return filteredEOKS;
    }

    private static SAPUploadAKHNode createSAPUploadAKHNode(SAPUploadAKHNode parent, AKHNode akhNode) {
        return new SAPUploadAKHNodeImpl(parent, akhNode.getId(), akhNode.getDescription(), akhNode.getName(), akhNode.getFullName());
    }

    public static void addChildren(AKHNodes children, SAPUploadAKHNode parentNode, int depth, HashMap nodeID2ReducedNode) throws MetaDataAccessException {
        AKHNode child = children.getFirstChild();
        while (child != null) {
            if (depth <= 3) {
                SAPUploadAKHNode sapUploadChild = SAPUploadFactory.createSAPUploadAKHNode(parentNode, child);
                SAPUploadFactory.addChildren(child.getChildren(), sapUploadChild, depth + 1, nodeID2ReducedNode);
                nodeID2ReducedNode.put(sapUploadChild.getID(), sapUploadChild);
                parentNode.addChild(sapUploadChild);
            } else {
                SAPUploadFactory.addChildren(child.getChildren(), parentNode, depth + 1, nodeID2ReducedNode);
                nodeID2ReducedNode.put(child.getId(), parentNode);
            }
            child = children.getNextChild();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

