/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.sap.InternalHandler;
import com.sap.aii.upload.sap.SAPUploadCommon;
import com.sap.aii.upload.sap.SAPUploadException;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.DocuLink;
import com.sap.mdi.Documentation;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class SAPUploadDocu
extends SAPUploadCommon
implements InternalHandler {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadDocu == null ? (class$com$sap$aii$upload$sap$SAPUploadDocu = SAPUploadDocu.class$("com.sap.aii.upload.sap.SAPUploadDocu")) : class$com$sap$aii$upload$sap$SAPUploadDocu).getName());
    private static final String SAP_LINK_PREFIX = "SAPEVENT:DOCU_LINK/DS:";
    private static final String IFR_LINK_PREFIX = "./ifraccess?service=readtext";
    private static final String SERVICE_NAMESPACE = "namespace";
    private static final String SERVICE_TYPE = "type";
    private static final String SERVICE_NAME = "name";
    private static Set allowedLinkIDs = new HashSet();
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadDocu;

    public SAPUploadDocu(ObjectFactory of) {
        super(of);
    }

    public Map getObjectInfos(String type) {
        return new HashMap();
    }

    public void uploadObject(WorkingSet ws) throws NotFoundException, ConnectionException, UploadException, XMLException, ObjectFactoryException {
        SimpleUploadKey key = (SimpleUploadKey)ws.getKey();
        String name = key.getName();
        if (!key.getType().equals("docu")) {
            throw new NotFoundException((UploadKey)key);
        }
        if (!this.isDocuSupported()) {
            throw new NotFoundException((UploadKey)key);
        }
        int pos = name.indexOf(46);
        String docu_id = name.substring(0, pos);
        String docu_name = name.substring(pos + 1);
        log.fine("reading docu id=\"" + docu_id + "\" name=\"" + docu_name + "\"");
        Documentation doc = this.bof.getDocumentation(docu_id, docu_name, this.bof.getConnection().getLanguage());
        if (doc == null) {
            throw new NotFoundException((UploadKey)key);
        }
        this.addDocu(ws, doc);
    }

    private void addDocu(WorkingSet ws, Documentation doc) throws XMLException, MetaDataAccessException, UploadException {
        XMLStream xml = ws.getStream();
        Vector activeLinks = new Vector();
        String text = "";
        text = doc.getDocument();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "properties");
        this.addSourceProperties(ws);
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "definition");
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "links");
        if (ws.getUploadOptions().getLoadDocuRefs()) {
            int i = 0;
            while (i < activeLinks.size()) {
                DocuLink link = (DocuLink)activeLinks.get(i);
                xml.openTag("urn:sap-com:ifr:v2:metamodel", "link");
                if (this.bof.getDocumentation(link.getId(), link.getName()) != null) {
                    this.addLink(ws, "docu", link.getId() + "." + link.getName());
                }
                xml.closeTag();
                ++i;
            }
        }
        xml.closeTag();
        xml.openTag("urn:sap-com:ifr:v2:metamodel", "text");
        xml.addText(text);
        xml.closeTag();
        xml.closeTag();
    }

    private String replaceLinks(Documentation doc, List activeLinks) throws MetaDataAccessException, UploadException {
        String docu_link_prefix = "./ifraccess?service=readtext&type=" + "docu".toString();
        StringBuffer out = new StringBuffer();
        String in = doc.getDocument();
        DocuLink[] links = doc.getLinks().toArray(new DocuLink[0]);
        Arrays.sort(links, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DocuLink)o1).getPosition() - ((DocuLink)o2).getPosition();
            }

            public boolean equals(Object o1, Object o2) {
                return this.compare(o1, o2) == 0;
            }
        });
        int pos = 0;
        int i = 0;
        while (i < links.length) {
            DocuLink link = links[i];
            int link_start = link.getPosition();
            int link_end = link_start + link.getLength();
            String name = link.getId() + "." + link.getName();
            if (link_start < pos) {
                throw new SAPUploadException.IllegalDocuLink(pos, link_start, link_end);
            }
            if (allowedLinkIDs.contains(link.getId()) && this.bof.getDocumentation(link.getId(), link.getName()) != null) {
                log.fine("replacing link at (" + link_start + "-" + link_end + ") = \"" + in.substring(link_start, link_end) + "\" name=\"" + name + "\"");
                out.append(in.substring(pos, link_start));
                out.append(docu_link_prefix).append("&").append(SERVICE_NAME).append("=").append(name);
                activeLinks.add(link);
            } else {
                link_start = in.lastIndexOf("<", link_start);
                int text_start = in.indexOf(">", link_end) + 1;
                int text_end = in.indexOf("</A>", text_start);
                if (text_end < 0) {
                    text_end = in.indexOf("</a>", text_start);
                }
                if (link_start < pos || text_start < 1 || text_end < 0) {
                    throw new SAPUploadException.IllegalDocuLink(pos, link_start, link_end);
                }
                link_end = text_end + 4;
                String text = in.substring(text_start, text_end);
                log.fine("remove link at (" + link_start + "-" + link_end + ") = \"" + in.substring(link_start, link_end) + "\" text=\"" + text + "\"");
                out.append(in.substring(pos, link_start));
                out.append(text);
            }
            pos = link_end;
            ++i;
        }
        if (pos < in.length()) {
            out.append(in.substring(pos));
        }
        log.debug(out.toString());
        return out.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowedLinkIDs.add("FU");
        allowedLinkIDs.add("FX");
        allowedLinkIDs.add("TB");
        allowedLinkIDs.add("DE");
    }
}

