/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.core.UploadTools;
import com.sap.aii.upload.sap.MDITools;
import com.sap.aii.upload.sap.WorkingSet;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.mdi.Documentation;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDDomain;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDScalarField;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mdi.ddtypes.DDType;

abstract class SAPUploadCommon {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPUploadCommon == null ? (class$com$sap$aii$upload$sap$SAPUploadCommon = SAPUploadCommon.class$("com.sap.aii.upload.sap.SAPUploadCommon")) : class$com$sap$aii$upload$sap$SAPUploadCommon).getName());
    protected static final String NAMESPACE = "urn:sap-com:ifr:v2:metamodel";
    private static final String PROP_LOAD_DOCU = "com.sap.aii.upload.loadDocu";
    private boolean loadDocu;
    protected ObjectFactory bof;
    protected MDITools tool;
    private Boolean isUnicodeSupported = null;
    private Boolean isDocuSupported = null;
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPUploadCommon;

    protected SAPUploadCommon(ObjectFactory of) {
        this.bof = of;
        this.tool = MDITools.getInstance(of);
        this.loadDocu = Boolean.valueOf(AIIProperties.getInstance().getProperty(PROP_LOAD_DOCU, "true"));
    }

    protected boolean isUnicodeSupported() {
        if (this.isUnicodeSupported == null) {
            this.isUnicodeSupported = new Boolean(this.bof.isSupported("UC_LEN_SET"));
        }
        return this.isUnicodeSupported;
    }

    protected boolean isDocuSupported() {
        if (this.isDocuSupported == null) {
            this.isDocuSupported = new Boolean(this.bof.isSupported("DOCUMENTATION"));
        }
        return this.isDocuSupported;
    }

    protected String getLanguage() {
        return this.bof.getConnection().getLanguage();
    }

    protected static String toXMLString(boolean b) {
        return b ? "true" : "false";
    }

    protected static String toXMLString(int n) {
        return Integer.toString(n);
    }

    protected static String toXMLString(long n) {
        return Long.toString(n);
    }

    protected void addLink(WorkingSet ws, String type, String name) throws XMLException {
        SimpleUploadKey key = new SimpleUploadKey(type, name);
        UploadTools.addLink((XMLStream)ws.getStream(), (UploadKey)key);
        ws.getResult().addReference((UploadKey)key);
    }

    protected void addDescription(WorkingSet ws, String description) throws XMLException {
        XMLStream xml = ws.getStream();
        if (description.length() > 0) {
            xml.openTag(NAMESPACE, "description");
            xml.addAttr("language", this.getLanguage());
            xml.addText(description);
            xml.closeTag();
        }
    }

    protected void addDocumentation(WorkingSet ws, String id, String name) throws XMLException {
        if (this.isDocuSupported() && ws.getUploadOptions().getLoadDocuRefs() && this.loadDocu) {
            try {
                Documentation doc = this.bof.getDocumentation(id, name, this.bof.getConnection().getLanguage());
                if (doc != null) {
                    XMLStream xml = ws.getStream();
                    xml.openTag(NAMESPACE, "documentation");
                    this.addLink(ws, "docu", id + "." + name);
                    xml.closeTag();
                }
            }
            catch (MetaDataAccessException e) {
                // empty catch block
            }
        }
    }

    protected void addSourceProperties(WorkingSet ws) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.addTextTag(NAMESPACE, "sourceSystem", this.bof.getConnection().getSystemID());
        xml.addTextTag(NAMESPACE, "sourceClient", this.bof.getConnection().getClient());
    }

    protected void addUnicodeProperties(WorkingSet ws) throws XMLException {
        XMLStream xml = ws.getStream();
        String unicode = SAPUploadCommon.toXMLString(this.isUnicodeSupported());
        xml.addTextTag(NAMESPACE, "unicode1", SAPUploadCommon.toXMLString(true));
        xml.addTextTag(NAMESPACE, "unicode2", unicode);
    }

    protected void addDescriptor(WorkingSet ws, String description, String docuID, String docuName) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag(NAMESPACE, "descriptor");
        if (description != null && description.length() > 0) {
            this.addDescription(ws, description);
        }
        if (docuName != null && docuName.length() > 0) {
            this.addDocumentation(ws, docuID, docuName);
        }
        xml.closeTag();
    }

    protected void addDescriptor(WorkingSet ws, String description, String name) throws XMLException {
        XMLStream xml = ws.getStream();
        xml.openTag(NAMESPACE, "descriptor");
        if (description != null && description.length() > 0) {
            this.addDescription(ws, description);
        }
        if (name != null && name.length() > 0) {
            xml.addComment("Documentation for " + name + " missing");
        }
        xml.closeTag();
    }

    protected void addFieldProperties(WorkingSet ws, DDField f) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.openTag(NAMESPACE, "properties");
        if (f instanceof DDScalarField) {
            String checkTab;
            String refTab;
            DDScalarField sf = (DDScalarField)f;
            xml.addTextTag(NAMESPACE, "helpValuesSupported", SAPUploadCommon.toXMLString(sf.hasF4()));
            String refField = sf.getReffield();
            if (refField != null && refField.compareTo("") != 0) {
                xml.addTextTag(NAMESPACE, "referenceField", refField);
            }
            if ((refTab = sf.getReftable()) != null && refTab.compareTo("") != 0) {
                xml.addTextTag(NAMESPACE, "referenceTable", refTab);
            }
            if ((checkTab = sf.getChecktable()) != null && checkTab.compareTo("") != 0) {
                xml.addTextTag(NAMESPACE, "checkTable", checkTab);
            }
        }
        if (this.isUnicodeSupported()) {
            xml.addTextTag(NAMESPACE, "offset1", SAPUploadCommon.toXMLString(this.tool.getOffset(f, 1)));
            xml.addTextTag(NAMESPACE, "offset2", SAPUploadCommon.toXMLString(this.tool.getOffset(f, 2)));
        } else {
            xml.addTextTag(NAMESPACE, "offset1", SAPUploadCommon.toXMLString(f.getOffset()));
        }
        xml.closeTag();
    }

    protected void addField(WorkingSet ws, DDField f) throws XMLException, MetaDataAccessException {
        this.addFieldProperties(ws, f);
        this.addTypeDefinition(ws, (DDType)f.getChild(), null);
    }

    private void addBuiltInType(WorkingSet ws, DDBuiltInType bit) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.addTextTag(NAMESPACE, "type", bit.getDatatype());
        xml.addTextTag(NAMESPACE, "abapType", bit.getInttype());
        xml.addTextTag(NAMESPACE, "length", SAPUploadCommon.toXMLString(bit.getDDLeng()));
        if (this.isUnicodeSupported()) {
            xml.addTextTag(NAMESPACE, "internalLength1", SAPUploadCommon.toXMLString(this.tool.getInternalLength(bit, 1)));
            xml.addTextTag(NAMESPACE, "internalLength2", SAPUploadCommon.toXMLString(this.tool.getInternalLength(bit, 2)));
        } else {
            xml.addTextTag(NAMESPACE, "internalLength1", SAPUploadCommon.toXMLString(bit.getIntlen()));
        }
        xml.addTextTag(NAMESPACE, "decimals", SAPUploadCommon.toXMLString(bit.getDecimals()));
    }

    protected void addTypeDefinition(WorkingSet ws, DDType dt, String defaultDef) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        xml.openTag(NAMESPACE, "definition");
        this.addDataType(ws, dt);
        if (defaultDef != null) {
            xml.addTextTag(NAMESPACE, "defaultDefinition", defaultDef);
        }
        xml.closeTag();
    }

    protected void addDataType(WorkingSet ws, DDType dt) throws XMLException, MetaDataAccessException {
        XMLStream xml = ws.getStream();
        if (dt instanceof DDStructure || dt instanceof DDTabletype) {
            xml.openTag(NAMESPACE, "complexType");
            xml.addAttr("name", dt.getName());
            xml.addAttr("type", dt instanceof DDTabletype ? "tableType" : "structure");
            this.addLink(ws, "type", dt.getName());
            xml.closeTag();
        } else if (dt instanceof DDBuiltInType) {
            xml.openTag(NAMESPACE, "scalarType");
            xml.openTag(NAMESPACE, "definition");
            this.addBuiltInType(ws, (DDBuiltInType)dt);
            xml.closeTag();
            xml.closeTag();
        } else if (dt instanceof DDDataelement) {
            xml.openTag(NAMESPACE, "scalarType");
            DDDataelement de = (DDDataelement)dt;
            DDObject typeDef = de.getChild();
            if (typeDef instanceof DDDomain) {
                typeDef = typeDef.getChild();
            }
            if (!(typeDef instanceof DDBuiltInType)) {
                throw new InternalError("unexpected R/3 type definition in Dataelement \"" + de.getName() + "\": " + typeDef.getClass().getName());
            }
            DDBuiltInType bit = (DDBuiltInType)typeDef;
            xml.addAttr("name", de.getName());
            xml.openTag(NAMESPACE, "properties");
            xml.addTextTag(NAMESPACE, "helpValuesSupported", SAPUploadCommon.toXMLString(de.hasF4()));
            xml.addTextTag(NAMESPACE, "fixedValuesListDefined", SAPUploadCommon.toXMLString(de.isValexiSet()));
            xml.addTextTag(NAMESPACE, "mixedCaseSupported", SAPUploadCommon.toXMLString(de.isLowercaseSet()));
            xml.addTextTag(NAMESPACE, "signedNumber", SAPUploadCommon.toXMLString(de.isSignSet()));
            xml.closeTag();
            xml.openTag(NAMESPACE, "definition");
            this.addBuiltInType(ws, bit);
            xml.addTextTag(NAMESPACE, "outputLength", SAPUploadCommon.toXMLString(de.getOutputlen()));
            String conExit = de.getConvexit();
            if (conExit != null && conExit.compareTo("") != 0) {
                xml.addTextTag(NAMESPACE, "conversionExit", conExit);
            }
            xml.closeTag();
            xml.closeTag();
        } else {
            throw new InternalError("unknown R/3 Type Object " + dt.getClass().getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

