/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import java.io.Serializable;

public class SAPConnectionData
implements Serializable {
    private static final long serialVersionUID = 42L;
    private boolean loadBalancing;
    private String server;
    private String group;
    private String r3name;
    private String client;
    private String sysnr;
    private String connectionID;
    private String connectionName;

    public SAPConnectionData(String server, String group, String r3name, String client) {
        this.loadBalancing = true;
        this.server = server != null ? server : "";
        this.group = group != null ? group : "";
        this.r3name = r3name != null ? r3name : "";
        this.client = client != null ? client : "";
        this.connectionID = this.server + ":" + this.r3name + ":" + this.client;
        this.connectionName = this.r3name + " (client=" + this.client + ")";
    }

    public SAPConnectionData(String server, String sysnr, String client) {
        this.loadBalancing = false;
        this.server = server != null ? server : "";
        this.sysnr = sysnr != null ? sysnr : "";
        this.client = client != null ? client : "";
        this.connectionID = server + ":" + sysnr + ":" + client;
        this.connectionName = server + " (system=" + sysnr + ", client=" + client + ")";
    }

    public String getR3Name() {
        return this.r3name;
    }

    public String getServer() {
        return this.server;
    }

    public String getClient() {
        return this.client;
    }

    public String getGroup() {
        return this.group;
    }

    public String getSystemNr() {
        return this.sysnr;
    }

    public boolean useLoadBalancing() {
        return this.loadBalancing;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String toString() {
        String information = "<r3server: " + this.server + "; r3client: " + this.client;
        if (this.group != null || this.r3name != null) {
            information = information + "; r3group: " + this.group + "; r3name: " + this.r3name;
        }
        if (this.sysnr != null) {
            information = information + "; r3sysnr: " + this.sysnr;
        }
        information = information + ">";
        return information;
    }
}

