/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.LoginException;
import com.sap.aii.upload.sap.SAPConnectionData;
import com.sap.aii.upload.sap.SAPConnectionException;
import com.sap.aii.upload.sap.SAPLoginData;
import com.sap.aii.upload.sap.SAPLoginException;
import com.sap.aii.util.log.api.Logger;
import com.sap.mw.jco.JCO;

public class SAPConnection {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$SAPConnection == null ? (class$com$sap$aii$upload$sap$SAPConnection = SAPConnection.class$("com.sap.aii.upload.sap.SAPConnection")) : class$com$sap$aii$upload$sap$SAPConnection).getName());
    private SAPConnectionData connectData;
    private SAPLoginData loginData;
    JCO.Client jcoClient;
    private boolean closeClient;
    static /* synthetic */ Class class$com$sap$aii$upload$sap$SAPConnection;

    public SAPConnection(SAPConnectionData connect, SAPLoginData login) throws ConnectionException {
        this.connectData = connect;
        this.loginData = login;
        this.jcoClient = null;
        this.connect();
    }

    public SAPConnection(JCO.Client client) throws ConnectionException {
        if (!client.isAlive()) {
            log.debug("starting with dead client - calling connect()");
            client.connect();
            this.closeClient = true;
        } else {
            log.debug("starting with open client");
            this.closeClient = false;
        }
        JCO.Attributes attr = client.getAttributes();
        this.connectData = new SAPConnectionData(attr.getPartnerHost(), attr.getSystemNumber(), attr.getClient());
        this.loginData = new SAPLoginData(attr.getUser(), "***");
        this.jcoClient = client;
    }

    private void connect() throws ConnectionException {
        if (this.jcoClient == null) {
            if (this.connectData.useLoadBalancing()) {
                log.info("connecting to system " + this.connectData.getConnectionName() + " via JCo");
                this.jcoClient = JCO.createClient((String)this.connectData.getClient(), (String)this.loginData.getUser(), (String)this.loginData.getPassword(), (String)this.loginData.getLanguage().toString(), (String)this.connectData.getServer(), (String)this.connectData.getR3Name(), (String)this.connectData.getGroup());
            } else {
                log.info("connecting to system " + this.connectData.getConnectionName() + " via JCo");
                this.jcoClient = JCO.createClient((String)this.connectData.getClient(), (String)this.loginData.getUser(), (String)this.loginData.getPassword(), (String)this.loginData.getLanguage().toString(), (String)this.connectData.getServer(), (String)this.connectData.getSystemNr());
            }
            try {
                this.jcoClient.connect();
            }
            catch (JCO.Exception e) {
                int group = e.getGroup();
                String key = e.getKey();
                log.error("JCO-Exception (group=" + group + ", key=" + key + ")", (Throwable)e);
                if (group == 103) {
                    String msg = e.getMessage();
                    if (msg.startsWith("Name or password is incorrect")) {
                        throw new LoginException.WrongPassword();
                    }
                    if (msg.startsWith("User is locked")) {
                        throw new SAPLoginException.UserLocked(this.loginData.getUser());
                    }
                    if (msg.startsWith("User not authorized")) {
                        throw new LoginException.UserAuth();
                    }
                    throw new LoginException.LoginFailed((Throwable)e);
                }
                if (group == 102) {
                    throw new SAPConnectionException.ConnectFailed(this.connectData.getConnectionName(), (Throwable)e);
                }
                throw e;
            }
            this.closeClient = true;
        }
    }

    private synchronized void disconnect() {
        if (this.jcoClient != null) {
            log.info("disconnecting from system " + this.connectData.getConnectionName());
            this.jcoClient.disconnect();
            this.jcoClient = null;
        }
    }

    public synchronized void close() {
        if (this.closeClient) {
            this.disconnect();
        }
    }

    public void finalize() {
        this.close();
    }

    public void reset() {
        this.jcoClient.reset();
    }

    public JCO.Client getJCoClient() {
        return this.jcoClient;
    }

    public SAPConnectionData getConnectionData() {
        return this.connectData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

