/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.sap;

import com.sap.aii.util.log.api.Logger;
import com.sap.mdi.IDocMessageType;
import com.sap.mdi.IDocMessageTypes;
import com.sap.mdi.IDocSegment;
import com.sap.mdi.IDocSegmentField;
import com.sap.mdi.IDocSegments;
import com.sap.mdi.IDocType;
import com.sap.mdi.IDocTypeExtension;
import com.sap.mdi.IDocTypes;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDDomain;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDStructure;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class MDITools {
    public static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$sap$MDITools == null ? (class$com$sap$aii$upload$sap$MDITools = MDITools.class$("com.sap.aii.upload.sap.MDITools")) : class$com$sap$aii$upload$sap$MDITools).getName());
    public static final String DOCU_ID_FUNCTION = "FU";
    public static final String DOCU_ID_EXCEPTION = "FX";
    public static final String DOCU_ID_DATAELEMENT = "DE";
    public static final String DOCU_ID_TABLE = "TB";
    public static final String MDI_FEATURE_AKH = "AKH";
    public static final String MDI_FEATURE_RFM_COMP = "RFM_DEVCLASS_COMPONENT_ID";
    public static final String MDI_FEATURE_DOCU = "DOCUMENTATION";
    public static final String MDI_FEATURE_IDOC_MSG = "IDOC_MESSAGE_TYPES";
    public static final String MDI_FEATURE_UNICODE = "UC_LEN_SET";
    public static final String MDI_FEATURE_RELEASED = "RFM_RELEASED";
    public static final int MDI_RELEASED_NO = 0;
    public static final int MDI_RELEASED_INTERNAL = 1;
    public static final int MDI_RELEASED_EXTERNAL = 2;
    public static final int MDI_RELEASED_OBSOLETE = 3;
    private static Map toolMap = new WeakHashMap();
    private ObjectFactory of;
    private DDFactory ddf;
    private Map segments = new HashMap();
    private Set typeSet = new HashSet();
    private IDocMessageTypes msgTypes = null;
    private int msgTypesPos = 0;
    static /* synthetic */ Class class$com$sap$aii$upload$sap$MDITools;

    public static MDITools getInstance(ObjectFactory of) {
        if (toolMap.containsKey(of)) {
            return (MDITools)toolMap.get(of);
        }
        MDITools tool = new MDITools(of);
        toolMap.put(of, tool);
        return tool;
    }

    private MDITools(ObjectFactory of) {
        this.of = of;
        this.ddf = of.getDDFactory();
    }

    public int getOffset(DDField f, int unicode) {
        int n;
        this.ddf.setUcLength(unicode);
        try {
            f = (DDField)this.getAgain((DDObject)f);
            n = f.getOffset();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ddf.setUcLength(1);
            throw throwable;
        }
        this.ddf.setUcLength(1);
        return n;
    }

    public int getInternalLength(DDBuiltInType bit, int unicode) {
        int n;
        this.ddf.setUcLength(unicode);
        try {
            bit = (DDBuiltInType)this.getAgain((DDObject)bit);
            n = bit.getIntlen();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ddf.setUcLength(1);
            throw throwable;
        }
        this.ddf.setUcLength(1);
        return n;
    }

    public int getInternalLength(DDStructure s, int unicode) {
        int n;
        this.ddf.setUcLength(unicode);
        try {
            s = (DDStructure)this.getAgain((DDObject)s);
            n = s.getStructureLength();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ddf.setUcLength(1);
            throw throwable;
        }
        this.ddf.setUcLength(1);
        return n;
    }

    private DDObject getAgain(DDObject obj) {
        if (obj instanceof DDField) {
            return this.ddf.getDDObject(obj.getParent().getName(), obj.getName());
        }
        if (obj instanceof DDBuiltInType || obj instanceof DDDomain) {
            return this.getAgain(obj.getParent()).getChild();
        }
        return this.ddf.getDDObject(obj.getName());
    }

    public int getInternalLength(Rfm r, RfmParameter p, int unicode) throws MetaDataAccessException {
        int n;
        this.ddf.setUcLength(unicode);
        try {
            n = r.getRfmParameter(p.getName()).getInternalLength();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ddf.setUcLength(1);
            throw throwable;
        }
        this.ddf.setUcLength(1);
        return n;
    }

    public void addSegmentToBuffer(IDocSegment seg) {
        this.segments.put(seg.getName(), seg);
    }

    private void addSegments(IDocSegments segs, Map target) {
        if (segs == null) {
            return;
        }
        int j = 0;
        while (j < segs.getSize()) {
            IDocSegment seg = segs.getIDocSegment(j);
            target.put(seg.getName(), seg);
            this.addSegments(seg.getChildren(), target);
            ++j;
        }
    }

    public IDocSegment getIDocSegment(String name) throws MetaDataAccessException {
        if (this.msgTypes == null) {
            this.msgTypes = this.of.getIDocMessageTypes();
        }
        if (this.segments.containsKey(name)) {
            return (IDocSegment)this.segments.get(name);
        }
        HashMap work = new HashMap();
        while (this.msgTypesPos < this.msgTypes.getSize()) {
            IDocMessageType msg = this.msgTypes.getIDocMessageType(this.msgTypesPos);
            ++this.msgTypesPos;
            IDocTypes types = msg.getIDocTypes();
            int i = 0;
            while (i < types.getSize()) {
                IDocType type = types.getIDocType(i);
                if (!this.typeSet.contains(type.getName())) {
                    log.finest("buffering segs from type " + type.getName());
                    this.addSegments(type.getIDocSegments(), work);
                    this.typeSet.add(type.getName());
                }
                ++i;
            }
            this.segments.putAll(work);
            if (work.containsKey(name)) {
                return (IDocSegment)work.get(name);
            }
            work.clear();
        }
        return null;
    }

    public int getDecimals(IDocSegmentField sf) {
        DDDataelement de = (DDDataelement)this.ddf.getDDObject(sf.getDataElementName());
        if (de == null) {
            log.error("unknown dataelement \"" + sf.getDataElementName() + "\" in IDocSegmentField");
            return 0;
        }
        DDBuiltInType bit = (DDBuiltInType)de.getChild();
        return bit.getDecimals();
    }

    public IDocTypeExtension getIDocTypeExtension(String name) throws MetaDataAccessException {
        IDocMessageTypes msgs = this.of.getIDocMessageTypes();
        int i = 0;
        while (i < msgs.getSize()) {
            IDocTypes types = msgs.getIDocMessageType(i).getIDocTypes();
            int j = 0;
            while (j < types.getSize()) {
                IDocTypeExtension ext = types.getIDocType(j).getIDocTypeExtensions().getIDocTypeExtension(name);
                if (ext != null) {
                    return ext;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

