/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.library.creation;

import com.tssap.j2ee.library.creation.IJ2EELibraryProjectCreation;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ext.ModelPlugin;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.j2ee.ui.creation.internal.AbstractJ2eeJavaProjectCreation;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.ui.wizard.J2eeProjectJavaPage;
import com.tssap.j2ee.util.core.CompConstants;
import com.tssap.j2ee.util.file.FileUtil;
import com.tssap.j2ee.util.jdt.JDTClasspathUtil;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class J2EELibraryProjectCreation
extends AbstractJ2eeJavaProjectCreation
implements IJ2EELibraryProjectCreation {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$library$creation$J2EELibraryProjectCreation == null ? (class$com$tssap$j2ee$library$creation$J2EELibraryProjectCreation = J2EELibraryProjectCreation.class$("com.tssap.j2ee.library.creation.J2EELibraryProjectCreation")) : class$com$tssap$j2ee$library$creation$J2EELibraryProjectCreation));
    private static final String PLACEHOLDER_COMPONENT_NAME = "$COMPONENT_NAME$";
    private static final String PLACEHOLDER_SOFTWARE_TYPE = "$SOFTWARE_TYPE$";
    private static final String DEFAULT_LIBRARY_SOFTWARE_TYPE = "library";
    private static final String DEFAULT_INTERFACE_SOFTWARE_TYPE = "primary-interface";
    public static final String DC_TYPE = "J2EE Server Component";
    public static final String DC_SUBTYPE_INTERFACE = "Interface";
    static /* synthetic */ Class class$com$tssap$j2ee$library$creation$J2EELibraryProjectCreation;

    protected void doCreateProject(IProgressMonitor monitor) throws CoreException, J2eeCreateException, InvocationTargetException, InterruptedException {
        String METHOD = "doCreateProject()";
        try {
            monitor.beginTask("Project creation ... ", 6);
            IRunnableWithProgress jr = this.getJavaRunnable();
            if (jr == null) {
                jr = new J2eeProjectJavaPage(this.getNewProject(), this.getLocation()).getRunnable();
            }
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(jr);
            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProject projectHandle = this.getNewProject();
            if (!projectHandle.isOpen()) {
                projectHandle.open(null);
            }
            ProjectUtil.updateProjectNatures((IProject)projectHandle, (String)"com.tssap.j2ee.library.libraryNature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JDTClasspathUtil.removeSourceFolderEntries((IProject)this.getNewProject());
            IJ2EELibraryProject libraryProject = J2eeProjectManager.getLibraryProject((String)this.getNewProject().getName());
            if (libraryProject == null) {
                TRACER.error(METHOD, "New library-project not found in model");
                throw new J2eeCreateException();
            }
            if (this.getCompWizard() == null) {
                IFile file = libraryProject.getProject().getFile("server/provider.xml");
                String[] p = new String[]{PLACEHOLDER_COMPONENT_NAME};
                String[] pv = new String[]{libraryProject.getProject().getName()};
                FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/server/provider.xml", (IFile)file, (String[])p, (String[])pv);
            }
            monitor.worked(1);
            if (this.getCompWizard() != null) {
                this.setArchiveInfo((IRepresentArchive)libraryProject, "sda", CompConstants.getDcLocationLibrary((String)this.getCompWizard().getBuildVariant()));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected void doCreateProject2() {
        String METHOD = "doCreateProject2()";
        IJ2EELibraryProject libraryProject = J2eeProjectManager.getLibraryProject((String)this.getNewProject().getName());
        IFile file = libraryProject.getProject().getFile("META-INF/sda-dd.xml");
        String[] p = new String[]{PLACEHOLDER_SOFTWARE_TYPE};
        String[] pv = new String[]{DEFAULT_LIBRARY_SOFTWARE_TYPE};
        if (this.getCompWizard() != null && this.getCompWizard().getDcType().equals(DC_TYPE) && this.getCompWizard().getDcSubType().equals(DC_SUBTYPE_INTERFACE)) {
            pv = new String[]{DEFAULT_INTERFACE_SOFTWARE_TYPE};
        }
        FileUtil.copyTemplate((Plugin)ModelPlugin.getDefault(), (String)"templates/META-INF/sda-dd.xml", (IFile)file, (String[])p, (String[])pv);
        super.doCreateProject2();
    }

    protected Properties getComponentProperties() {
        Properties p = new Properties();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new String[]{"defLib", "compilation", "", ""});
        ((Hashtable)p).put("DCPublicParts", list);
        String archiveName = CompUtil.getCompArchiveName((String)this.getCompWizard().getName(), (String)this.getCompWizard().getVendor());
        list = new ArrayList();
        list.add(new String[]{"defLib", archiveName, "SERVER_COMPONENTS"});
        ((Hashtable)p).put("DCPublicPartEntity", list);
        list = new ArrayList();
        list.add("META-INF");
        list.add("server");
        ((Hashtable)p).put("DCSourceFolder", list);
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

