/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.library;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.j2ee.model.ext.sda.dd.ISDA;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.j2ee.util.portal.PortalFactory;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibSearcher;
import com.tssap.tools.addlib.ILibraryProjectAddLib;
import com.tssap.tools.addlib.ILibraryProjectSupport;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class LibrarySupport
implements ILibraryProjectSupport {
    private MyAddLibSearcher myAddibSearcher;

    public IAddLibSearcher getAddLibSearcher() {
        if (this.myAddibSearcher == null) {
            this.myAddibSearcher = new MyAddLibSearcher();
        }
        return this.myAddibSearcher;
    }

    public boolean isLibraryProject(IProject project) {
        return J2eeProjectManager.getLibraryProject((String)project.getName()) != null;
    }

    class LibProjectAddLib
    extends AddLibDefinition
    implements ILibraryProjectAddLib {
        private static final String INTERFACE_SOFTWARE_TYPE = "primary-interface";
        private IJ2EELibraryProject project;
        private int subtype;

        public LibProjectAddLib(IJ2EELibraryProject prj, String name, String vendor) {
            super(vendor, name);
            this.project = prj;
            ISDA sda = XMLParserHelper.getSDAForProject((IProject)prj.getProject());
            this.subtype = sda != null && INTERFACE_SOFTWARE_TYPE.equals(sda.getSoftwareType().getValue()) ? 3 : 2;
        }

        public IPath[] getClassPathJars() {
            return new IPath[0];
        }

        public IProject getLibraryProject() {
            return this.project.getProject();
        }

        public int getAddLibType() {
            return 1;
        }

        public int getSubType() {
            return this.subtype;
        }
    }

    public class MyAddLibSearcher
    implements IAddLibSearcher {
        public static final String NAME = "Library Project Searcher";

        public String getName() {
            return NAME;
        }

        public IAddLib[] searchAddLibs() {
            IJ2EELibraryProject[] libPrjs = J2eeProjectManager.getLibraryProjects();
            ArrayList<IAddLib> retList = new ArrayList<IAddLib>(libPrjs.length);
            int i = 0;
            while (i < libPrjs.length) {
                IAddLib addLib = this.createAddLib(libPrjs[i]);
                if (addLib != null) {
                    retList.add(addLib);
                }
                ++i;
            }
            return retList.toArray(new IAddLib[retList.size()]);
        }

        private IAddLib createAddLib(IJ2EELibraryProject project) {
            String compVendor;
            String compName;
            LibProjectAddLib ret = null;
            if (J2eeProjectManager.isComponentProject((IJ2eeProject)project)) {
                IComp comp = PortalFactory.getComp();
                compName = comp.getName(project.getProject());
                compVendor = comp.getVendor(project.getProject());
            } else {
                IProviderDescriptor provDescr = XMLParserHelper.getProviderDescriptorForProject((IProject)project.getProject());
                compName = provDescr.getComponentName().getValue();
                compVendor = provDescr.getProviderName().getValue();
            }
            if (compName != null && compName.trim().length() != 0 && compVendor != null && compVendor.trim().length() != 0) {
                ret = new LibProjectAddLib(project, compName, compVendor);
            }
            return ret;
        }

        public boolean isUpToDate() {
            return true;
        }

        public void reset() {
        }
    }
}

