/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web.utils;

import com.tssap.j2ee.core.web.GenericServletCreationOptions;
import com.tssap.j2ee.core.web.HttpServletCreationOptions;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.web.WebImplPlugin;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateEngine;
import com.tssap.selena.cmf.templates.Templates;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;

public class WebTemplatesSupport {
    private static final String WEB_TEMPLATES = "com.tssap.j2ee.core.web.impl.web";
    private static final String SERVLET_CLASS_TEMPLATE = "Generic Servlet";
    private static final String HTTP_SERVLET_CLASS_TEMPLATE = "HTTP Servlet";
    private static final String SERVLET_CLASS_PROPERTY = "servletName";
    private static final String PREFIX_GENERATE_PROPERTY = "generate";
    private static final String GENERATE_GET_PROPERTY = "generateGet";
    private static final String GENERATE_POST_PROPERTY = "generatePost";
    private static final String GENERATE_HEAD_PROPERTY = "generateHead";
    private static final String GENERATE_PUT_PROPERTY = "generatePut";
    private static final String GENERATE_DELETE_PROPERTY = "generateDelete";
    private static final String GENERATE_OPTIONS_PROPERTY = "generateOptions";
    private static final String GENERATE_TRACE_PROPERTY = "generateTrace";
    private static final String GENERATE_SERVICE_PROPERTY = "generateService";
    private static final String GENERATE_INIT_PROPERTY = "generateInit";
    private static final String GENERATE_DESTROY_PROPERTY = "generateDestroy";
    private static final String SINGLE_THREADED_PROPERTY = "singleThreaded";

    public static void createGenericServletClass(IPackageFragment location, String servletClass, GenericServletCreationOptions options, IProgressMonitor monitor) throws CoreException {
        ITemplate template = WebTemplatesSupport.findTemplate(SERVLET_CLASS_TEMPLATE);
        WebTemplatesSupport.copyParameter(template, servletClass, SERVLET_CLASS_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateInit(), GENERATE_INIT_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDestroy(), GENERATE_DESTROY_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isSingleThreaded(), SINGLE_THREADED_PROPERTY);
        WebTemplatesSupport.apply(template, location, monitor);
    }

    public static void createHttpServletClass(IPackageFragment location, String servletClass, HttpServletCreationOptions options, IProgressMonitor monitor) throws CoreException {
        ITemplate template = WebTemplatesSupport.findTemplate(HTTP_SERVLET_CLASS_TEMPLATE);
        WebTemplatesSupport.copyParameter(template, servletClass, SERVLET_CLASS_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoGet(), GENERATE_GET_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoPost(), GENERATE_POST_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoHead(), GENERATE_HEAD_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoPut(), GENERATE_PUT_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoDelete(), GENERATE_DELETE_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoOptions(), GENERATE_OPTIONS_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDoTrace(), GENERATE_TRACE_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateService(), GENERATE_SERVICE_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateInit(), GENERATE_INIT_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isCreateDestroy(), GENERATE_DESTROY_PROPERTY);
        WebTemplatesSupport.copyBooleanParameter(template, options.isSingleThreaded(), SINGLE_THREADED_PROPERTY);
        WebTemplatesSupport.apply(template, location, monitor);
    }

    public static void createClass(IPackageFragment location, String name, String baseClass, String intf, IProgressMonitor monitor) throws CoreException {
        if ("".equals(baseClass)) {
            baseClass = null;
        }
        JDTUtils.createType((IPackageFragment)location, (String)name, (String)baseClass, (String[])new String[]{intf}, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
    }

    protected static ITemplate findTemplate(String name) throws CoreException {
        return WebTemplatesSupport.findTemplate(WEB_TEMPLATES, name);
    }

    public static ITemplate findTemplate(String category, String name) throws CoreException {
        ITemplateEngine engine = Templates.getTemplateEngine();
        if (engine != null) {
            ITemplate[] templates = engine.getTemplates();
            int i = 0;
            while (i < templates.length) {
                if (name.equals(templates[i].getName())) {
                    return templates[i];
                }
                ++i;
            }
        }
        String msg = "Template [" + name + "] not found in category [" + category + "]";
        throw new CoreException((IStatus)new Status(4, WebImplPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, msg, null));
    }

    public static Object copyParameter(ITemplate template, String parameterValue, String parameterName) {
        if ("".equals(parameterValue)) {
            parameterValue = null;
        }
        if (parameterValue != null) {
            template.setVariableValue(parameterName, (Object)parameterValue);
        }
        return parameterValue;
    }

    private static void copyBooleanParameter(ITemplate template, boolean b, String property) {
        template.setVariableValue(property, (Object)new Boolean(b));
    }

    protected static void apply(ITemplate template, Object location, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        template.apply(new Object[]{location}, monitor);
    }
}

