/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web.refactoring;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.refactoring.IOccurrence;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrenceCreator;
import com.tssap.j2ee.core.utils.refactoring.IResourceOccurrences;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.webapp.AssembledInfoFinder;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.j2ee.internal.core.web.refactoring.WebAppResourceOccurrencesImpl;
import org.eclipse.core.resources.IFile;

public abstract class WebElementRefactorer
extends Refactorer {
    private SourceWebElement mySource;
    private String myNewName;

    public WebElementRefactorer(SourceWebElement element, String newName) {
        this.mySource = element;
        String packageName = element.getType().getPackageFragment().getElementName();
        this.myNewName = packageName.length() == 0 ? newName : packageName + '.' + newName;
    }

    protected void doCreateResourceOccurrences() throws IllegalArgumentException {
        super.doCreateResourceOccurrences();
        DescriptorEntity[] assembled = AssembledInfoFinder.findAssembledWebObjects((IWebElement)this.mySource, (boolean)false);
        if (assembled != null && assembled.length > 0) {
            int i = 0;
            while (i < assembled.length) {
                WebApp webApp = WebAppResourceOccurrencesImpl.getWebApp(assembled[i]);
                IResourceOccurrences occurrences = this.getOccurrences(webApp.getFile(), WebElementRefactorer.getCreator(webApp));
                occurrences.addOccurrence(this.createOccurrence(assembled[i], webApp, this.myNewName));
                ++i;
            }
        }
    }

    protected abstract IOccurrence createOccurrence(DescriptorEntity var1, WebApp var2, String var3);

    private static final IResourceOccurrenceCreator getCreator(final WebApp webApp) {
        return new IResourceOccurrenceCreator(){

            public IResourceOccurrences createResourceOccurrence(IFile resource) throws IllegalArgumentException {
                if (!webApp.getFile().equals((Object)resource)) {
                    throw new IllegalArgumentException("This is not an webapp file");
                }
                return new WebAppResourceOccurrencesImpl(webApp);
            }
        };
    }
}

