/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.IProjectDependencyListener;
import com.tssap.j2ee.core.utils.ProjectDeltaUtils;
import com.tssap.j2ee.core.utils.ProjectDependencyChangeEvent;
import com.tssap.j2ee.core.utils.ProjectDependencyDeltaInfo;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.web.JSPFilesCache;
import com.tssap.j2ee.internal.core.web.WebImplPlugin;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class WebResourceChangedListener
implements IResourceChangeListener,
IProjectDependencyListener {
    private IResourceDeltaVisitor myDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    if (ProjectDeltaUtils.isProjectBeingOpened((IResourceDelta)delta)) {
                        return ((IProject)delta.getResource()).getReferencingProjects().length > 0;
                    }
                    if (ProjectDeltaUtils.isProjectBeingClosed((IResourceDelta)delta)) {
                        WebResourceChangedListener.this.myProjectsAboutToBeClosed.add(delta.getResource());
                        return false;
                    }
                    return true;
                }
                case 2: {
                    if (!JSPFilesCache.isValidJSPLocation(delta.getResource())) {
                        return false;
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 2) {
                        // empty if block
                    }
                    return true;
                }
                case 1: {
                    if (!WebResourceChangedListener.this.processFileModification(delta)) break;
                    WebResourceChangedListener.this.myAffectedProjects.add(delta.getResource().getProject());
                    WebResourceChangedListener.this.myAffectedProjects.addAll(UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(delta.getResource().getProject()));
                }
            }
            return false;
        }
    };
    private LinkedList myProjectsAboutToBeClosed = new LinkedList();
    private HashSet myAffectedProjects = new HashSet();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            try {
                block9: {
                    block8: {
                        if (event == null || event.getDelta() == null) break block8;
                        if (event.getType() == 1) break block9;
                    }
                    Object var4_2 = null;
                    this.flushJSPDeltas();
                    return;
                }
                event.getDelta().accept(this.myDeltaVisitor);
            }
            catch (CoreException resourceException) {
                resourceException.printStackTrace();
                Object var4_4 = null;
                this.flushJSPDeltas();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.flushJSPDeltas();
            throw throwable;
        }
        Object var4_3 = null;
        this.flushJSPDeltas();
    }

    private void flushJSPDeltas() {
        try {
            Iterator it = this.myAffectedProjects.iterator();
            while (it.hasNext()) {
                WebProject webProject;
                IProject nextAffected = (IProject)it.next();
                if (this.myProjectsAboutToBeClosed.contains(nextAffected) || (webProject = WebProject.getInstance((IProject)nextAffected)) == null || !(webProject instanceof WebProjectImpl)) continue;
                ((WebProjectImpl)webProject).flushJSPDelta();
            }
            Object var5_4 = null;
            this.myProjectsAboutToBeClosed = new LinkedList();
            this.myAffectedProjects = new HashSet();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.myProjectsAboutToBeClosed = new LinkedList();
            this.myAffectedProjects = new HashSet();
            throw throwable;
        }
    }

    private JSPFilesCache getCache() {
        return WebImplPlugin.getDefault().getJSPFilesCache();
    }

    public void projectDependencyChanged(ProjectDependencyChangeEvent evt) {
        try {
            Iterator it = evt.projects();
            while (it.hasNext()) {
                IProject next = (IProject)it.next();
                ProjectDependencyDeltaInfo info = evt.getProjectDependencyDeltaInfo(next);
                Collection filesForNextOnly = this.getCache().getFilesForProjectOnly(next);
                HashSet addedDependingProjects = info.getAddedDependencies();
                Iterator dependingIt = addedDependingProjects.iterator();
                while (dependingIt.hasNext()) {
                    IProject nextDependency = (IProject)dependingIt.next();
                    if (!this.getCache().hasAllFilesForProject(nextDependency)) continue;
                    this.myAffectedProjects.add(nextDependency);
                    this.getCache().filesAddedToProject(nextDependency, filesForNextOnly);
                }
                HashSet removedDependingProjects = info.getRemovedDependencies();
                Iterator dependingIt2 = removedDependingProjects.iterator();
                while (dependingIt2.hasNext()) {
                    IProject nextDependency = (IProject)dependingIt2.next();
                    if (!this.getCache().hasAllFilesForProject(nextDependency)) continue;
                    this.myAffectedProjects.add(nextDependency);
                    this.getCache().filesRemovedFromProject(nextDependency, filesForNextOnly);
                }
            }
            Object var12_11 = null;
            this.flushJSPDeltas();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.flushJSPDeltas();
            throw throwable;
        }
    }

    private boolean processFileModification(IResourceDelta fileDelta) {
        IFile file = (IFile)fileDelta.getResource();
        if (!JSPFilesCache.isJSPFile(file)) {
            return false;
        }
        JSPFilesCache cache = this.getCache();
        switch (fileDelta.getKind()) {
            case 1: {
                cache.fileAdded(file);
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                cache.fileRemoved(file);
                return true;
            }
        }
        throw new IllegalArgumentException("Strange delta");
    }
}

