/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.AbstractJ2eeProject;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.utils.IDispatchSessionListener;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.GenericServletCreationOptions;
import com.tssap.j2ee.core.web.HttpServletCreationOptions;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.IWebElementDelta;
import com.tssap.j2ee.core.web.IWebModelListener;
import com.tssap.j2ee.core.web.WebModelChangedEvent;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.ejb.util.AutoRefreshableTypeHierarchy;
import com.tssap.j2ee.internal.core.ejb.util.DetailedHierarchyChangedEvent;
import com.tssap.j2ee.internal.core.ejb.util.HierarchyHolder;
import com.tssap.j2ee.internal.core.ejb.util.IDetailedHierarchyChangedListener;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.web.FilterImpl;
import com.tssap.j2ee.internal.core.web.HttpSessionActivationListenerImpl;
import com.tssap.j2ee.internal.core.web.HttpSessionAttributeListenerImpl;
import com.tssap.j2ee.internal.core.web.HttpSessionBindingListenerImpl;
import com.tssap.j2ee.internal.core.web.HttpSessionListenerImpl;
import com.tssap.j2ee.internal.core.web.JSPImpl;
import com.tssap.j2ee.internal.core.web.ServletContextAttributeListenerImpl;
import com.tssap.j2ee.internal.core.web.ServletContextListenerImpl;
import com.tssap.j2ee.internal.core.web.ServletImpl;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.j2ee.internal.core.web.WebElement;
import com.tssap.j2ee.internal.core.web.WebElementDelta;
import com.tssap.j2ee.internal.core.web.WebImplPlugin;
import com.tssap.j2ee.internal.core.web.utils.WebTemplatesSupport;
import com.tssap.selena.cmf.internal.CodePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class WebProjectImpl
extends WebProject
implements IWebElement,
IDispatchSessionListener {
    private HierarchyHolder myHierarchyHolder;
    private HashSet myListeners = new HashSet();
    static final String SERVLET_CLASS = "javax.servlet.Servlet";
    static final String FILTER_CLASS = "javax.servlet.Filter";
    static final String HTTP_SESSION_LISTENER_CLASS = "javax.servlet.http.HttpSessionListener";
    static final String HTTP_SESSION_ATTRIBUTE_LISTENER_CLASS = "javax.servlet.http.HttpSessionAttributeListener";
    static final String HTTP_SESSION_BINDING_LISTENER_CLASS = "javax.servlet.http.HttpSessionBindingListener";
    static final String HTTP_SESSION_ACTIVATION_LISTENER_CLASS = "javax.servlet.http.HttpSessionActivationListener";
    static final String SERVLET_CONTEXT_LISTENER_CLASS = "javax.servlet.ServletContextListener";
    static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER_CLASS = "javax.servlet.ServletContextAttributeListener";
    private static final List CLASS_NAMES = Arrays.asList("javax.servlet.Servlet", "javax.servlet.Filter", "javax.servlet.http.HttpSessionListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.ServletContextListener", "javax.servlet.ServletContextAttributeListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionBindingListener");
    private HashMap myServletTypes2Servlets;
    private HashMap myFilterTypes2Filters;
    private HashMap myHttpSessionListenerTypes2Listeners;
    private HashMap myHttpSessionAttributeListenerTypes2Listeners;
    private HashMap myHttpSessionActivationListenerTypes2Listeners;
    private HashMap myHttpSessionBindingListenerTypes2Listeners;
    private HashMap myServletContextListenerTypes2Listeners;
    private HashMap myServletContextAttributeListenerTypes2Listeners;
    private HashMap myHierarchies = new HashMap();
    private DeltaBuilder myDeltaBuilder = new DeltaBuilder();
    private static final String DEFAULT_TEMPLATE = "";
    private static final String TEMPLATE_PATH = "templates/DefaultJSP.template";
    private static String ourTemplate;

    protected void setProject(IProject project) {
        super.setProject(project);
        UtilsPlugin.getDefault().addDispatchSessionListener((IDispatchSessionListener)this);
        IWebModelListener[] synchronizers = WebImplPlugin.getDefault().getSynchronizeListeners();
        int i = 0;
        while (i < synchronizers.length) {
            IWebModelListener next = synchronizers[i];
            this.addWebModelListener(next);
            ++i;
        }
    }

    public void dispatch(IWebElementAcceptor acceptor) {
        acceptor.consider((WebProject)this);
    }

    protected void configureProject() throws CoreException {
        if (!this.isJ2eeApiAvailable()) {
            this.addJ2eeLibrary();
        }
        CodePlugin.getInstance().getTemplateEngine();
    }

    public void deltaArrived() {
    }

    public void deltaProcessed() {
        this.myDeltaBuilder.fire();
    }

    public IServlet[] getServlets() {
        if (this.myServletTypes2Servlets == null) {
            this.addServlets();
        }
        return this.myServletTypes2Servlets.values().toArray(new IServlet[this.myServletTypes2Servlets.size()]);
    }

    public IServlet getServlet(String fullQualifiedName) {
        if (this.myServletTypes2Servlets == null) {
            this.addServlets();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IServlet)this.myServletTypes2Servlets.get(type);
    }

    public IServlet createServlet(String packageName, String servletClassName, GenericServletCreationOptions options, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment servletClassPackage = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (servletClassPackage == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (servletClassName == null) {
            servletClassName = JDTUtils.generateDefaultName((IPackageFragment)servletClassPackage, (String)"Servlet");
        }
        try {
            WebTemplatesSupport.createGenericServletClass(servletClassPackage, servletClassName, options, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = servletClassPackage.getCompilationUnit(servletClassName + ".java").getType(servletClassName);
        return this.getServlet(createdType.getFullyQualifiedName());
    }

    public IServlet createHttpServlet(String packageName, String servletClassName, HttpServletCreationOptions options, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment servletClassPackage = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (servletClassPackage == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (servletClassName == null) {
            servletClassName = JDTUtils.generateDefaultName((IPackageFragment)servletClassPackage, (String)"HttpServlet");
        }
        try {
            WebTemplatesSupport.createHttpServletClass(servletClassPackage, servletClassName, options, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = servletClassPackage.getCompilationUnit(servletClassName + ".java").getType(servletClassName);
        return this.getServlet(createdType.getFullyQualifiedName());
    }

    private void addServlets() {
        this.myServletTypes2Servlets = new HashMap();
        Collection types = this.getImplementingClasses(SERVLET_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateServlet(type);
        }
    }

    private IWebElement associateServlet(IType type) {
        ServletImpl servlet = new ServletImpl(this, type);
        if (servlet.exists()) {
            servlet.adding();
            this.myServletTypes2Servlets.put(type, servlet);
            return servlet;
        }
        return null;
    }

    private IWebElement disassociateServlet(IType type) {
        ServletImpl result = (ServletImpl)((Object)this.myServletTypes2Servlets.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IJSP[] getJSPs() {
        Collection jspFiles = WebImplPlugin.getDefault().getJSPFilesCache().getAllFilesForProject(this.getProject());
        ArrayList<JSPImpl> jsps = new ArrayList<JSPImpl>(jspFiles.size());
        Iterator it = jspFiles.iterator();
        while (it.hasNext()) {
            IFile next = (IFile)it.next();
            JSPImpl jsp = new JSPImpl(this, next);
            if (!jsp.exists()) continue;
            jsps.add(jsp);
        }
        return jsps.toArray(new IJSP[jsps.size()]);
    }

    public IJSP getJSP(IFile file) {
        JSPImpl result;
        Collection jsps = WebImplPlugin.getDefault().getJSPFilesCache().getAllFilesForProject(this.getProject());
        if (jsps.contains(file) && (result = new JSPImpl(this, file)).exists()) {
            return result;
        }
        return null;
    }

    public IJSP createJSP(final IFile file, IProgressMonitor m) throws WebModelException {
        if (file.exists()) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "File already exists"));
        }
        if (!file.getProject().isAccessible()) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Project must be open"));
        }
        if (m == null) {
            m = new NullProgressMonitor();
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FileUtils.createFolder((IContainer)file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    file.create((InputStream)new ByteArrayInputStream(WebProjectImpl.this.getJSPTemplate().getBytes()), false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
            }, m);
        }
        catch (CoreException e) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Exception occurred while creating enterprise application", e));
        }
        IJSP result = this.getJSP(file);
        if (result == null) {
            return null;
        }
        return result;
    }

    private String getJSPTemplate() {
        if (ourTemplate == null) {
            ourTemplate = FileUtils.getFileContents((String)TEMPLATE_PATH, (String)DEFAULT_TEMPLATE, (Plugin)WebImplPlugin.getDefault());
        }
        return ourTemplate;
    }

    void jspsAddedToProject(Collection files) {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IFile file = (IFile)it.next();
            this.myDeltaBuilder.myDelta.childAdded(new JSPImpl(this, file));
        }
    }

    void jspsRemovedFromProject(Collection files) {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IFile file = (IFile)it.next();
            this.myDeltaBuilder.myDelta.childRemoved(new JSPImpl(this, file));
        }
    }

    void flushJSPDelta() {
        this.myDeltaBuilder.fire();
    }

    public IFilter[] getFilters() {
        if (this.myFilterTypes2Filters == null) {
            this.addFilters();
        }
        return this.myFilterTypes2Filters.values().toArray(new IFilter[this.myFilterTypes2Filters.size()]);
    }

    public IFilter getFilter(String fullQualifiedName) {
        if (this.myFilterTypes2Filters == null) {
            this.addFilters();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IFilter)this.myFilterTypes2Filters.get(type);
    }

    public IFilter createFilter(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"Filter");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, FILTER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getFilter(createdType.getFullyQualifiedName());
    }

    private void addFilters() {
        this.myFilterTypes2Filters = new HashMap();
        Collection types = this.getImplementingClasses(FILTER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateFilter(type);
        }
    }

    private IWebElement associateFilter(IType type) {
        FilterImpl filter = new FilterImpl(this, type);
        if (filter.exists()) {
            filter.adding();
            this.myFilterTypes2Filters.put(type, filter);
            return filter;
        }
        return null;
    }

    private IWebElement disassociateFilter(IType type) {
        FilterImpl result = (FilterImpl)((Object)this.myFilterTypes2Filters.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IHttpSessionListener[] getHttpSessionListeners() {
        if (this.myHttpSessionListenerTypes2Listeners == null) {
            this.addHttpSessionListeners();
        }
        return this.myHttpSessionListenerTypes2Listeners.values().toArray(new IHttpSessionListener[this.myHttpSessionListenerTypes2Listeners.size()]);
    }

    public IHttpSessionListener getHttpSessionListener(String fullQualifiedName) {
        if (this.myHttpSessionListenerTypes2Listeners == null) {
            this.addHttpSessionListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IHttpSessionListener)this.myHttpSessionListenerTypes2Listeners.get(type);
    }

    public IHttpSessionListener createHttpSessionListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"HttpSessionListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, HTTP_SESSION_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getHttpSessionListener(createdType.getFullyQualifiedName());
    }

    private void addHttpSessionListeners() {
        this.myHttpSessionListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(HTTP_SESSION_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateHttpSessionListener(type);
        }
    }

    private IWebElement associateHttpSessionListener(IType type) {
        HttpSessionListenerImpl listener = new HttpSessionListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myHttpSessionListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateHttpSessionListener(IType type) {
        HttpSessionListenerImpl result = (HttpSessionListenerImpl)((Object)this.myHttpSessionListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IHttpSessionAttributeListener[] getHttpSessionAttributeListeners() {
        if (this.myHttpSessionAttributeListenerTypes2Listeners == null) {
            this.addHttpSessionAttributeListeners();
        }
        return this.myHttpSessionAttributeListenerTypes2Listeners.values().toArray(new IHttpSessionAttributeListener[this.myHttpSessionAttributeListenerTypes2Listeners.size()]);
    }

    public IHttpSessionAttributeListener getHttpSessionAttributeListener(String fullQualifiedName) {
        if (this.myHttpSessionAttributeListenerTypes2Listeners == null) {
            this.addHttpSessionAttributeListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IHttpSessionAttributeListener)this.myHttpSessionAttributeListenerTypes2Listeners.get(type);
    }

    public IHttpSessionAttributeListener createHttpSessionAttributeListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"HttpSessionAttributeListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, HTTP_SESSION_ATTRIBUTE_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getHttpSessionAttributeListener(createdType.getFullyQualifiedName());
    }

    private void addHttpSessionAttributeListeners() {
        this.myHttpSessionAttributeListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(HTTP_SESSION_ATTRIBUTE_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateHttpSessionAttributeListener(type);
        }
    }

    private IWebElement associateHttpSessionAttributeListener(IType type) {
        HttpSessionAttributeListenerImpl listener = new HttpSessionAttributeListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myHttpSessionAttributeListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateHttpSessionAttributeListener(IType type) {
        HttpSessionAttributeListenerImpl result = (HttpSessionAttributeListenerImpl)((Object)this.myHttpSessionAttributeListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IServletContextListener[] getServletContextListeners() {
        if (this.myServletContextListenerTypes2Listeners == null) {
            this.addServletContextListeners();
        }
        return this.myServletContextListenerTypes2Listeners.values().toArray(new IServletContextListener[this.myServletContextListenerTypes2Listeners.size()]);
    }

    public IServletContextListener getServletContextListener(String fullQualifiedName) {
        if (this.myServletContextListenerTypes2Listeners == null) {
            this.addServletContextListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IServletContextListener)this.myServletContextListenerTypes2Listeners.get(type);
    }

    public IServletContextListener createServletContextListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"ServletContextListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, SERVLET_CONTEXT_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getServletContextListener(createdType.getFullyQualifiedName());
    }

    public void addServletContextListeners() {
        this.myServletContextListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(SERVLET_CONTEXT_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateServletContextListener(type);
        }
    }

    private IWebElement associateServletContextListener(IType type) {
        ServletContextListenerImpl listener = new ServletContextListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myServletContextListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateServletContextListener(IType type) {
        ServletContextListenerImpl result = (ServletContextListenerImpl)((Object)this.myServletContextListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IServletContextAttributeListener[] getServletContextAttributeListeners() {
        if (this.myServletContextAttributeListenerTypes2Listeners == null) {
            this.addServletContextAttributeListeners();
        }
        return this.myServletContextAttributeListenerTypes2Listeners.values().toArray(new IServletContextAttributeListener[this.myServletContextAttributeListenerTypes2Listeners.size()]);
    }

    public IServletContextAttributeListener getServletContextAttributeListener(String fullQualifiedName) {
        if (this.myServletContextAttributeListenerTypes2Listeners == null) {
            this.addServletContextAttributeListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IServletContextAttributeListener)this.myServletContextAttributeListenerTypes2Listeners.get(type);
    }

    public IServletContextAttributeListener createServletContextAttributeListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"ServletContextAttributeListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, SERVLET_CONTEXT_ATTRIBUTE_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getServletContextAttributeListener(createdType.getFullyQualifiedName());
    }

    public void addServletContextAttributeListeners() {
        this.myServletContextAttributeListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(SERVLET_CONTEXT_ATTRIBUTE_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateServletContextAttributeListener(type);
        }
    }

    private IWebElement associateServletContextAttributeListener(IType type) {
        ServletContextAttributeListenerImpl listener = new ServletContextAttributeListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myServletContextAttributeListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateServletContextAttributeListener(IType type) {
        ServletContextAttributeListenerImpl result = (ServletContextAttributeListenerImpl)((Object)this.myServletContextAttributeListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IHttpSessionActivationListener[] getHttpSessionActivationListeners() {
        if (this.myHttpSessionActivationListenerTypes2Listeners == null) {
            this.addHttpSessionActivationListeners();
        }
        return this.myHttpSessionActivationListenerTypes2Listeners.values().toArray(new IHttpSessionActivationListener[this.myHttpSessionActivationListenerTypes2Listeners.size()]);
    }

    public IHttpSessionActivationListener getHttpSessionActivationListener(String fullQualifiedName) {
        if (this.myHttpSessionActivationListenerTypes2Listeners == null) {
            this.addHttpSessionActivationListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IHttpSessionActivationListener)this.myHttpSessionActivationListenerTypes2Listeners.get(type);
    }

    public IHttpSessionActivationListener createHttpSessionActivationListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"HttpSessionActivationListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, HTTP_SESSION_ACTIVATION_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getHttpSessionActivationListener(createdType.getFullyQualifiedName());
    }

    public void addHttpSessionActivationListeners() {
        this.myHttpSessionActivationListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(HTTP_SESSION_ACTIVATION_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateHttpSessionActivationListener(type);
        }
    }

    private IWebElement associateHttpSessionActivationListener(IType type) {
        HttpSessionActivationListenerImpl listener = new HttpSessionActivationListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myHttpSessionActivationListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateHttpSessionActivationListener(IType type) {
        HttpSessionActivationListenerImpl result = (HttpSessionActivationListenerImpl)((Object)this.myHttpSessionActivationListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public IHttpSessionBindingListener[] getHttpSessionBindingListeners() {
        if (this.myHttpSessionBindingListenerTypes2Listeners == null) {
            this.addHttpSessionBindingListeners();
        }
        return this.myHttpSessionBindingListenerTypes2Listeners.values().toArray(new IHttpSessionBindingListener[this.myHttpSessionBindingListenerTypes2Listeners.size()]);
    }

    public IHttpSessionBindingListener getHttpSessionBindingListener(String fullQualifiedName) {
        if (this.myHttpSessionBindingListenerTypes2Listeners == null) {
            this.addHttpSessionBindingListeners();
        }
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)fullQualifiedName);
        return (IHttpSessionBindingListener)this.myHttpSessionBindingListenerTypes2Listeners.get(type);
    }

    public IHttpSessionBindingListener createHttpSessionBindingListener(String packageName, String name, String baseClassFQN, IProgressMonitor monitor) throws WebModelException {
        IPackageFragment f = JDTUtils.findSourcePackage((IJavaProject)this.getJavaProject(), (String)packageName);
        if (f == null) {
            throw new WebModelException(WebProjectImpl.newStatus(4, "Package [" + packageName + "] should exist before type creation"));
        }
        if (name == null) {
            name = JDTUtils.generateDefaultName((IPackageFragment)f, (String)"HttpSessionBindingListener");
        }
        try {
            WebTemplatesSupport.createClass(f, name, baseClassFQN, HTTP_SESSION_BINDING_LISTENER_CLASS, monitor);
        }
        catch (CoreException ce) {
            WebModelException me = new WebModelException(ce.getStatus());
            throw me;
        }
        IType createdType = f.getCompilationUnit(name + ".java").getType(name);
        return this.getHttpSessionBindingListener(createdType.getFullyQualifiedName());
    }

    public void addHttpSessionBindingListeners() {
        this.myHttpSessionBindingListenerTypes2Listeners = new HashMap();
        Collection types = this.getImplementingClasses(HTTP_SESSION_BINDING_LISTENER_CLASS);
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            this.associateHttpSessionBindingListener(type);
        }
    }

    private IWebElement associateHttpSessionBindingListener(IType type) {
        HttpSessionBindingListenerImpl listener = new HttpSessionBindingListenerImpl(this, type);
        if (listener.exists()) {
            listener.adding();
            this.myHttpSessionBindingListenerTypes2Listeners.put(type, listener);
            return listener;
        }
        return null;
    }

    private IWebElement disassociateHttpSessionBindingListener(IType type) {
        HttpSessionBindingListenerImpl result = (HttpSessionBindingListenerImpl)((Object)this.myHttpSessionBindingListenerTypes2Listeners.remove(type));
        if (result != null) {
            result.removed();
        }
        return result;
    }

    public HierarchyHolder getHierarchyHolder() {
        if (this.myHierarchyHolder == null) {
            this.myHierarchyHolder = new HierarchyHolder(this.getJavaProject());
        }
        return this.myHierarchyHolder;
    }

    public boolean exists() {
        return this.getProject().isAccessible();
    }

    public void delete(IProgressMonitor monitor) throws WebModelException {
        throw new WebModelException(WebProjectImpl.newStatus(4, "Web projects should be deleted directly"));
    }

    public WebProject getWebProject() {
        return this;
    }

    public IWebElement getParent() {
        return this;
    }

    public void addWebModelListener(IWebModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeWebModelListener(IWebModelListener listener) {
        this.myListeners.remove(listener);
    }

    private Collection getImplementingClasses(String className) {
        AutoRefreshableTypeHierarchy hierarchy = this.getRefreshableHierarchy(className);
        if (hierarchy == null || !hierarchy.exists()) {
            return Collections.EMPTY_SET;
        }
        return hierarchy.getAllClasses();
    }

    private AutoRefreshableTypeHierarchy getRefreshableHierarchy(String className) {
        AutoRefreshableTypeHierarchy result = (AutoRefreshableTypeHierarchy)this.myHierarchies.get(className);
        if (result == null) {
            result = this.getHierarchyHolder().getTypeHierarchy(className);
            result.addHierarchyListener((IDetailedHierarchyChangedListener)this.myDeltaBuilder);
        }
        return result;
    }

    private static IStatus newStatus(int severity, String msg, Throwable e) {
        return new Status(severity, WebImplPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, msg, e);
    }

    private static IStatus newStatus(int severity, String msg) {
        return WebProjectImpl.newStatus(severity, msg, null);
    }

    private void fire(WebElementDelta delta) {
        WebModelChangedEvent evt = new WebModelChangedEvent((Object)this, (IWebElementDelta)delta);
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((IWebModelListener)it.next()).webModelChanged(evt);
        }
    }

    void registerChanged(SourceWebElement element) {
        this.myDeltaBuilder.myDelta.elementChanged(element);
    }

    void removed(WebElement element) {
        this.myDeltaBuilder.myDelta.childRemoved(element);
    }

    void registerRenamed(SourceWebElement oldImage, SourceWebElement newImage) {
        this.myDeltaBuilder.myDelta.elementRenamed(oldImage, newImage);
    }

    void added(WebElement element) {
        this.myDeltaBuilder.myDelta.childAdded(element);
    }

    public String[] getDdpNames() {
        return null;
    }

    public Object getDdp(String name) {
        return null;
    }

    public String getDdpAsString(String name) {
        return null;
    }

    public boolean canSetDdp(String name, Object value) {
        return false;
    }

    public void setDdp(String name, Object value) {
    }

    public void applyDdp(Object entity, String name) {
    }

    public void applyDdps(Object entity) {
    }

    protected String[] getRequiredLibraries() {
        return new String[]{AbstractJ2eeProject.OUR_WEB_LIB, AbstractJ2eeProject.OUR_EJB_LIB, AbstractJ2eeProject.OUR_JMS_LIB, AbstractJ2eeProject.OUR_JDBC_LIB};
    }

    public void refreshHierarchies() {
        Iterator it = CLASS_NAMES.iterator();
        while (it.hasNext()) {
            String nextClass = (String)it.next();
            this.refreshHierarchy(nextClass);
        }
    }

    private void refreshHierarchy(String className) {
        AutoRefreshableTypeHierarchy hierarchy = this.getRefreshableHierarchy(className);
        if (hierarchy != null) {
            hierarchy.update();
        }
    }

    public boolean isImported() {
        return false;
    }

    private class DeltaBuilder
    implements IDetailedHierarchyChangedListener {
        private WebElementDelta myDelta;

        private DeltaBuilder() {
            this.myDelta = new WebElementDelta(WebProjectImpl.this);
        }

        public synchronized void hierarchyChanged(DetailedHierarchyChangedEvent evt) {
            String type = evt.getHierarchy().getTypeName();
            int typeIndex = CLASS_NAMES.indexOf(type);
            Iterator it = evt.getAddedItems().iterator();
            while (it.hasNext()) {
                IType next = (IType)it.next();
                this.associate(next, typeIndex);
            }
            Iterator it2 = evt.getRemovedItems().iterator();
            while (it2.hasNext()) {
                IType next = (IType)it2.next();
                this.disassociate(next, typeIndex);
            }
            this.fire();
        }

        private void associate(IType type, int index) {
            IWebElement added2;
            switch (index) {
                case 0: {
                    added2 = WebProjectImpl.this.associateServlet(type);
                    break;
                }
                case 1: {
                    added2 = WebProjectImpl.this.associateFilter(type);
                    break;
                }
                case 2: {
                    added2 = WebProjectImpl.this.associateHttpSessionListener(type);
                    break;
                }
                case 3: {
                    added2 = WebProjectImpl.this.associateHttpSessionAttributeListener(type);
                    break;
                }
                case 4: {
                    added2 = WebProjectImpl.this.associateServletContextListener(type);
                    break;
                }
                case 5: {
                    added2 = WebProjectImpl.this.associateServletContextAttributeListener(type);
                    break;
                }
                case 6: {
                    IWebElement added2 = WebProjectImpl.this.associateHttpSessionActivationListener(type);
                }
                case 7: {
                    IWebElement added2 = WebProjectImpl.this.associateHttpSessionBindingListener(type);
                }
                default: {
                    return;
                }
            }
            if (added2 != null) {
                this.myDelta.childAdded((WebElement)added2);
            }
        }

        private void disassociate(IType type, int index) {
            IWebElement removed2;
            switch (index) {
                case 0: {
                    removed2 = WebProjectImpl.this.disassociateServlet(type);
                    break;
                }
                case 1: {
                    removed2 = WebProjectImpl.this.disassociateFilter(type);
                    break;
                }
                case 2: {
                    removed2 = WebProjectImpl.this.disassociateHttpSessionListener(type);
                    break;
                }
                case 3: {
                    removed2 = WebProjectImpl.this.disassociateHttpSessionAttributeListener(type);
                    break;
                }
                case 4: {
                    removed2 = WebProjectImpl.this.disassociateServletContextListener(type);
                    break;
                }
                case 5: {
                    removed2 = WebProjectImpl.this.disassociateServletContextAttributeListener(type);
                    break;
                }
                case 6: {
                    IWebElement removed2 = WebProjectImpl.this.disassociateHttpSessionActivationListener(type);
                }
                case 7: {
                    IWebElement removed2 = WebProjectImpl.this.disassociateHttpSessionBindingListener(type);
                }
                default: {
                    return;
                }
            }
            if (removed2 != null) {
                this.myDelta.childRemoved((WebElement)removed2);
            }
        }

        private void fire() {
            if (!this.myDelta.isEmpty()) {
                WebElementDelta delta = this.myDelta;
                this.myDelta = new WebElementDelta(WebProjectImpl.this);
                WebProjectImpl.this.fire(delta);
            }
        }
    }
}

