/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.IWebMethodContainer;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.j2ee.internal.core.web.WebMethod;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public abstract class WebMethodContainer
extends SourceWebElement
implements IWebMethodContainer {
    protected HashMap myMethods;

    public WebMethodContainer(WebProjectImpl project, IType type) {
        super(project, type);
    }

    public IWebMethod[] getMethods() {
        this.addMethods();
        return this.myMethods.values().toArray(new IWebMethod[this.myMethods.size()]);
    }

    public IWebMethod getMethod(String name) {
        this.addMethods();
        return (IWebMethod)this.myMethods.get(name);
    }

    protected abstract void addMethod(MethodDescriptor var1, IMethod var2);

    protected final void addMethods(MethodDescriptor[] descriptors) {
        IType me = this.getType();
        if (me == null || !me.exists()) {
            return;
        }
        int i = 0;
        while (i < descriptors.length) {
            IMethod method = me.getMethod(descriptors[i].getName(), JDTUtils.java2jdt((String[])descriptors[i].getParameters(), (boolean)true));
            IMethod[] existingMethods = me.findMethods(method);
            if (existingMethods != null && existingMethods.length > 0) {
                this.addMethod(descriptors[i], existingMethods[0]);
            }
            ++i;
        }
    }

    protected final void addMethods() {
        if (this.myMethods != null) {
            return;
        }
        this.myMethods = new HashMap();
        this.addMethods(this.getDescriptors());
    }

    public void elementChanged(IJavaElementDelta delta) {
        if (this.myMethods != null) {
            HashMap oldMethods = this.myMethods;
            this.myMethods = null;
            this.addMethods();
            HashMap newState = this.myMethods;
            this.myMethods = oldMethods;
            Iterator it = this.myMethods.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                String key = (String)next.getKey();
                WebMethod oldMethod = (WebMethod)((Object)next.getValue());
                WebMethod newMethod = (WebMethod)((Object)newState.get(key));
                if (newMethod != null) continue;
                this.internalGetProject().removed(oldMethod);
                it.remove();
            }
            Iterator it2 = newState.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry next = it2.next();
                String key = (String)next.getKey();
                if (this.myMethods.containsKey(key)) continue;
                WebMethod addedMethod = (WebMethod)((Object)next.getValue());
                this.internalGetProject().added(addedMethod);
                this.myMethods.put(key, addedMethod);
            }
        }
        super.elementChanged(delta);
    }

    protected IWebMethod createMethod(IType baseType, MethodDescriptor d, IProgressMonitor monitor) throws WebModelException {
        if (d == null) {
            return null;
        }
        if (baseType == null) {
            return null;
        }
        try {
            JDTUtils.addMethod((IType)this.getType(), (IMethod)this.findMethod(baseType, d), (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            if (e instanceof WebModelException) {
                throw (WebModelException)e;
            }
            throw new WebModelException("Exception occurred while creating method", (Throwable)e);
        }
        return this.getMethod(d.getName());
    }

    private IMethod findMethod(IType baseType, MethodDescriptor d) {
        IMethod raw = baseType.getMethod(d.getName(), JDTUtils.java2jdt((String[])d.getParameters(), (boolean)true));
        IMethod[] proposals = baseType.findMethods(raw);
        if (proposals == null || proposals.length != 1) {
            return null;
        }
        return proposals[0];
    }

    protected MethodDescriptor getDescriptor(String methodName) {
        MethodDescriptor[] descriptors = this.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (methodName.equals(descriptors[i].getName())) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    protected abstract MethodDescriptor[] getDescriptors();

    protected static class MethodDescriptor {
        private String myName;
        private String[] myParams;

        public MethodDescriptor(String name, String[] params) {
            this.myName = name;
            this.myParams = params;
        }

        protected String getName() {
            return this.myName;
        }

        protected String[] getParameters() {
            return this.myParams;
        }
    }
}

