/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.j2ee.internal.core.web.WebElement;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class WebMethod
extends WebElement
implements IWebMethod {
    private IMethod myMethod;
    private SourceWebElement myParent;

    public WebMethod(SourceWebElement parent, IMethod method) {
        super((WebProjectImpl)parent.getWebProject());
        this.myMethod = method;
        this.myParent = parent;
    }

    public void delete(IProgressMonitor monitor) throws WebModelException {
        if (!new ReadOnlinessValidator((IMember[])new IMethod[]{this.myMethod}).canModify()) {
            throw WebModelException.newCannotModify();
        }
        try {
            this.myMethod.delete(true, monitor);
        }
        catch (JavaModelException e) {
            throw new WebModelException("Exception occurred while deleting method", (Throwable)e);
        }
    }

    public boolean isImported() {
        return this.getParent().isImported();
    }

    public void dispatch(IWebElementAcceptor acceptor) {
        acceptor.consider((IWebMethod)this);
    }

    public IMethod getMethod() {
        return this.myMethod;
    }

    public String getName() {
        return this.myMethod.getElementName();
    }

    public boolean exists() {
        return this.myMethod.exists();
    }

    public IWebElement getParent() {
        return this.myParent;
    }
}

