/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.IProjectDependencyListener;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.IWebModelListener;
import com.tssap.j2ee.internal.core.web.JSPFilesCache;
import com.tssap.j2ee.internal.core.web.WebResourceChangedListener;
import java.util.ArrayList;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class WebImplPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static WebImplPlugin ourInstance;
    private JSPFilesCache myJSPFilesCache;
    private WebResourceChangedListener myWebResourceChangedListener;
    private IWebModelListener[] myListeners;
    private static final String SYNCHRONIZERS_EXTENSION_POINT = "webSynchronizers";
    private static final String SYNCHRONIZER = "synchronizer";
    private static final String CLASS = "class";

    public WebImplPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static WebImplPlugin getDefault() {
        return ourInstance;
    }

    public void startup() throws CoreException {
        super.startup();
        this.myJSPFilesCache = new JSPFilesCache();
        this.myWebResourceChangedListener = new WebResourceChangedListener();
        UtilsPlugin.getDefault().addDispatchedResourceDeltaListener((IResourceChangeListener)this.myWebResourceChangedListener);
        UtilsPlugin.getDefault().getProjectDependencyCache().addProjectDependencyListener((IProjectDependencyListener)this.myWebResourceChangedListener);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        UtilsPlugin.getDefault().getProjectDependencyCache().removeProjectDependencyListener((IProjectDependencyListener)this.myWebResourceChangedListener);
        UtilsPlugin.getDefault().removeDispatchedResourceDeltaListener((IResourceChangeListener)this.myWebResourceChangedListener);
    }

    public JSPFilesCache getJSPFilesCache() {
        return this.myJSPFilesCache;
    }

    public void revisit() {
    }

    public void revisit(String msg) {
    }

    public IWebModelListener[] getSynchronizeListeners() {
        if (this.myListeners == null) {
            this.myListeners = this.loadSynchronizeListeners();
        }
        return this.myListeners;
    }

    private IWebModelListener[] loadSynchronizeListeners() {
        ArrayList<IWebModelListener> result = new ArrayList<IWebModelListener>();
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(SYNCHRONIZERS_EXTENSION_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] confs = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < confs.length) {
                if (SYNCHRONIZER.equals(confs[j].getName())) {
                    try {
                        result.add((IWebModelListener)confs[j].createExecutableExtension(CLASS));
                    }
                    catch (Throwable couldNotInstantiate) {
                        WebImplPlugin.logError("Could not instantiate synchronize listener", couldNotInstantiate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IWebModelListener[result.size()]);
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        WebImplPlugin instance = WebImplPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        WebImplPlugin.log(1, text);
    }

    public static void logError(String text) {
        WebImplPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        WebImplPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        WebImplPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        WebImplPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        WebImplPlugin instance = WebImplPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            WebImplPlugin.log(type, text, new Throwable());
        } else {
            WebImplPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        WebImplPlugin instance = WebImplPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

