/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementDelta;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.web.WebElement;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class WebElementDelta
implements IWebElementDelta {
    private WebProjectImpl myProject;
    private Collection myAddedChildren = new HashSet();
    private Collection myRemovedChildren = new HashSet();
    private Collection myChangedChildren = new HashSet();
    private Collection myRenamedOldElements = new ArrayList();
    private Collection myRenamedNewElements = new ArrayList();

    public WebElementDelta(WebProjectImpl project) {
        this.myProject = project;
    }

    public WebProject getProject() {
        return this.myProject;
    }

    public IWebElement[] getAddedElements() {
        return this.myAddedChildren.toArray(new IWebElement[this.myAddedChildren.size()]);
    }

    public IWebElement[] getRemovedElements() {
        return this.myRemovedChildren.toArray(new IWebElement[this.myRemovedChildren.size()]);
    }

    public IWebElement[][] getRenamedElements() {
        IWebElement[][] result = new IWebElement[][]{this.myRenamedOldElements.toArray(new IWebElement[this.myRenamedOldElements.size()]), this.myRenamedNewElements.toArray(new IWebElement[this.myRenamedNewElements.size()])};
        return result;
    }

    public IWebElement[] getChangedElements() {
        return this.myChangedChildren.toArray(new IWebElement[this.myChangedChildren.size()]);
    }

    void childAdded(WebElement addedChild) {
        this.myRemovedChildren.remove((Object)addedChild);
        this.myAddedChildren.add(addedChild);
    }

    void childRemoved(WebElement removedChild) {
        this.myAddedChildren.remove((Object)removedChild);
        this.myRemovedChildren.add(removedChild);
    }

    void elementChanged(WebElement changedElement) {
        this.myChangedChildren.add(changedElement);
    }

    void elementRenamed(IWebElement oldElement, IWebElement newElement) {
        this.myRenamedOldElements.add(oldElement);
        this.myRenamedNewElements.add(newElement);
    }

    public boolean isEmpty() {
        return this.myAddedChildren.size() + this.myRemovedChildren.size() + this.myChangedChildren.size() + this.myRenamedNewElements.size() == 0;
    }
}

