/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.IDispatchedJavaDeltaListener;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.core.web.ICopiedSourceWebElement;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.ejb.util.JavaCommentParserFactory;
import com.tssap.j2ee.internal.core.ejb.util.JavaDeltaDispatcher;
import com.tssap.j2ee.internal.core.web.CopiedSourceWebElement;
import com.tssap.j2ee.internal.core.web.WebElement;
import com.tssap.j2ee.internal.core.web.WebImplPlugin;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.Enumeration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class SourceWebElement
extends WebElement
implements ISourceWebElement,
IDispatchedJavaDeltaListener {
    private Refactorer myRefactorer;
    private IType myType;
    private IJavaComment myJavaComment;
    private static final String HACK_WEB_DOMAIN = "com.tssap.j2ee.core.web";

    public SourceWebElement(WebProjectImpl project, IType type) {
        super(project);
        this.myType = type;
    }

    public IType getType() {
        return this.myType;
    }

    public String getTypeName() {
        return this.myType.getFullyQualifiedName();
    }

    public boolean canSetName(String name) {
        if (!this.exists()) {
            return false;
        }
        Refactorer refactorer = this.getRefactorer(name);
        if (!refactorer.canPerformNaive()) {
            this.myRefactorer = null;
            return false;
        }
        return true;
    }

    public String setName(String name) throws WebModelException {
        if (!this.canSetName(name)) {
            throw new WebModelException("Cannot set name");
        }
        this.myRefactorer = null;
        Refactorer refactorer = this.getRefactorer(name);
        if (!refactorer.canPerform()) {
            this.myRefactorer = null;
            return this.getTypeName();
        }
        String newTypeName = this.calculateTypeName(name);
        this.internalGetProject().registerRenamed(this.createReadOnlyCopy(this.getTypeName()), this.createReadOnlyCopy(newTypeName));
        try {
            try {
                refactorer.perform((IProgressMonitor)new NullProgressMonitor());
                String string = newTypeName;
                Object var6_6 = null;
                this.myRefactorer = null;
                return string;
            }
            catch (CoreException e) {
                throw new WebModelException(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.myRefactorer = null;
            throw throwable;
        }
    }

    private Refactorer getRefactorer(String name) {
        if (this.myRefactorer == null) {
            this.myRefactorer = this.createRefactorer(name);
        }
        return this.myRefactorer;
    }

    protected Refactorer createRefactorer(String name) {
        Refactorer result = this.newWebElementRefactorer(name);
        result.addRefactoringScheme((IMember)this.getType(), name);
        return result;
    }

    protected abstract Refactorer newWebElementRefactorer(String var1);

    protected abstract SourceWebElement createReadOnlyCopy(String var1);

    private String calculateTypeName(String name) {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return null;
        }
        int dotIndex = typeName.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return typeName.substring(0, dotIndex + 1) + name;
    }

    public boolean exists() {
        if (!this.myType.exists()) {
            return false;
        }
        return this.internalGetProject().getHierarchyHolder().getTypeHierarchy(this.getBaseInterfaceName()).contains(this.getType());
    }

    protected void adding() {
        super.adding();
        if (!this.myType.isBinary()) {
            JavaDeltaDispatcher.getInstance().addDispatchedDeltaListener((IJavaElement)this.myType.getCompilationUnit(), (IDispatchedJavaDeltaListener)this);
        }
    }

    protected void removed() {
        if (!this.myType.isBinary()) {
            JavaDeltaDispatcher.getInstance().removeDispatchedDeltaListener((IJavaElement)this.myType.getCompilationUnit(), (IDispatchedJavaDeltaListener)this);
        }
        super.removed();
    }

    protected IJavaComment getJavaComment() {
        if (this.myJavaComment == null) {
            this.myJavaComment = JavaCommentParserFactory.getJavaComment((IMember)this.myType);
        }
        return this.myJavaComment;
    }

    protected abstract String getBaseInterfaceName();

    public String toString() {
        return super.toString() + "[" + this.myType.getFullyQualifiedName() + "]{" + this.getBaseInterfaceName() + "}";
    }

    public void delete(IProgressMonitor monitor) throws WebModelException {
        try {
            if (this.myType.isBinary()) {
                throw new WebModelException(SourceWebElement.newStatus(4, "Cannot delete nibary type"));
            }
            JDTUtils.deleteType((IType)this.myType);
        }
        catch (JavaModelException e) {
            throw new WebModelException(SourceWebElement.newStatus(4, "Exception while deleting Java type", e));
        }
    }

    private static IStatus newStatus(int severity, String msg, Throwable e) {
        return new Status(severity, WebImplPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, msg, e);
    }

    private static IStatus newStatus(int severity, String msg) {
        return SourceWebElement.newStatus(severity, msg, null);
    }

    protected ITag getTag(String tag) {
        IJavaComment comment = this.getJavaComment();
        if (comment == null) {
            return null;
        }
        Enumeration enumeration = comment.getTags(tag);
        if (enumeration.hasMoreElements()) {
            return (ITag)enumeration.nextElement();
        }
        return null;
    }

    protected String getTagValue(String tagName) {
        ITag tag = this.getTag(tagName);
        if (tag == null) {
            return null;
        }
        return tag.getValue();
    }

    protected void setTagValue(String tagName, String tagValue) {
        IJavaComment comment = this.getJavaComment();
        if (comment == null) {
            return;
        }
        Enumeration enumeration = comment.getTags(tagName);
        if (enumeration.hasMoreElements()) {
            ((ITag)enumeration.nextElement()).setValue(tagValue);
        } else {
            comment.addTag(tagName, tagValue);
        }
        comment.synchronize(true);
    }

    public void elementChanged(IJavaElementDelta delta) {
        if (!this.exists()) {
            this.guessRename(delta);
            return;
        }
        this.myJavaComment = null;
        if (delta.getKind() == 4) {
            ((WebProjectImpl)this.getWebProject()).registerChanged(this);
        }
    }

    private void guessRename(IJavaElementDelta delta) {
        if ((delta.getFlags() & 0x20) == 0) {
            return;
        }
        IJavaElement element = delta.getElement();
        if (element == null) {
            return;
        }
        switch (element.getElementType()) {
            case 5: {
                this.guessCURename(delta);
                break;
            }
            case 4: {
                this.guessPackageRename(delta);
            }
        }
    }

    private void guessCURename(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (!element.equals(this.getType().getCompilationUnit())) {
            return;
        }
        IJavaElement movedToElement = delta.getMovedToElement();
        if (movedToElement == null || movedToElement.getElementType() != 5) {
            return;
        }
        ICompilationUnit newCU = (ICompilationUnit)movedToElement;
        String publicTypeName = JDTUtils.getPublicTypeName((ICompilationUnit)newCU);
        if (publicTypeName == null || publicTypeName.length() == 0) {
            return;
        }
        IType type = newCU.getType(publicTypeName);
        if (!type.exists()) {
            return;
        }
        WebImplPlugin.getDefault().revisit("Make sure it implements directly or indirectly the base type");
        ((WebProjectImpl)this.getWebProject()).registerRenamed(this.createReadOnlyCopy(this.getTypeName()), this.createReadOnlyCopy(type.getFullyQualifiedName()));
    }

    private void guessPackageRename(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (!element.equals(this.getType().getPackageFragment())) {
            return;
        }
        IJavaElement movedToElement = delta.getMovedToElement();
        if (movedToElement == null || movedToElement.getElementType() != 4) {
            return;
        }
        IPackageFragment newPF = (IPackageFragment)movedToElement;
        String beanClassName = this.getType().getElementName();
        String packageName = newPF.getElementName();
        IType type = JDTUtils.findType((IJavaProject)this.getJavaProject(), (String)packageName, (String)beanClassName);
        if (type == null || !type.exists()) {
            return;
        }
        WebImplPlugin.getDefault().revisit("Make sure it implements directly or indirectly IEnterpriseBean");
        ((WebProjectImpl)this.getWebProject()).registerRenamed(this.createReadOnlyCopy(this.getTypeName()), this.createReadOnlyCopy(type.getFullyQualifiedName()));
    }

    public IJavaProject getJavaProject() {
        return this.getWebProject().getJavaProject();
    }

    protected Object getDdpSource() {
        return this.getType();
    }

    public boolean canCopy(boolean forPackage) {
        return !this.getType().isBinary();
    }

    public boolean canCut(boolean forPackage) {
        return !this.getType().isBinary();
    }

    public ICopiedSourceWebElement copy(boolean forPackage) throws WebModelException {
        return new CopiedSourceWebElement(this, forPackage, false);
    }

    public ICopiedSourceWebElement cut(boolean forPackage) throws WebModelException {
        return new CopiedSourceWebElement(this, forPackage, true);
    }

    protected abstract DescriptorEntity[] getAssembledOccurrences();

    protected final Entity[] getAssembledOccurrencesAsEntities() {
        DescriptorEntity[] assembled = this.getAssembledOccurrences();
        if (assembled == null) {
            return null;
        }
        Entity[] result = new Entity[assembled.length];
        int i = 0;
        while (i < assembled.length) {
            result[i] = this.getEntity(assembled[i]);
            ++i;
        }
        return result;
    }

    protected abstract Entity getEntity(DescriptorEntity var1);

    protected final Model hackGetModel() {
        return ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)this.getWebProject().getProject().getName()));
    }

    protected final UniqueName hackCreateUniqueNameOfThis() {
        return ModelAccess.createUniqueName((String)HACK_WEB_DOMAIN, (String)this.hackGetSubDomain(), (String)this.getType().getPackageFragment().getElementName(), (String)this.getType().getElementName(), null);
    }

    private String hackGetSubDomain() {
        final String[] resultHolder = new String[1];
        this.dispatch((IWebElementAcceptor)new IWebElementAcceptor.Stub(){

            public void consider(IServlet servlet) {
                resultHolder[0] = "com.tssap.j2ee.core.web.Servlet";
            }

            public void consider(IFilter filter) {
                resultHolder[0] = "com.tssap.j2ee.core.web.Filter";
            }

            public void consider(IServletContextAttributeListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.ServletContextAttributeListener";
            }

            public void consider(IServletContextListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.ServletContextListener";
            }

            public void consider(IHttpSessionAttributeListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.HttpSessionAttributeListener";
            }

            public void consider(IHttpSessionActivationListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.HttpSessionActivationListener";
            }

            public void consider(IHttpSessionBindingListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.HttpSessionBindingListener";
            }

            public void consider(IHttpSessionListener listener) {
                resultHolder[0] = "com.tssap.j2ee.core.web.HttpSessionListener";
            }
        });
        return resultHolder[0];
    }

    public void setDdp(String name, Object value) {
        super.setDdp(name, value);
        this.internalGetProject().registerChanged(this);
    }

    public boolean isImported() {
        return !this.getWebProject().getJavaProject().equals(this.myType.getJavaProject());
    }
}

