/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.refactoring.Refactorer;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.core.webapp.AssembledInfoFinder;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.web.ServletMethod;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.j2ee.internal.core.web.WebMethodContainer;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import com.tssap.j2ee.internal.core.web.refactoring.ServletRefactorer;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public class ServletImpl
extends WebMethodContainer
implements IServlet {
    private static final String HTTP_SERVLET_TYPE = "javax.servlet.http.HttpServlet";
    private Boolean myIsHttpServlet;
    private static final WebMethodContainer.MethodDescriptor[] COMMON_METHODS = new WebMethodContainer.MethodDescriptor[]{new WebMethodContainer.MethodDescriptor("init", new String[]{"ServletConfig"}), new WebMethodContainer.MethodDescriptor("destroy", new String[0])};
    private static final WebMethodContainer.MethodDescriptor[] GENERIC_SPECIFIC_METHODS = new WebMethodContainer.MethodDescriptor[]{new WebMethodContainer.MethodDescriptor("service", new String[]{"ServletRequest", "ServletResponse"})};
    private static final WebMethodContainer.MethodDescriptor[] HTTP_SPECIFIC_METHODS = new WebMethodContainer.MethodDescriptor[]{new WebMethodContainer.MethodDescriptor("service", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doGet", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doHead", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doPost", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doPut", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doDelete", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doOptions", new String[]{"HttpServletRequest", "HttpServletResponse"}), new WebMethodContainer.MethodDescriptor("doTrace", new String[]{"HttpServletRequest", "HttpServletResponse"})};
    private static final WebMethodContainer.MethodDescriptor[] HTTP_METHODS = new WebMethodContainer.MethodDescriptor[HTTP_SPECIFIC_METHODS.length + COMMON_METHODS.length];
    private static final WebMethodContainer.MethodDescriptor[] GENERIC_METHODS = new WebMethodContainer.MethodDescriptor[GENERIC_SPECIFIC_METHODS.length + COMMON_METHODS.length];

    public ServletImpl(WebProjectImpl project, IType type) {
        super(project, type);
    }

    protected SourceWebElement createReadOnlyCopy(final String fqn) {
        return new ServletImpl((WebProjectImpl)this.getWebProject(), null){

            public IType getType() {
                return null;
            }

            public String getTypeName() {
                return fqn;
            }
        };
    }

    public void dispatch(IWebElementAcceptor acceptor) {
        acceptor.consider((IServlet)this);
    }

    protected String getBaseInterfaceName() {
        return "javax.servlet.Servlet";
    }

    public boolean exists() {
        if (!super.exists()) {
            return false;
        }
        try {
            if (Flags.isAbstract((int)this.getType().getFlags())) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    public void elementChanged(IJavaElementDelta delta) {
        if (this.myIsHttpServlet != null) {
            boolean isHttp = this.myIsHttpServlet;
            this.myIsHttpServlet = null;
            boolean newIsHttp = this.isHttpServlet();
            if (isHttp != newIsHttp) {
                ((WebProjectImpl)this.getWebProject()).registerChanged(this);
            }
        }
        super.elementChanged(delta);
    }

    public boolean isHttpServlet() {
        if (this.myIsHttpServlet == null) {
            this.myIsHttpServlet = new Boolean(this.internalIsHttpServlet());
        }
        return this.myIsHttpServlet;
    }

    private boolean internalIsHttpServlet() {
        WebProjectImpl myProjectImpl = (WebProjectImpl)this.getWebProject();
        ITypeHierarchy hierarchy = myProjectImpl.getHierarchyHolder().getTypeHierarchy(this.getBaseInterfaceName()).getHierarchy();
        if (hierarchy == null) {
            return false;
        }
        IType[] supertypes = hierarchy.getSupertypes(this.getType());
        if (supertypes == null) {
            return false;
        }
        int i = 0;
        while (i < supertypes.length) {
            if (HTTP_SERVLET_TYPE.equals(supertypes[i].getFullyQualifiedName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Refactorer newWebElementRefactorer(String newName) {
        return new ServletRefactorer(this, newName);
    }

    public IWebMethod createServletMethod(String methodName, IProgressMonitor monitor) throws WebModelException {
        if (!this.exists()) {
            throw new WebModelException("The servlet does not exist");
        }
        if (this.getType().isBinary()) {
            throw new WebModelException("Cannot create methods in a binary servlet class");
        }
        WebMethodContainer.MethodDescriptor d = this.getDescriptor(methodName);
        boolean httpSpecific = "init".equals(methodName) || "destroy".equals(methodName) ? false : ("service".equals(methodName) ? this.isHttpServlet() : true);
        String typeName = httpSpecific ? HTTP_SERVLET_TYPE : this.getBaseInterfaceName();
        IType type = JDTUtils.findType((IJavaProject)this.getWebProject().getJavaProject(), (String)typeName);
        return this.createMethod(type, d, monitor);
    }

    protected void addMethod(WebMethodContainer.MethodDescriptor descriptor, IMethod method) {
        ServletMethod child = new ServletMethod(this, method);
        if (child.exists()) {
            this.myMethods.put(descriptor.getName(), child);
        }
    }

    protected WebMethodContainer.MethodDescriptor[] getDescriptors() {
        if (this.isHttpServlet()) {
            return HTTP_METHODS;
        }
        return GENERIC_METHODS;
    }

    protected DescriptorEntity[] getAssembledOccurrences() {
        return AssembledInfoFinder.findAssembledServlets((IServlet)this);
    }

    protected Entity getEntity(DescriptorEntity descriptorEntity) {
        UniqueName result = WebAppModelMetaInfo.getServlet((Model)this.hackGetModel(), (UniqueName)this.hackCreateUniqueNameOfThis(), (UniqueName)WebAppModelMetaInfo.getWebApp((IFile)descriptorEntity.getDocument().getFile()), (String)((Servlet)descriptorEntity).getName());
        return ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((IResource)descriptorEntity.getDocument().getFile())).findEntity(result);
    }

    protected String getDdpKey() {
        return "Servlet";
    }

    static {
        System.arraycopy(COMMON_METHODS, 0, HTTP_METHODS, 0, COMMON_METHODS.length);
        System.arraycopy(HTTP_SPECIFIC_METHODS, 0, HTTP_METHODS, COMMON_METHODS.length, HTTP_SPECIFIC_METHODS.length);
        System.arraycopy(COMMON_METHODS, 0, GENERIC_METHODS, 0, COMMON_METHODS.length);
        System.arraycopy(GENERIC_SPECIFIC_METHODS, 0, GENERIC_METHODS, COMMON_METHODS.length, GENERIC_SPECIFIC_METHODS.length);
    }
}

