/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.web.WebProjectImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class JSPFilesCache {
    private HashMap myProjects2Files = new HashMap();
    private HashMap myProjects2AllFiles = new HashMap();
    private static final String JSP_FILE_EXTENSION = "jsp";
    private static final String WEB_CONTENT_FOLDER = "webContent";
    private static final Path WEB_CONTENT_PATH = new Path("webContent");

    public Collection getAllFilesForProject(IProject project) {
        HashSet result = (HashSet)this.myProjects2AllFiles.get(project);
        if (result == null) {
            result = new HashSet();
            HashSet<IProject> projects = new HashSet<IProject>();
            projects.add(project);
            projects.addAll(UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencedProjects(project));
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                IProject next = (IProject)it.next();
                result.addAll(this.getFilesForProjectOnly(next));
            }
            this.myProjects2AllFiles.put(project, result);
        }
        return result;
    }

    void filesRemovedFromProject(IProject project, Collection files) {
        Collection allFilesForProject = (Collection)this.myProjects2AllFiles.get(project);
        if (allFilesForProject != null) {
            allFilesForProject.removeAll(files);
            WebProject webProject = WebProject.getInstance((IProject)project);
            if (webProject != null && webProject instanceof WebProjectImpl) {
                ((WebProjectImpl)webProject).jspsRemovedFromProject(files);
            }
        }
    }

    void filesAddedToProject(IProject project, Collection files) {
        Collection allFilesForProject = (Collection)this.myProjects2AllFiles.get(project);
        if (allFilesForProject != null) {
            allFilesForProject.addAll(files);
            WebProject webProject = WebProject.getInstance((IProject)project);
            if (webProject != null && webProject instanceof WebProjectImpl) {
                ((WebProjectImpl)webProject).jspsAddedToProject(files);
            }
        }
    }

    void fileRemoved(IFile file) {
        IProject project = file.getProject();
        HashSet<IProject> affectedProjects = new HashSet<IProject>();
        affectedProjects.add(project);
        affectedProjects.addAll(UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(project));
        Iterator it = affectedProjects.iterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            this.filesRemovedFromProject(next, Collections.singleton(file));
        }
        if (this.hasFilesForProject(project)) {
            this.getFilesForProjectOnly(project).remove(file);
        }
    }

    void fileAdded(IFile file) {
        IProject project = file.getProject();
        if (this.hasFilesForProject(project)) {
            this.getFilesForProjectOnly(project).add(file);
        }
        HashSet<IProject> affectedProjects = new HashSet<IProject>();
        affectedProjects.add(project);
        affectedProjects.addAll(UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(project));
        Iterator it = affectedProjects.iterator();
        while (it.hasNext()) {
            IProject next = (IProject)it.next();
            this.filesAddedToProject(next, Collections.singleton(file));
        }
    }

    boolean hasFilesForProject(IProject project) {
        return this.myProjects2Files.containsKey(project);
    }

    boolean hasAllFilesForProject(IProject project) {
        return this.myProjects2AllFiles.containsKey(project);
    }

    Collection getFilesForProjectOnly(IProject project) {
        Collection result = (Collection)this.myProjects2Files.get(project);
        if (result == null) {
            result = this.buildFilesForProjectOnly(project);
            this.myProjects2Files.put(project, result);
        }
        return result;
    }

    private Collection buildFilesForProjectOnly(IProject project) {
        if (!project.isAccessible()) {
            return new HashSet();
        }
        JSPFileFinder finder = new JSPFileFinder();
        try {
            project.accept((IResourceVisitor)finder);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return finder.getFiles();
    }

    public static boolean isJSPFile(IResource resource) {
        return resource.getType() == 1 && JSPFilesCache.isJSPFile((IFile)resource);
    }

    public static boolean isJSPFile(IFile file) {
        return JSPFilesCache.isValidJSPLocation((IResource)file) && JSP_FILE_EXTENSION.equals(file.getFileExtension());
    }

    public static boolean isValidJSPLocation(IResource fileOrFolder) {
        return WEB_CONTENT_PATH.isPrefixOf(fileOrFolder.getProjectRelativePath());
    }

    private class JSPFileFinder
    implements IResourceVisitor {
        private HashSet myCollectedFiles = new HashSet();

        private JSPFileFinder() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() != 4 && !JSPFilesCache.isValidJSPLocation(resource)) {
                return false;
            }
            if (JSPFilesCache.isJSPFile(resource)) {
                this.myCollectedFiles.add(resource);
            }
            return true;
        }

        public Collection getFiles() {
            return this.myCollectedFiles;
        }
    }
}

