/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.web;

import com.tssap.j2ee.core.utils.ParametrizedHashBag;
import com.tssap.j2ee.core.utils.clipboard.ClipboardElement;
import com.tssap.j2ee.core.utils.clipboard.ModelClipboard;
import com.tssap.j2ee.core.web.ICopiedSourceWebElement;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.web.SourceWebElement;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class CopiedSourceWebElement
implements ICopiedSourceWebElement {
    private SourceWebElement mySource;
    private boolean myIsCut;
    private boolean myForPackage;
    private Entity myTypeAsCopiedEntity;
    private ParametrizedHashBag myAssembledCopies = new ParametrizedHashBag(class$java$util$ArrayList == null ? (class$java$util$ArrayList = CopiedSourceWebElement.class$("java.util.ArrayList")) : class$java$util$ArrayList);
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;
    static /* synthetic */ Class class$java$util$ArrayList;

    public CopiedSourceWebElement(SourceWebElement source, boolean forPackage, boolean isCut) throws WebModelException {
        this.mySource = source;
        this.myIsCut = isCut;
        this.myForPackage = forPackage;
        Entity typeAsEntity = (Entity)this.getType().getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = CopiedSourceWebElement.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        this.processAssembledOccurrences(source.getAssembledOccurrencesAsEntities());
        this.myTypeAsCopiedEntity = typeAsEntity == null || this.myForPackage ? null : this.cutOrCopy(typeAsEntity);
    }

    private void processAssembledOccurrences(Entity[] assembledEntities) throws WebModelException {
        if (assembledEntities == null) {
            return;
        }
        int i = 0;
        while (i < assembledEntities.length) {
            if (assembledEntities[i] != null && !this.canCutOrCopy(assembledEntities[i])) {
                throw new WebModelException("Could not copy/cut assembled occurrence");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < assembledEntities.length) {
            if (assembledEntities[i2] != null) {
                Entity parent = assembledEntities[i2].getParent();
                Entity copy = this.cutOrCopy(assembledEntities[i2]);
                if (copy != null) {
                    this.myAssembledCopies.add((Object)parent, (Object)copy);
                } else {
                    System.err.println("Could copy/cut assembled occurrence, but failed to... Result of paste may be incorrect");
                }
            }
            ++i2;
        }
    }

    private Entity cutOrCopy(Entity source) {
        if (this.myIsCut) {
            return source.cut();
        }
        return source.copy();
    }

    private boolean canCutOrCopy(Entity source) {
        if (this.myIsCut) {
            return source.canCut();
        }
        return source.canCopy();
    }

    public boolean canPaste(IPackageFragment pf) {
        if (pf.isReadOnly()) {
            return false;
        }
        if (this.myForPackage) {
            return true;
        }
        if (this.myTypeAsCopiedEntity == null) {
            return false;
        }
        Entity packageAsEntity = (Entity)pf.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = CopiedSourceWebElement.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        if (packageAsEntity == null) {
            return false;
        }
        if (!packageAsEntity.canPaste((Element)this.myTypeAsCopiedEntity)) {
            return false;
        }
        String fakeNonExistentClassName = this.createFakeNonExistentClassName();
        Iterator it = this.myAssembledCopies.keyIterator();
        while (it.hasNext()) {
            Entity parent = (Entity)it.next();
            Collection list = this.myAssembledCopies.safeGet((Object)parent);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                Entity copiedEntity = (Entity)it2.next();
                ClipboardElement clipboardEntity = ModelClipboard.getElement((CopyUniqueName)((CopyUniqueName)copiedEntity.getUniqueName()));
                clipboardEntity.setPropertyValue(this.getClassRefProperty(), fakeNonExistentClassName);
                if (parent.canPaste((Element)copiedEntity)) continue;
                return false;
            }
        }
        return true;
    }

    private String createFakeNonExistentClassName() {
        return String.valueOf(System.currentTimeMillis());
    }

    public ISourceWebElement paste(IPackageFragment pf) throws WebModelException {
        IType newType = null;
        if (!this.myForPackage) {
            Entity packageAsEntity = (Entity)pf.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = CopiedSourceWebElement.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
            Entity newTypeAsEntity = (Entity)packageAsEntity.paste((Element)this.myTypeAsCopiedEntity);
            if (newTypeAsEntity == null) {
                return null;
            }
            newType = (IType)ElementUtil.getJavaElement((Element)newTypeAsEntity);
        } else {
            String typeName = JDTUtils.getTypeName((String)this.mySource.getTypeName());
            newType = pf.getCompilationUnit(typeName + ".java").findPrimaryType();
        }
        if (newType == null || !newType.exists()) {
            throw new WebModelException("Could not paste");
        }
        Iterator it = this.myAssembledCopies.keyIterator();
        while (it.hasNext()) {
            Entity parent = (Entity)it.next();
            Collection list = this.myAssembledCopies.safeGet((Object)parent);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                Entity copiedEntity = (Entity)it2.next();
                ClipboardElement clipboardEntity = ModelClipboard.getElement((CopyUniqueName)((CopyUniqueName)copiedEntity.getUniqueName()));
                clipboardEntity.setPropertyValue(this.getClassRefProperty(), newType.getFullyQualifiedName());
                parent.paste((Element)copiedEntity);
            }
        }
        return this.instantiate(newType);
    }

    private ISourceWebElement instantiate(IType type) {
        final String typeFQN = type.getFullyQualifiedName();
        final ISourceWebElement[] resultHolder = new ISourceWebElement[1];
        this.mySource.dispatch((IWebElementAcceptor)new IWebElementAcceptor.Stub(){

            public void consider(IServlet servlet) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getServlet(typeFQN);
            }

            public void consider(IFilter filter) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getFilter(typeFQN);
            }

            public void consider(IServletContextAttributeListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getServletContextAttributeListener(typeFQN);
            }

            public void consider(IServletContextListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getServletContextListener(typeFQN);
            }

            public void consider(IHttpSessionAttributeListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getHttpSessionAttributeListener(typeFQN);
            }

            public void consider(IHttpSessionActivationListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getHttpSessionActivationListener(typeFQN);
            }

            public void consider(IHttpSessionBindingListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getHttpSessionBindingListener(typeFQN);
            }

            public void consider(IHttpSessionListener listener) {
                resultHolder[0] = CopiedSourceWebElement.this.getWebProject().getHttpSessionListener(typeFQN);
            }
        });
        return resultHolder[0];
    }

    private String getClassRefProperty() {
        final String[] resultHolder = new String[1];
        this.mySource.dispatch((IWebElementAcceptor)new IWebElementAcceptor.Stub(){

            public void consider(IServlet servlet) {
                resultHolder[0] = "servletClassRef";
            }

            public void consider(IFilter filter) {
                resultHolder[0] = "filterClassRef";
            }

            public void consider(IServletContextAttributeListener listener) {
                resultHolder[0] = "listenerClassRef";
            }

            public void consider(IServletContextListener listener) {
                resultHolder[0] = "listenerClassRef";
            }

            public void consider(IHttpSessionAttributeListener listener) {
                resultHolder[0] = "listenerClassRef";
            }

            public void consider(IHttpSessionActivationListener listener) {
                resultHolder[0] = "listenerClassRef";
            }

            public void consider(IHttpSessionBindingListener listener) {
                resultHolder[0] = "listenerClassRef";
            }

            public void consider(IHttpSessionListener listener) {
                resultHolder[0] = "listenerClassRef";
            }
        });
        return resultHolder[0];
    }

    public IType getType() {
        return this.mySource.getType();
    }

    public String getTypeName() {
        return this.mySource.getTypeName();
    }

    public String setName(String name) throws WebModelException {
        return this.getTypeName();
    }

    public boolean canSetName(String name) {
        return false;
    }

    public boolean canCopy(boolean forPackage) {
        return false;
    }

    public boolean canCut(boolean forPackage) {
        return false;
    }

    public ICopiedSourceWebElement copy(boolean forPackage) throws WebModelException {
        return null;
    }

    public ICopiedSourceWebElement cut(boolean forPackage) throws WebModelException {
        return null;
    }

    public WebProject getWebProject() {
        return this.mySource.getWebProject();
    }

    public IWebElement getParent() {
        return this.mySource.getParent();
    }

    public boolean exists() {
        return true;
    }

    public void delete(IProgressMonitor monitor) throws WebModelException {
        if (this.myTypeAsCopiedEntity != null) {
            this.myTypeAsCopiedEntity.delete();
        }
        Iterator it = this.myAssembledCopies.keyIterator();
        while (it.hasNext()) {
            Collection list = this.myAssembledCopies.safeGet(it.next());
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                ((Entity)it2.next()).delete();
            }
        }
    }

    public void dispatch(IWebElementAcceptor acceptor) {
    }

    public boolean canSetDdp(String name, Object value) {
        return false;
    }

    public void setDdp(String name, Object value) {
    }

    public String[] getDdpNames() {
        return null;
    }

    public Object getDdp(String name) {
        return null;
    }

    public String getDdpAsString(String name) {
        return null;
    }

    public void applyDdp(Object entity, String name) {
    }

    public void applyDdps(Object entity) {
    }

    public boolean isImported() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

